/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LevelService;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelListDto;
import com.ella.resource.dto.request.GetLevelInfoRequest;
import com.ella.resource.dto.request.UpdateLevelRequest;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u7b49\u7ea7\u76f8\u5173\u63a5\u53e3")
public class LevelRest {
    private static final Logger log = LogManager.getLogger(LevelRest.class);
    @Autowired
    private LevelService levelService;

    @ApiOperation(value="\u83b7\u53d6\u7b49\u7ea7\u5217\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u7b49\u7ea7\u5217\u8868\u63a5\u53e3--LiBin", response=LevelListDto.class)
    @RequestMapping(path={"getLevelList/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> getLevelList() {
        ResponseParams result = this.levelService.getLevelList();
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b49\u7ea7\u8be6\u60c5\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u7b49\u7ea7\u8be6\u60c5\u63a5\u53e3--LiBin", response=LevelDto.class)
    @RequestMapping(path={"getLevelInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLevelInfo(@RequestBody GetLevelInfoRequest request) {
        ResponseParams result = this.levelService.getLevelInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7b49\u7ea7\u4fee\u6539\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u7b49\u7ea7\u4fee\u6539\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"updateLevel/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateLevel(@RequestBody UpdateLevelRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.levelService.updateLevel(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7b49\u7ea7\u786e\u8ba4\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u7b49\u7ea7\u786e\u8ba4\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"doSureLevel/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> doSureLevel(@RequestBody GetLevelInfoRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.levelService.doSureLevel(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u53ef\u7528\u7b49\u7ea7\u4fe1\u606f--APP", notes="APP\u67e5\u8be2\u8bf4\u6709\u53ef\u7528\u7b49\u7ea7\u4fe1\u606f\u63a5\u53e3--\u97e9\u8302\u4e30", response=LevelDto.class)
    @RequestMapping(path={"level/all-enable/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> allEnableLevels() {
        return RestResponseUtils.jointRestResponse((ResponseParams)this.levelService.allEnableLevels());
    }

    @ApiOperation(value="\u84dd\u601d\u6307\u6570\u7c7b\u522b--APP", notes="\u84dd\u601d\u6307\u6570\u7c7b\u522b-wangshuzheng", response=String.class)
    @RequestMapping(value={"/getLexileResTypeCodeList/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> getLexileResTypeCodeList() {
        return RestResponseUtils.jointRestResponse((ResponseParams)this.levelService.getLexileResTypeCodeList());
    }
}

