/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.common.api.BaseBookService;
import com.ella.common.dto.BaseBookDto;
import com.ella.common.dto.BaseBookListRes;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.PicBookService;
import com.ella.resource.dto.getBookShelvesFlagDto;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/baseBook/"})
@Api(description="\u52a8\u753b\u4e66")
public class BaseBookRest {
    private static final Logger log = LogManager.getLogger(BaseBookRest.class);
    @Autowired
    private BaseBookService baseBookService;
    @Autowired
    private PicBookService picBookService;

    @ApiOperation(value="\u52a8\u753b\u4e66\u5217\u8868-\u5206\u9875--zln", response=BaseBookDto.class)
    @RequestMapping(value={"v1/baseBookList"}, method={RequestMethod.POST})
    public ResponseEntity<?> baseBookList(@RequestBody BaseBookListRes res) {
        ResponseParams responseParams = this.baseBookService.baseBookList(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u52a8\u753b\u4e66\u83b7\u53d6\u8be6\u60c5\u9875--zln", response=BaseBookDto.class)
    @RequestMapping(value={"v1/getBookInfo"}, method={RequestMethod.GET})
    public ResponseEntity getBookInfo(@RequestParam(value="id") String id) {
        ResponseParams bookInfo = this.baseBookService.getBookInfo(id);
        return RestResponseUtils.jointRestResponse((ResponseParams)bookInfo);
    }

    @ApiOperation(value="push book--LiBin", response=BaseBookDto.class)
    @RequestMapping(value={"v1/enBookPush"}, method={RequestMethod.GET})
    public ResponseEntity enBookPush(@RequestParam(value="bookCode") String bookCode) {
        Boolean result = this.baseBookService.enBookPush(bookCode);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u4e66\u4e0a\u4e0b\u67b6\u72b6\u6001", response=BaseBookDto.class)
    @RequestMapping(value={"v1/getBookShelvesFlag"}, method={RequestMethod.POST})
    public ResponseEntity getBookShelvesFlag(@RequestBody getBookShelvesFlagDto request) {
        ResponseParams result = this.picBookService.getBookShelvesFlag(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

