/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.pay;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.api.PayService;
import com.ella.order.dto.order.PayMethodEnum;
import io.swagger.annotations.Api;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/en/pay_out/"})
@RestController
@Api(description="\u5fae\u4fe1\u56de\u8c03")
public class WxpayCallbackRest {
    private static final Logger log = LogManager.getLogger(WxpayCallbackRest.class);
    @Autowired
    private PayService payService;

    @RequestMapping(value={"wxpay/callback"})
    public ResponseEntity<String> callback(HttpServletRequest request, HttpServletResponse response) {
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03begin");
        String bodyStr = this.readInputStream(request);
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03request bodyStr:{}", (Object)JSONObject.toJSONString((Object)bodyStr));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", bodyStr);
        ResponseParams result = this.payService.callBack(PayMethodEnum.WX_PAY, map);
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03end result:{}", (Object)result);
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return new ResponseEntity(result.getData(), HttpStatus.OK);
        }
        return new ResponseEntity(result.getData(), HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStream(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        ServletInputStream is = null;
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            is = request.getInputStream();
            reader = new InputStreamReader((InputStream)request.getInputStream(), "utf-8");
            br = new BufferedReader(reader);
            String str = "";
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            log.debug("\u5fae\u4fe1\u8f93\u5165\u6d41\u89e3\u6790\u7ed3\u679c:" + sb);
            br.close();
            reader.close();
            is.close();
            is = null;
        }
        catch (UnsupportedEncodingException e) {
            log.debug("\u5fae\u4fe1\u8f93\u5165\u6d41\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            e.printStackTrace();
        }
        catch (IOException e) {
            log.debug("\u5fae\u4fe1\u5b57\u7b26\u6d41\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

