/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.order;

import com.ella.frame.common.dto.HeadParamDto;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.order.api.CreateOrderService;
import com.ella.order.api.OrderService;
import com.ella.order.dto.order.CreateOrderRequest;
import com.ella.order.dto.order.EllaCoinHistoryDto;
import com.ella.order.dto.order.GetOrderDetailRequest;
import com.ella.order.dto.order.GetOrderListByPageRequest;
import com.ella.order.dto.order.OrderFullDto;
import com.ella.order.dto.order.OrderTypeEnum;
import com.ella.order.dto.order.creatorder.AlipayCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.EllapayCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.IapCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.WxpayCreateOrderResultDto;
import com.ella.resource.config.HeadParamUtil;
import com.ella.rest.util.NetworkUtil;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/order/"})
@Api(description="\u8ba2\u5355\u670d\u52a1")
public class OrderRest {
    private static final Logger log = LogManager.getLogger(OrderRest.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private CreateOrderService createOrderService;

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u8ba2\u5355\u5217\u8868,\u652f\u6301\u5206\u9875", notes="\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u5546\u54c1\u5217\u8868,\u652f\u6301\u5206\u9875-chenshuai \u6ce8\uff1a1.\u7cfb\u7edf\u652f\u6301\u7684\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5927200\u6761 2.\u9488\u5bf9\u5206\u9875\u67e5\u8be2\uff0c\u8fd4\u56de\u7ed3\u679c\u96c6\u6570\u636e\u7ed3\u6784\u4ee5\u5177\u4f53\u8fd4\u56de\u62a5\u6587\u4e3a\u51c6", response=OrderFullDto.class)
    @RequestMapping(path={"getOrderListByPage/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> getOrderListByPage(@RequestBody GetOrderListByPageRequest req) {
        ResponseParams result = this.orderService.getOrderListByPage(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5", notes="\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5-chenshuai", response=OrderFullDto.class)
    @RequestMapping(path={"getOrderDetail/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> getOrderDetail(@RequestBody GetOrderDetailRequest req) {
        ResponseParams result = this.orderService.getOrderDetail(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u67e5\u8be2ella\u5e01\u6536\u652f\u8bb0\u5f55", notes="APP-\u67e5\u8be2ella\u5e01\u6536\u652f\u8bb0\u5f55-chenshuai", response=EllaCoinHistoryDto.class)
    @RequestMapping(path={"getEllaCoinHistory/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getEllaCoinHistory(HttpServletRequest request) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)request);
        ResponseParams result = this.orderService.getEllaCoinHistory(initialization.getUid());
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u521b\u5efa\u9884\u4ed8\u6b3e\u8ba2\u5355", notes="APP-\u521b\u5efa\u9884\u4ed8\u6b3e\u8ba2\u5355-chenshuai (\u6ce8:\u521b\u5efa\u6240\u6709\u7c7b\u578b\u8ba2\u5355\u90fd\u8d70\u6b64\u63a5\u53e3\uff0c\u5177\u4f53\u8fd4\u56de\u53c2\u6570\u53c2\u8003\u521b\u5efaella\u5e01\u652f\u4ed8/\u652f\u4ed8\u5305/\u5fae\u4fe1/iap \u5bf9\u5e94\u7684\u63a5\u53e3\u6587\u6863\u8fd4\u56de\u503c)")
    @RequestMapping(path={"createPayOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createPayOrder(@RequestBody CreateOrderRequest req, HttpServletRequest request) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)request);
        req.setUserId(initialization.getUid());
        this.initCreateOrderRequest(req, NetworkUtil.getIpAddress((HttpServletRequest)request));
        ResponseParams result = this.createOrderService.createOrder(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u521b\u5efaella\u5e01\u652f\u4ed8\u8ba2\u5355", notes="APP-\u521b\u5efaella\u5e01\u8d2d\u4e70\u8ba2\u5355-chenshuai", response=EllapayCreateOrderResultDto.class)
    @RequestMapping(path={"createEllaPayOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createEllaPayOrder(@RequestBody CreateOrderRequest req) {
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="APP-\u521b\u5efaiap\u652f\u4ed8\u8ba2\u5355", notes="APP-\u521b\u5efaiap\u652f\u4ed8\u8ba2\u5355-chenshuai \u6ce8\uff1a\u5165\u53c2\u4e0e\u521b\u5efaella\u5e01\u8ba2\u5355\u4e00\u6837\u3002\u6b64\u5904\u5206\u63a5\u53e3\u53ea\u662f\u4e3a\u4e86\u751f\u6210\u6587\u6863\u9700\u8981", response=IapCreateOrderResultDto.class)
    @RequestMapping(path={"createIapPayOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createIapPayOrder(@RequestBody CreateOrderRequest req) {
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="APP-\u521b\u5efa\u652f\u4ed8\u5b9d\u652f\u4ed8\u8ba2\u5355", notes="APP-\u521b\u5efa\u652f\u4ed8\u5b9d\u652f\u4ed8\u8ba2\u5355-chenshuai \u6ce8\uff1a\u5165\u53c2\u4e0e\u521b\u5efaella\u5e01\u8ba2\u5355\u4e00\u6837\u3002\u6b64\u5904\u5206\u63a5\u53e3\u53ea\u662f\u4e3a\u4e86\u751f\u6210\u6587\u6863\u9700\u8981", response=AlipayCreateOrderResultDto.class)
    @RequestMapping(path={"createAliPayOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createAliPayOrder(@RequestBody CreateOrderRequest req) {
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="APP-\u521b\u5efa\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355", notes="APP-\u521b\u5efa\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355-chenshuai \u6ce8\uff1a\u5165\u53c2\u4e0e\u521b\u5efaella\u5e01\u8ba2\u5355\u4e00\u6837\u3002\u6b64\u5904\u5206\u63a5\u53e3\u53ea\u662f\u4e3a\u4e86\u751f\u6210\u6587\u6863\u9700\u8981", response=WxpayCreateOrderResultDto.class)
    @RequestMapping(path={"createWxpayOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createWxpayOrder(@RequestBody CreateOrderRequest req) {
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(value="APP-\u95ef\u5173\u4f1a\u5458\u9884\u4ed8\u6b3e\u8ba2\u5355", notes="APP-\u95ef\u5173\u4f1a\u5458\u9884\u4ed8\u6b3e\u8ba2\u5355-LiBin ")
    @RequestMapping(path={"createMapMemberOrder/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> createMapMemberOrder(@RequestBody CreateOrderRequest req, HttpServletRequest request) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)request);
        req.setUserId(initialization.getUid());
        this.initCreateOrderRequest(req, NetworkUtil.getIpAddress((HttpServletRequest)request));
        req.setOrderType(OrderTypeEnum.MAP_MEMBER.getCode());
        ResponseParams result = this.createOrderService.createOrder(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    private void initCreateOrderRequest(CreateOrderRequest req, String ip) {
        req.setIp(ip);
        if (StringUtils.isBlank((CharSequence)req.getClientType())) {
            req.setClientType(HeadParamUtil.getClientType());
        }
    }
}

