/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.exception;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import com.ella.frame.common.errorcode.OfflineEnum;
import com.ella.resource.config.HeadParamUtil;
import com.ella.rest.exception.LimitDeviceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.http.converter.jaxb.JaxbOAuth2ExceptionMessageConverter;
import org.springframework.security.oauth2.provider.error.OAuth2ExceptionRenderer;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

@Component
public class CustomOAuth2ExceptionRenderer
implements OAuth2ExceptionRenderer {
    private static final Logger log = LogManager.getLogger(CustomOAuth2ExceptionRenderer.class);
    private List<HttpMessageConverter<?>> messageConverters = this.geDefaultMessageConverters();

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void handleHttpEntityResponse(HttpEntity<?> responseEntity, ServletWebRequest webRequest) throws Exception {
        HttpHeaders entityHeaders;
        if (responseEntity == null) {
            return;
        }
        HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
        HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
        if (responseEntity instanceof ResponseEntity && outputMessage instanceof ServerHttpResponse) {
            ((ServerHttpResponse)outputMessage).setStatusCode(HttpStatus.OK);
        }
        if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
            outputMessage.getHeaders().putAll((Map)entityHeaders);
        }
        outputMessage.getHeaders().add("Access-Control-Allow-Origin", "*");
        Object body = responseEntity.getBody();
        if (body != null) {
            OAuth2Exception exp = (OAuth2Exception)body;
            ErrorMessage errorMessage = null;
            String msg = OfflineEnum.getMsgByCode((String)exp.getMessage());
            if (exp instanceof LimitDeviceException && StringUtils.isNotBlank((CharSequence)msg)) {
                errorMessage = ErrorMessage.valueOf((CommonRetCode)CommonRetCode.FORCED_OFFLINE_ERROR);
                errorMessage.setMessage(msg);
            } else {
                errorMessage = exp instanceof ClientAuthenticationException ? ErrorMessage.valueOf((CommonRetCode)CommonRetCode.SESSION_INVALID) : ErrorMessage.valueOf((CommonRetCode)CommonRetCode.UNAUTHORIZED);
            }
            log.info("request Authorization is {}", (Object)HeadParamUtil.getAuthorization());
            log.info("request path is {}", (Object)webRequest.getRequest().getServletPath());
            log.info("\u8eab\u4efd\u8ba4\u8bc1\u4e0d\u80fd\u901a\u8fc7\uff1a{}", (Throwable)exp);
            this.writeWithMessageConverters((Object)errorMessage, inputMessage, outputMessage);
        }
    }

    private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        Class<?> returnValueType = returnValue.getClass();
        ArrayList allSupportedMediaTypes = new ArrayList();
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            for (HttpMessageConverter messageConverter : this.messageConverters) {
                if (!messageConverter.canWrite(returnValueType, acceptedMediaType)) continue;
                messageConverter.write(returnValue, acceptedMediaType, outputMessage);
                if (log.isDebugEnabled()) {
                    MediaType contentType = outputMessage.getHeaders().getContentType();
                    if (contentType == null) {
                        contentType = acceptedMediaType;
                    }
                    log.error("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]");
                }
                return;
            }
        }
        for (HttpMessageConverter messageConverter : this.messageConverters) {
            allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
        }
        throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
    }

    private List<HttpMessageConverter<?>> geDefaultMessageConverters() {
        ArrayList result = new ArrayList();
        result.addAll(new RestTemplate().getMessageConverters());
        result.add((HttpMessageConverter<?>)new JaxbOAuth2ExceptionMessageConverter());
        return result;
    }

    private HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }

    private HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
        HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse();
        return new ServletServerHttpResponse(servletResponse);
    }
}

