/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.ella.rest.configuration.oss.OssConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;

@Component
public class AliOss {
    private static final Logger log = LogManager.getLogger(AliOss.class);
    @Autowired
    private OSSClient client;
    @Autowired
    private OssConfig ossConfig;

    public void deleteFile(String diskName, String key) {
        this.client.deleteObject(this.ossConfig.getOssBucketName(), diskName + key);
        log.info("\u5220\u9664" + this.ossConfig.getOssBucketName() + "\u4e0b\u7684\u6587\u4ef6" + diskName + key + "\u6210\u529f");
    }

    public String uploadObject2OSS(InputStream is, String fileName, long fileSize, String diskName) {
        Object resultStr = null;
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)is.available());
            PutObjectResult putResult = this.client.putObject(this.ossConfig.getOssBucketName(), diskName + fileName, is, metadata);
            return this.ossConfig.getOssShowUrl() + diskName + fileName;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String uploadObject2OSS(File file, String diskName) {
        Object resultStr = null;
        try {
            FileInputStream is = new FileInputStream(file);
            String fileName = file.getName();
            Long fileSize = file.length();
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)((InputStream)is).available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            PutObjectResult putResult = this.client.putObject(this.ossConfig.getOssBucketName(), diskName + fileName, (InputStream)is, metadata);
            return this.ossConfig.getOssShowUrl() + fileName;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String uploadObject2OSSByBase64ByDiskName(String fileBase64, String diskName, String fileName) {
        try {
            InputStream is = this.baseToInputStream(fileBase64);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)is.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            PutObjectResult putResult = this.client.putObject(this.ossConfig.getOssBucketName(), diskName + "/" + fileName, is, metadata);
            return this.ossConfig.getOssShowUrl() + diskName + "/" + fileName;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        if ("bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if ("gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if ("jpeg".equalsIgnoreCase(fileExtension) || "jpg".equalsIgnoreCase(fileExtension) || "png".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if ("html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if ("txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if ("vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if ("ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if ("doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if ("xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        if (".apk".equalsIgnoreCase(fileExtension)) {
            return "application/octet-stream";
        }
        if (".zip".equalsIgnoreCase(fileExtension)) {
            return "application/octet-stream";
        }
        if ("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-excel";
        }
        return "text/html";
    }

    private InputStream baseToInputStream(String base64string) {
        ByteArrayInputStream stream = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes1 = decoder.decodeBuffer(base64string);
            stream = new ByteArrayInputStream(bytes1);
        }
        catch (Exception e) {
            log.error("base64\u8f6cinputStream\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return stream;
    }
}

