/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.frame.cache.DistributedCache;
import com.ella.rest.configuration.CustomOAuth2AuthenticationManager;
import com.ella.rest.configuration.RequestHeadAuthorizationFilter;
import com.ella.rest.exception.CustomOAuth2ExceptionRenderer;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.oauth2.provider.error.OAuth2ExceptionRenderer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableResourceServer
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    @Autowired
    RedisConnectionFactory connectionFactory;
    @Autowired
    private RequestHeadAuthorizationFilter requestHeadAuthorizationFilter;
    @Value(value="${spring.profiles.active}")
    private String profilesActive;
    @Value(value="${token.renewhour}")
    private Integer renewHour;
    @Value(value="${permit.urls}")
    private String[] permitAllUrls;
    @Autowired
    private DistributedCache cache;
    @Autowired
    private TokenStore tokenStore;

    @Bean
    public TokenStore tokenStore() {
        return new RedisTokenStore(this.connectionFactory);
    }

    public void configure(HttpSecurity http) throws Exception {
        if (StringUtils.equalsIgnoreCase((CharSequence)"dev", (CharSequence)this.profilesActive) || StringUtils.equalsIgnoreCase((CharSequence)"test", (CharSequence)this.profilesActive)) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)((HttpSecurity)http.cors().disable()).csrf().disable()).requestMatchers().antMatchers(new String[]{"/**"})).and().authorizeRequests().antMatchers(this.getDefaultPermitAllUrls())).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/**"})).access("#oauth2.hasScope('read')").antMatchers(HttpMethod.PATCH, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.POST, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.PUT, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.DELETE, new String[]{"/**"})).access("#oauth2.hasScope('write')");
            http.addFilterBefore((Filter)this.requestHeadAuthorizationFilter, WebAsyncManagerIntegrationFilter.class);
            super.configure(http);
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)((HttpSecurity)http.cors().disable()).csrf().disable()).requestMatchers().antMatchers(new String[]{"/**"})).and().authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(new String[]{"/en/pay_out/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/**"})).access("#oauth2.hasScope('read')").antMatchers(HttpMethod.PATCH, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.POST, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.PUT, new String[]{"/**"})).access("#oauth2.hasScope('write')").antMatchers(HttpMethod.DELETE, new String[]{"/**"})).access("#oauth2.hasScope('write')");
            super.configure(http);
        }
    }

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        OAuth2AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
        authenticationEntryPoint.setExceptionRenderer((OAuth2ExceptionRenderer)new CustomOAuth2ExceptionRenderer());
        resources.tokenStore(this.tokenStore).authenticationEntryPoint((AuthenticationEntryPoint)authenticationEntryPoint);
        CustomOAuth2AuthenticationManager customManager = new CustomOAuth2AuthenticationManager();
        customManager.setClientDetailsService(this.clientDetails());
        customManager.setTokenServices(this.tokenServices());
        customManager.setTokenStore(this.tokenStore);
        customManager.setRenewHour(this.renewHour);
        customManager.setDistributedCache(this.cache);
        resources.authenticationManager((AuthenticationManager)customManager);
    }

    private ResourceServerTokenServices tokenServices() {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(this.tokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setClientDetailsService(this.clientDetails());
        return tokenServices;
    }

    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        return corsConfiguration;
    }

    private ClientDetailsService clientDetails() {
        return null;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    private String[] managementUrl() {
        return new String[0];
    }

    private String[] getFinalPermitAllUrls() {
        if (null == this.permitAllUrls || this.permitAllUrls.length < 1) {
            this.permitAllUrls = this.getDefaultPermitAllUrls();
            return this.permitAllUrls;
        }
        return this.permitAllUrls;
    }

    private String[] getDefaultPermitAllUrls() {
        return new String[]{"/**"};
    }
}

