/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.frame.common.util.Base64Util;
import feign.RequestInterceptor;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignHeadConfiguration {
    private static final Logger log = LogManager.getLogger(FeignHeadConfiguration.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                log.info("request method :{}", (Object)request.getServletPath());
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String name = (String)headerNames.nextElement();
                        String value = request.getHeader(name);
                        log.info("request head param {}:{}", (Object)name, (Object)value);
                        if (!"Authorization".equalsIgnoreCase(name) && !"enHeadParam".equalsIgnoreCase(name)) continue;
                        requestTemplate.header(name, new String[]{value});
                        if (!"enHeadParam".equalsIgnoreCase(name)) continue;
                        try {
                            log.info("request head param {}:{}", (Object)name, (Object)Base64Util.decodeBase64StrNew((String)value));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                }
            }
        };
    }
}

