/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.util.HeadParamTl;
import com.ella.user.utils.ContextUtils;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class DoHttpHeadInterceptor
implements HandlerInterceptor {
    private static final Logger log = LogManager.getLogger(DoHttpHeadInterceptor.class);
    private static final String CHANNEL_CODE = "channelCode";
    private static final String CLIENT_ROLE = "clientRole";
    private static final String CLIENT_TYPE = "clientType";
    private static final String DEVICE_NO = "deviceNo";
    private static final String RESOURCE = "resource";
    private static final String EMPTY = "";
    private static final String HEAD_PARAM_KEY = "HEAD_PARAM_KEY:";
    @Autowired
    private DistributedCache redisCache;
    private static PathMatcher pathMatcher = new AntPathMatcher();
    private final Set<String> interceptUrls;

    public DoHttpHeadInterceptor(Set<String> interceptUrls) {
        this.interceptUrls = interceptUrls;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (!this.matches(request.getRequestURI(), this.interceptUrls)) {
                return true;
            }
            String uid = ContextUtils.getUid();
            if (StringUtils.isBlank((CharSequence)uid)) {
                return true;
            }
            String key = HEAD_PARAM_KEY + uid;
            if (StringUtils.isNotBlank((CharSequence)this.redisCache.get(key))) {
                return true;
            }
            HeadParamTl headParamTl = new HeadParamTl();
            headParamTl.setChannelCode(Optional.ofNullable(request.getParameter(CHANNEL_CODE)).orElse(EMPTY));
            headParamTl.setClientRole(Optional.ofNullable(request.getParameter(CLIENT_ROLE)).orElse(EMPTY));
            headParamTl.setClientType(Optional.ofNullable(request.getParameter(CLIENT_TYPE)).orElse(EMPTY));
            headParamTl.setDeviceNo(Optional.ofNullable(request.getParameter(DEVICE_NO)).orElse(EMPTY));
            headParamTl.setResource(Optional.ofNullable(request.getParameter(RESOURCE)).orElse(EMPTY));
            this.redisCache.setObject2Json(key, (Object)headParamTl);
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            String uid = ContextUtils.getUid();
            if (StringUtils.isBlank((CharSequence)uid)) {
                return;
            }
            String key = HEAD_PARAM_KEY + uid;
            this.redisCache.del(key);
        }
        catch (Exception e) {
            return;
        }
    }

    private boolean matches(String lookupPath, Set<String> excludes) {
        if (excludes != null) {
            for (String pattern : excludes) {
                if (!pathMatcher.match(pattern, lookupPath)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

