/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.rest.exception.LimitDeviceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;

public class CustomServerTokenServices
extends DefaultTokenServices {
    private TokenStore tokenStore;
    private ClientDetailsService clientDetailsService;

    CustomServerTokenServices(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException, InvalidTokenException {
        OAuth2AccessToken accessToken = this.tokenStore.readAccessToken(accessTokenValue);
        if (accessToken == null) {
            throw new LimitDeviceException("Invalid access token: " + accessTokenValue);
        }
        if (accessToken.isExpired()) {
            this.tokenStore.removeAccessToken(accessToken);
            throw new LimitDeviceException("Access token expired: " + accessTokenValue);
        }
        OAuth2Authentication result = this.tokenStore.readAuthentication(accessToken);
        if (result == null) {
            throw new LimitDeviceException("Invalid access token: " + accessTokenValue);
        }
        if (this.clientDetailsService != null) {
            String clientId = result.getOAuth2Request().getClientId();
            try {
                this.clientDetailsService.loadClientByClientId(clientId);
            }
            catch (ClientRegistrationException e) {
                throw new LimitDeviceException("Client not valid: " + clientId, (Throwable)e);
            }
        }
        return result;
    }
}

