/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.aspect;

import com.ella.frame.common.dto.HeadParamDto;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.LexileLevelHistoryService;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.rest.aspect.SyncEvaluationTime;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.auth.AccountService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SyncEvaluationTimeAspect {
    private static final Logger log = LoggerFactory.getLogger(SyncEvaluationTimeAspect.class);
    @Value(value="${lexile.promotion.enableDays:60}")
    private Integer enableDays;
    @Autowired
    private LexileLevelHistoryService lexileLevelHistoryService;
    @Autowired
    AccountService accountService;
    @Autowired
    UserInfoService userInfoService;

    @Pointcut(value="@annotation(com.ella.rest.aspect.SyncEvaluationTime)")
    private void check() {
    }

    @Before(value="check()")
    public void doBefore(JoinPoint joinPoint) throws IOException {
        ResponseParams result;
        LexileLevelHistory data;
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        SyncEvaluationTime annotation = method.getAnnotation(SyncEvaluationTime.class);
        String functionName = annotation.functionName();
        log.info("\u8d26\u53f7\u540c\u6b65\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u5f00\u59cb------------functionName\uff1a" + functionName);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)request);
        String uid = initialization.getUid();
        ResponseParams historyInfo = new ResponseParams();
        Integer evaluationTime = 0;
        if (StringUtils.isNotBlank((CharSequence)uid)) {
            historyInfo = this.lexileLevelHistoryService.getHistoryInfo(uid);
            Integer num = this.accountService.getEvaluationTime(uid);
            evaluationTime = num == null ? 0 : num;
        }
        if ((data = (LexileLevelHistory)historyInfo.getData()) == null && evaluationTime == 1) {
            return;
        }
        if (data != null && data.getEndTime() == null) {
            log.error("\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u8bb0\u5f55\u4e0d\u5b58\u5728 \u6216\u8bc4\u6d4b\u65f6\u95f4\u4e0d\u5b58\u5728\uff01");
            return;
        }
        Date time = data.getEndTime();
        DateTime endTime = new DateTime((Object)time);
        DateTime dateTime = endTime.plusDays(this.enableDays.intValue());
        if (dateTime.isAfterNow()) {
            if (evaluationTime == 0) {
                log.info("\u8bc4\u6d4b\u65f6\u95f4\u9650\u5236\u672a\u5230\u671f\uff0c\u4e14\u8bc4\u6d4b\u6b21\u6570\u4e3a0 --- \u65e0\u9700\u66f4\u65b0\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570 uid : " + uid);
            }
            if (evaluationTime == 1) {
                result = this.accountService.updateEvaluationTime(uid, Integer.valueOf(0));
                if (((Boolean)result.getData()).booleanValue()) {
                    log.info("\u8bc4\u6d4b\u65f6\u95f4\u9650\u5236\u672a\u5230\u671f\uff0c\u4e14\u8bc4\u6d4b\u6b21\u6570\u4e3a1 ---\u77eb\u6b63\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u4e3a0--\u6210\u529f  uid : " + uid);
                }
                if (!((Boolean)result.getData()).booleanValue()) {
                    log.error("\u8bc4\u6d4b\u65f6\u95f4\u9650\u5236\u672a\u5230\u671f\uff0c\u4e14\u8bc4\u6d4b\u6b21\u6570\u4e3a1 ---\u77eb\u6b63\u66f4\u65b0\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u4e3a0--\u5931\u8d25  uid : " + uid);
                }
            }
        }
        if (dateTime.isBeforeNow()) {
            result = this.accountService.updateEvaluationTime(uid, Integer.valueOf(1));
            if (((Boolean)result.getData()).booleanValue()) {
                log.info("\u8bc4\u6d4b\u65f6\u95f4\u9650\u5236\u5230\u671f---\u66f4\u65b0\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u4e3a1--\u6210\u529f  uid : " + uid);
            }
            if (!((Boolean)result.getData()).booleanValue()) {
                log.error("\u8bc4\u6d4b\u65f6\u95f4\u9650\u5236\u5230\u671f---\u66f4\u65b0\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u4e3a1--\u5931\u8d25  uid : " + uid);
            }
        }
        log.info("\u8d26\u53f7\u540c\u6b65\u84dd\u601d\u8bc4\u6d4b\u6b21\u6570\u5b8c\u6210------------functionName\uff1a" + functionName);
    }
}

