/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.utils;

import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.utils.CoordCheckAndFillCallBack;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapUtils {
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);

    public static final <E> E get(java.util.Map map, Object key, E defaultValue) {
        Object o = map.get(key);
        if (o == null) {
            return defaultValue;
        }
        return (E)o;
    }

    public static <T> List<T> map2Java(Class<T> javaBean, List<java.util.Map> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            return null;
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        Object object = null;
        for (java.util.Map map : mapList) {
            if (map == null) continue;
            object = MapUtils.map2Java(javaBean, (java.util.Map)map);
            objectList.add(object);
        }
        return objectList;
    }

    public static <T> T map2Java(Class<T> javaBean, java.util.Map map) {
        if (map == null) {
            return null;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(javaBean);
            T obj = javaBean.newInstance();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null && propertyDescriptors.length > 0) {
                String propertyName = null;
                Object propertyValue = null;
                for (PropertyDescriptor pd : propertyDescriptors) {
                    propertyName = pd.getName();
                    if (!map.containsKey(propertyName)) continue;
                    propertyValue = map.get(propertyName);
                    pd.getWriteMethod().invoke(obj, propertyValue);
                }
                return obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static java.util.Map java2Map(Object javaBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(javaBean.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null && propertyDescriptors.length > 0) {
                String propertyName = null;
                Object propertyValue = null;
                for (PropertyDescriptor pd : propertyDescriptors) {
                    propertyName = pd.getName();
                    if ("class".equals(propertyName)) continue;
                    Method readMethod = pd.getReadMethod();
                    propertyValue = readMethod.invoke(javaBean, new Object[0]);
                    map.put(propertyName, propertyValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Boolean isDoingMap(UserMap currentMap, UserMap prevUserMap, String levelCode) {
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            levelCode = LevelEnum.LV1.getCode();
        }
        if (currentMap.getLevelCode().compareTo(levelCode) < 0) {
            log.info("isDoingMap---> currentMap levelCode < UserLevelCode");
            return Boolean.FALSE;
        }
        if ("DOING".equalsIgnoreCase(currentMap.getStatus())) {
            log.info("isDoingMap---> currentMap status is doing");
            return Boolean.TRUE;
        }
        if (Objects.isNull(prevUserMap) && "NOTSTARTED".equalsIgnoreCase(currentMap.getStatus())) {
            log.info("isDoingMap---> prevUserMap is null currentMap status is NOT-STARTED");
            return Boolean.TRUE;
        }
        if (Objects.nonNull(prevUserMap) && "PASS".equalsIgnoreCase(prevUserMap.getStatus()) && !"PASS".equalsIgnoreCase(currentMap.getStatus())) {
            log.info("isDoingMap---> prevUserMap is not null prevUserMap status is PASS");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static UserMission missionToUserMission(@NotNull Mission mission, @NotNull String uid, String levelCode) {
        UserMission userMission = new UserMission();
        if (Objects.nonNull(mission)) {
            BeanUtils.copyProperties((Object)mission, (Object)userMission);
        }
        if (Objects.nonNull(levelCode)) {
            userMission.setId(Long.valueOf(IdWrokerUtils.nextId()));
        }
        userMission.setStatus("NOTSTARTED");
        userMission.setLevelCode(Objects.nonNull(levelCode) ? levelCode : "");
        userMission.setUid(uid);
        userMission.setCreateTime(new Date());
        userMission.setUpdateTime(userMission.getCreateTime());
        userMission.setCorrectNum(Integer.valueOf(0));
        userMission.setScore(Float.valueOf(0.0f));
        userMission.setTestNum(Integer.valueOf(0));
        userMission.setVersion(mission.getVersion());
        return userMission;
    }

    public static UserMap mapToUserMap(@NotNull Map map, @NotNull String uid, Boolean isDoing) {
        UserMap userMap = new UserMap();
        if (Objects.nonNull(map)) {
            BeanUtils.copyProperties((Object)map, (Object)userMap);
        }
        if (isDoing.booleanValue()) {
            userMap.setStatus("DOING");
        } else {
            userMap.setStatus("NOTSTARTED");
        }
        userMap.setVersion(map.getVersion());
        userMap.setId(Long.valueOf(IdWrokerUtils.nextId()));
        userMap.setMapIndex(map.getLevelOrder());
        userMap.setStoneNum(Integer.valueOf(0));
        userMap.setUid(uid);
        userMap.setCreateTime(new Date());
        userMap.setUpdateTime(userMap.getCreateTime());
        return userMap;
    }

    public static void coordCheckAndFill(List<String> missionCoords, String lastCoord, CoordCheckAndFillCallBack back) {
        for (int i = 0; i < MapUtils.getCoordNum((int)Integer.valueOf(lastCoord)); ++i) {
            if (i % 3 == 0) continue;
            String firstNumOfCurrentCoord = i / 3 * 2 + 1 + "";
            String secondNumOfCurrentCoord = i % 3 - 1 + "";
            String currentCoord = firstNumOfCurrentCoord + "," + secondNumOfCurrentCoord;
            if (missionCoords.contains(currentCoord)) continue;
            back.doFill(currentCoord);
        }
    }

    private static int getCoordNum(int firstNumOfCurrentCoord) {
        int result = 0;
        for (int i = 0; i <= firstNumOfCurrentCoord; ++i) {
            result += i % 2 == 0 ? 1 : 2;
        }
        return result;
    }

    public static String getNextCoord(String currCoord) {
        String[] currCoordArr = currCoord.split(",");
        int firstCoordNum = Integer.parseInt(currCoordArr[0]);
        int first = firstCoordNum + 1;
        int second = first % 2 == 0 ? 0 : ((first - 1) % 4 == 0 ? 0 : 1);
        String nextCoord = first + "," + second;
        return nextCoord;
    }
}

