/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.utils;

import com.alibaba.fastjson.JSON;
import com.ella.resource.domain.Level;
import com.ella.resource.dto.lexile.LexileR2bScoreRequest;
import com.ella.resource.dto.lexile.LexileR2bScoreResponse;
import com.ella.resource.mapper.LevelMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class LexileR2bScoreUtil {
    private static final Logger log = LogManager.getLogger(LexileR2bScoreUtil.class);
    @Value(value="${lexile.api.url:https://ellabook:0Zu0AaKVLtHd@scoring-service-asia.lexile.com/API}")
    private String apiUrl;
    @Autowired
    RestTemplate rt;
    @Autowired
    private LevelMapper levelMapper;

    public LexileR2bScoreResponse.Result score(LexileR2bScoreRequest request) {
        LexileR2bScoreResponse response = null;
        log.info("lexile score request params:" + JSON.toJSONString((Object)request));
        ResponseEntity resp = this.rt.postForEntity(this.apiUrl, (Object)request, LexileR2bScoreResponse.class, new Object[0]);
        if (resp.getStatusCode().is2xxSuccessful()) {
            response = (LexileR2bScoreResponse)resp.getBody();
        } else {
            log.error("Lexile Api Error - [{}]", (Object)resp.getStatusCode());
        }
        if (response.getError() != null) {
            log.error("Lexile Api Biz Error - [{}]", (Object)response);
        }
        return response.getResult();
    }

    public LexileR2bScoreResponse.Result scoreLocal(String originLevel, Integer score) {
        LexileR2bScoreResponse.Result response = new LexileR2bScoreResponse.Result();
        if (score != null && score >= 10) {
            String nextLevel = String.valueOf(Integer.valueOf(originLevel) + 1);
            Level level = this.levelMapper.selectByCode(nextLevel);
            if (level == null) {
                level = this.levelMapper.selectByCode(originLevel);
            }
            response.setB_new(level.getReadStartIndex().intValue());
            response.setSigma_new(0);
        } else {
            Level level = this.levelMapper.selectByCode(originLevel);
            response.setB_new(level.getReadStartIndex().intValue());
            response.setSigma_new(0);
        }
        return response;
    }
}

