/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.transactional.ResourceOccupantTService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceOccupantTServiceImpl
implements ResourceOccupantTService {
    private static final Logger log = LogManager.getLogger(ResourceOccupantTServiceImpl.class);
    @Autowired
    ResourceOccupantMapper mapper;

    @Transactional(rollbackFor={Exception.class})
    public int insertOccupant(String resType, String resId, String occType, String occId) {
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setResType(resType);
        occupant.setResId(Long.valueOf(resId));
        occupant.setOccupantType(occType);
        occupant.setOccupantId(Long.valueOf(occId));
        occupant.setStatus("NORMAL");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            occupant.setCreateTime(sdf.parse(sdf.format(new Date())));
            occupant.setUpdateTime(sdf.parse(sdf.format(new Date())));
        }
        catch (Exception e) {
            log.error("insertOccupant erro {}", (Throwable)e);
        }
        return this.mapper.insert(occupant);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateOccupant(String resType, String resId, String occType, String occId) {
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setResType(resType);
        occupant.setResId(Long.valueOf(resId));
        occupant.setOccupantType(occType);
        occupant.setOccupantId(Long.valueOf(occId));
        return this.mapper.deleteOccupant(occupant);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> resId(String resType, String occType) {
        return this.mapper.selectResId(resType, occType);
    }
}

