/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.ResExam;
import com.ella.resource.domain.ResExamDetail;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.ResExamDetailDto;
import com.ella.resource.dto.ResExamDto;
import com.ella.resource.dto.ResExamListDto;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.request.exam.AddExamDtailPropertyRequest;
import com.ella.resource.dto.request.exam.DeleteResExamDetailRequest;
import com.ella.resource.dto.request.exam.EditResExamRequest;
import com.ella.resource.dto.request.exam.QueryResExamQuestionRequest;
import com.ella.resource.dto.request.exam.QueryResExamRequest;
import com.ella.resource.dto.request.exam.SaveExamDetailListRequest;
import com.ella.resource.dto.request.exam.SaveResExamRequest;
import com.ella.resource.dto.request.periodtest.OrderQuestionRequest;
import com.ella.resource.dto.sendgoods.StatusEnum;
import com.ella.resource.mapper.ResExamDetailMapper;
import com.ella.resource.mapper.ResExamMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.service.transactional.ResExamTService;
import com.ella.resource.service.transactional.impl.ResQuestionTServiceImpl;
import com.github.pagehelper.PageHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResExamTServiceImpl
implements ResExamTService {
    private static final Logger log = LogManager.getLogger(ResExamTServiceImpl.class);
    @Autowired
    ResExamMapper mapper;
    @Autowired
    ResExamDetailMapper dMapper;
    @Autowired
    ResQuestionTServiceImpl questionService;
    @Autowired
    ResourceOccupantMapper occupantMapper;

    @Transactional(rollbackFor={Exception.class})
    public int saveResExam(SaveResExamRequest request) {
        ResExam exam = new ResExam();
        BeanUtils.copyProperties((Object)request, (Object)exam);
        try {
            SimpleDateFormat sdf;
            if (null == exam.getCreateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                exam.setCreateTime(sdf.parse(sdf.format(new Date())));
            }
            if (null == exam.getUpdateTime()) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                exam.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
            if (null == exam.getStatus() || "".equals(exam.getStatus())) {
                exam.setStatus("NORMAL");
            }
            exam.setUseStatus("N");
            exam.setQuestionNum(Short.valueOf((short)0));
        }
        catch (Exception e) {
            log.error("saveResExam error {}", (Throwable)e);
        }
        return this.mapper.insert(exam);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteResExam(Long id) {
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setStatus("EXCEPTION");
        ResourceOccupantExample exam = new ResourceOccupantExample();
        exam.createCriteria().andOccupantIdEqualTo(id).andOccupantTypeEqualTo("TEST").andStatusEqualTo(StatusEnum.NORMAL.getCode());
        this.occupantMapper.updateByExampleSelective(occupant, exam);
        return this.mapper.deleteByIds(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateResExam(EditResExamRequest request) {
        ResExam exam = new ResExam();
        BeanUtils.copyProperties((Object)request, (Object)exam);
        try {
            if (null == exam.getUpdateTime()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                exam.setUpdateTime(sdf.parse(sdf.format(new Date())));
            }
        }
        catch (Exception e) {
            log.error("" + e);
        }
        return this.mapper.updateByPrimaryKeySelective(exam);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ResExamListDto> queryResExam(QueryResExamRequest request) {
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List dtoList = this.mapper.queryResExam(request);
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResExamDto queryResExamDetail(Long examId) {
        ResExam exam = this.mapper.selectByPrimaryKey(examId);
        if (null == exam) {
            return null;
        }
        List list = this.dMapper.selectDetailsById(examId);
        ResExamDto dto = new ResExamDto();
        BeanUtils.copyProperties((Object)exam, (Object)dto);
        dto.setDetailList(list);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public int saveResExamDetail(SaveExamDetailListRequest request) {
        Long examId = request.getExamId();
        List list = request.getDetailList();
        ArrayList occList = new ArrayList();
        if (null == list || list.isEmpty()) {
            return 0;
        }
        try {
            ArrayList detailList = new ArrayList();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            list.forEach(detailReq -> {
                ResExamDetail d = new ResExamDetail();
                BeanUtils.copyProperties((Object)detailReq, (Object)d);
                d.setExamId(examId);
                detailList.add(d);
                ResourceOccupant occupant = new ResourceOccupant();
                occupant.setResType("QUESTION");
                occupant.setResId(detailReq.getQuestionId());
                occupant.setOccupantType("EXAM");
                occupant.setOccupantId(examId);
                occupant.setStatus("NORMAL");
                occupant.setCreateTime(now);
                occupant.setUpdateTime(now);
                occList.add(occupant);
            });
            int result = this.dMapper.batchInsert(detailList);
            ResExam exam = this.mapper.selectByPrimaryKey(examId);
            Short num = exam.getQuestionNum();
            num = null == num ? Short.valueOf((short)this.dMapper.selectDetailsById(examId).size()) : Short.valueOf((short)(num + list.size()));
            ResExam resExam = new ResExam();
            resExam.setId(examId);
            resExam.setQuestionNum(Short.valueOf(num));
            resExam.setUpdateTime(now);
            this.mapper.updateByPrimaryKeySelective(resExam);
            this.occupantMapper.batchInsert(occList);
            return result;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int addExamDetailProperty(AddExamDtailPropertyRequest request) {
        Long examId = request.getExamId();
        Long detailId = request.getDetailId();
        if (null == examId || 0L == examId || null == detailId || 0L == detailId) {
            return 0;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            ResExam resExam = new ResExam();
            resExam.setId(examId);
            resExam.setUpdateTime(now);
            this.mapper.updateByPrimaryKeySelective(resExam);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.dMapper.updateProperty(examId, detailId, request.getQuestionScore(), request.getKnowledgeLevel(), request.getKnowledgeMission());
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteResExamDetail(DeleteResExamDetailRequest request) {
        this.dMapper.deleteByIds(request);
        ResExam exam = this.mapper.selectByPrimaryKey(request.getExamId());
        long num = exam.getQuestionNum() - 1;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            ResExam resExam = new ResExam();
            resExam.setId(request.getExamId());
            resExam.setQuestionNum(Short.valueOf((short)num));
            resExam.setUpdateTime(now);
            this.mapper.updateByPrimaryKeySelective(resExam);
            ResourceOccupant occupant = new ResourceOccupant();
            occupant.setOccupantType("EXAM");
            occupant.setOccupantId(request.getExamId());
            occupant.setResType("QUESTION");
            occupant.setResId(request.getQuestionId());
            this.occupantMapper.deleteOccupant(occupant);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResExamDetailDto queryExamDetailQuestion(QueryResExamQuestionRequest request) {
        Long id = request.getExamId();
        Long order = request.getQuestionOrder();
        if (null == id || 0L == id || null == order || 0L == order) {
            return null;
        }
        ResExamDetail detail = this.dMapper.getExamDetaiByExamAndOrfer(id, order);
        if (null == detail) {
            return null;
        }
        ResQuestionDto resQuestionDto = this.questionService.getQuestionById(detail.getQuestionId());
        ResExamDetailDto dto = new ResExamDetailDto();
        BeanUtils.copyProperties((Object)detail, (Object)dto);
        dto.setQuestionDto(resQuestionDto);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateExamQuestionOrder(OrderQuestionRequest request) {
        Long id1 = request.getDetaiId1();
        Long id2 = request.getDetaiId2();
        int order1 = request.getOrder1();
        int order2 = request.getOrder2();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date now = sdf.parse(sdf.format(Calendar.getInstance().getTime()));
            ResExamDetail testDetail = this.dMapper.selectByPrimaryKey(id1);
            ResExam periodTest = new ResExam();
            periodTest.setUpdateTime(now);
            periodTest.setId(testDetail.getExamId());
            this.mapper.updateByPrimaryKeySelective(periodTest);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.dMapper.updateExamQuestion(id1, Long.valueOf(order2));
        this.dMapper.updateExamQuestion(id2, Long.valueOf(order1));
        return 1;
    }
}

