/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.frame.aop.annotion.EvictDataCache;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.util.OrderUtil;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.OperateEnum;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.domain.UserCourseInfo;
import com.ella.resource.domain.UserCourseInfoExample;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.domain.UserMissionGiveStoneFlow;
import com.ella.resource.dto.UpdateLevelNumDto;
import com.ella.resource.dto.appdto.MissionClickableDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.mapper.UserCourseInfoMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionGiveStoneFlowMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.service.transactional.UserMapTService;
import com.ella.resource.service.transactional.impl.MissionTServiceImpl;
import com.ella.resource.utils.CacheEnum;
import com.ella.resource.utils.CacheUtilsNew;
import com.ella.resource.utils.MapUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MissionTServiceImpl
implements MissionTService {
    private static final Logger log = LogManager.getLogger(MissionTServiceImpl.class);
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private ResourceOccupantMapper resourceOccupantMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserMissionGiveStoneFlowMapper userMissionGiveStoneFlowMapper;
    @Autowired
    private UserCourseInfoMapper userCourseInfoMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Autowired
    @Lazy
    private UserMapTService userMapTService;
    @Autowired
    private UserInfoService userInfoService;

    @EvictDataCache(resourceName={"MissionMapper:selectByMissionCode"}, operation="UPDATE", evictAll=true)
    @Transactional(rollbackFor={Exception.class})
    public int saveMission(Mission mission) {
        mission.setMissionCode(OrderUtil.createNo((String)"EM", (Integer)3));
        mission.setCreateTime(new Date());
        mission.setStatus("NORMAL");
        mission.setMissionStoneNum(Integer.valueOf(this.getStoneNum(mission.getMissionType(), mission.getResourceId())));
        int result = this.missionMapper.insertSelective(mission);
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        if (result > 0) {
            if (mission.getMissionType() != null && mission.getMissionType().equals(0)) {
                Integer lastVersion = map.getVersion();
                map.setVersion(Integer.valueOf(map.getVersion() + 1));
                this.mapMapper.updateByPrimaryKeySelective(map);
                this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue(), map.getMapCode(), mission.getMissionCode(), null, lastVersion, map.getVersion());
            }
            this.mapMapper.addMissionNum(map.getId());
            UpdateLevelNumDto dto = new UpdateLevelNumDto(map.getLevelCode());
            dto.setPlusStoneNum(mission.getMissionStoneNum());
            dto.setPlusMissionNum(Integer.valueOf(1));
            this.doAfterMissionChange(dto, mission, OperateEnum.INSERT);
        }
        return result;
    }

    private int getNextIndex(Mission mission) {
        if (mission.getMissionType() > 0) {
            int index = this.missionMapper.selectMaxIndexByMapCode(mission.getMapCode());
            return index + 1;
        }
        String index = mission.getMissionCoords().split(",")[0];
        return Integer.valueOf(index) + 1;
    }

    @EvictDataCache(resourceName={"MissionMapper:selectByMissionCode"}, operation="UPDATE", evictAll=true)
    @Transactional(rollbackFor={Exception.class})
    public int deleteMission(Integer id, String uid) {
        Mission mission = this.missionMapper.selectByPrimaryKey(Long.valueOf(id.longValue()));
        if (null == mission) {
            return 0;
        }
        mission.setStatus("DELETE");
        mission.setUpdateBy(uid);
        Map map = this.mapMapper.selectByMapCode(mission.getMapCode());
        Integer lastVersion = map.getVersion();
        this.moveDelMissionIndex(mission.getMapCode(), mission.getMissionIndex(), mission.getMissionCoords(), lastVersion, Integer.valueOf(map.getVersion() + 1));
        int result = this.missionMapper.updateByPrimaryKeySelective(mission);
        map.setVersion(Integer.valueOf(lastVersion + 1));
        if (result > 0) {
            this.mapMapper.updateByPrimaryKeySelective(map);
            this.mapMapper.minusMissionNum(map.getId());
            UpdateLevelNumDto dto = new UpdateLevelNumDto(map.getLevelCode());
            dto.setMinusStoneNum(mission.getMissionStoneNum());
            dto.setMinusMissionNum(Integer.valueOf(1));
            this.doAfterMissionChange(dto, mission, OperateEnum.DELETE);
        }
        new CacheUtilsNew("MAP_RESOURCE:" + mission.getMapCode(), null, CacheEnum.DEL).run();
        this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_DEL.getValue(), map.getMapCode(), mission.getMissionCode(), null, lastVersion, map.getVersion());
        return result;
    }

    public void replaceMissionResHandle(String uid, Mission mission, UserMission userMission) {
        UserCourseInfoExample example = new UserCourseInfoExample();
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(userMission.getMissionCode()).andCourseIdEqualTo(userMission.getResourceId());
        UserCourseInfo userCourseInfo = this.userCourseInfoMapper.sumAndAvgByExample(example);
        if (userCourseInfo != null) {
            Integer gotStoneNum = userCourseInfo.getStoneNum();
            if (gotStoneNum != null && mission.getPassNum() != null && gotStoneNum.compareTo(mission.getPassNum()) > 0) {
                userMission.setStatus("PASS");
            } else if (gotStoneNum != null && mission.getPassNum() != null && gotStoneNum.compareTo(mission.getPassNum()) < 0 && userMission.getStatus().equals("PASS")) {
                UserMissionGiveStoneFlow item = new UserMissionGiveStoneFlow();
                item.setMapCode(mission.getMapCode());
                item.setMissionCode(mission.getMissionCode());
                item.setUid(uid);
                item.setPassNum(mission.getPassNum());
                item.setGiveNum(Integer.valueOf(mission.getPassNum() - userCourseInfo.getStoneNum()));
                item.setIsGive(Integer.valueOf(0));
                item.setType(DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue());
                this.userMissionGiveStoneFlowMapper.insertSelective(item);
            }
        } else {
            UserCourseInfoExample examplex = new UserCourseInfoExample();
            examplex.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(userMission.getMissionCode());
            UserCourseInfo userCourseInfox = this.userCourseInfoMapper.sumAndAvgByExample(examplex);
            if (userCourseInfox != null) {
                UserMissionGiveStoneFlow item = new UserMissionGiveStoneFlow();
                item.setMapCode(mission.getMapCode());
                item.setMissionCode(mission.getMissionCode());
                item.setUid(uid);
                item.setPassNum(mission.getPassNum());
                item.setGiveNum(mission.getPassNum());
                item.setIsGive(Integer.valueOf(0));
                item.setType(DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue());
                this.userMissionGiveStoneFlowMapper.insertSelective(item);
            }
        }
        userMission.setPassNum(mission.getPassNum());
        userMission.setResourceId(mission.getResourceId());
        this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        this.sysResourceOperateService.insertSysResourceNotify(uid, userMission.getMissionCode(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue());
    }

    @EvictDataCache(resourceName={"MissionMapper:selectByMissionCode"}, operation="UPDATE")
    @Transactional(rollbackFor={Exception.class})
    public int updateMission(Mission mission) {
        int result;
        Mission preUpdateMission = this.missionMapper.selectByPrimaryKey(mission.getId());
        if (null != mission.getResourceId() && !mission.getResourceId().equals(preUpdateMission.getResourceId())) {
            Integer newMissionStoneNum = this.getStoneNum(mission.getMissionType(), mission.getResourceId());
            mission.setMissionStoneNum(newMissionStoneNum);
            if (preUpdateMission.getResourceId() != null) {
                mission.setVersion(Integer.valueOf(preUpdateMission.getVersion() + 1));
                this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MISSION.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_REPLACE.getValue(), preUpdateMission.getMapCode(), preUpdateMission.getMissionCode(), null, preUpdateMission.getVersion(), mission.getVersion());
                Date now = new Date();
                this.redisCache.set("mission_res_update_time_" + preUpdateMission.getMissionCode(), (Object)now.getTime());
            }
        }
        if ((result = this.missionMapper.updateByPrimaryKeySelective(mission)) > 0 && null != mission.getResourceId() && !mission.getResourceId().equals(preUpdateMission.getResourceId())) {
            Map map = this.mapMapper.selectByMapCode(preUpdateMission.getMapCode());
            UpdateLevelNumDto dto = new UpdateLevelNumDto(map.getLevelCode());
            dto.setMinusStoneNum(preUpdateMission.getMissionStoneNum());
            dto.setPlusStoneNum(mission.getMissionStoneNum());
            this.doAfterMissionChange(dto, mission, null == preUpdateMission.getResourceId() ? OperateEnum.INSERT : OperateEnum.UPDATE);
            if (preUpdateMission.getResourceId() == null) {
                Integer lastVersion = map.getVersion();
                map.setVersion(Integer.valueOf(lastVersion + 1));
                this.mapMapper.updateByPrimaryKeySelective(map);
                this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue(), map.getMapCode(), preUpdateMission.getMissionCode(), null, lastVersion, map.getVersion());
            }
        }
        new CacheUtilsNew("MAP_RESOURCE:" + preUpdateMission.getMapCode(), null, CacheEnum.DEL).run();
        return result;
    }

    public int doAfterMissionChange(UpdateLevelNumDto dto, Mission mission, OperateEnum operateEnum) {
        if (null != dto && StringUtils.isNotBlank((CharSequence)dto.getLevelCode())) {
            dto.formatDto();
            this.levelMapper.updateNumByCode(dto);
        }
        if (null == mission || null == mission.getId()) {
            return 1;
        }
        if (null == mission.getMissionType() || null == mission.getResourceId()) {
            return 1;
        }
        ResourceOccupantExample example = new ResourceOccupantExample();
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setOccupantId(mission.getId());
        occupant.setOccupantType(DataEnum.RO_OccupantType.Occupant_MISSION.getType());
        occupant.setResId(Long.valueOf(mission.getResourceId().longValue()));
        occupant.setResType(DataEnum.RO_ResType.getType((Integer)mission.getMissionType()));
        switch (1.$SwitchMap$com$ella$resource$constants$OperateEnum[operateEnum.ordinal()]) {
            case 1: {
                example.createCriteria().andResIdEqualTo(Long.valueOf(mission.getResourceId().longValue())).andResTypeEqualTo(DataEnum.RO_ResType.getType((Integer)mission.getMissionType())).andOccupantIdEqualTo(mission.getId()).andOccupantTypeEqualTo(DataEnum.RO_OccupantType.Occupant_MISSION.getType());
                this.resourceOccupantMapper.deleteByExample(example);
                break;
            }
            case 2: {
                this.resourceOccupantMapper.updateByExampleSelective(occupant, example);
                break;
            }
            case 3: {
                occupant.setCreateTime(new Date());
                occupant.setStatus("NORMAL");
                this.resourceOccupantMapper.insertSelective(occupant);
                break;
            }
        }
        return 1;
    }

    public Boolean isMissionClickable(UserInfoDto userInfo, String missionCode, String mapCode, Integer missionIndex, Integer missionType) {
        List missionClickableDtoList;
        boolean userForFree;
        log.info("method isMissionClickable param uid:{},missionCode:{},mapCode:{},missionIndex:{},missionType:{}", (Object)userInfo.getUid(), (Object)missionCode, (Object)mapCode, (Object)missionIndex, (Object)missionType);
        if (StringUtils.isBlank((CharSequence)userInfo.getUid()) || StringUtils.isBlank((CharSequence)missionCode) || StringUtils.isBlank((CharSequence)mapCode)) {
            log.info("method isMissionClickable result1 false");
            return Boolean.FALSE;
        }
        Map map = this.mapMapper.selectByMapCode(mapCode);
        boolean bl = userForFree = !"Y".equalsIgnoreCase(userInfo.getIsVip()) && LevelEnum.LV1.getCode().equalsIgnoreCase(map.getLevelCode()) && map.getLevelOrder().equals(1) && missionIndex < 4;
        if (userForFree) {
            log.info("method isMissionClickable result2 true");
        }
        if (CollectionUtils.isEmpty((Collection)(missionClickableDtoList = this.missionMapper.selectUserMapAndMission(userInfo.getUid(), map.getLevelCode())))) {
            log.info("method isMissionClickable result3 false");
            return Boolean.FALSE;
        }
        java.util.Map codeStatusMap = this.getCodeStatusMap(missionClickableDtoList);
        MissionClickableDto prevMission = null;
        for (MissionClickableDto dto : missionClickableDtoList) {
            log.info("method isMissionClickable current MissionClickableDto:{},prevMission:{}", (Object)dto.toString(), prevMission);
            if (StringUtils.equalsIgnoreCase((CharSequence)missionCode, (CharSequence)dto.getMissionCode())) {
                if (null == prevMission) {
                    log.info("method isMissionClickable result4 true");
                    return Boolean.TRUE;
                }
                if (dto.getMissionType() == 0) {
                    return this.checkClickableOfHiddenMission(dto, missionClickableDtoList);
                }
                if (null == codeStatusMap.get(dto.getMapCode()) && StringUtils.equalsIgnoreCase((CharSequence)"PASS", (CharSequence)prevMission.getMissionStatus())) {
                    log.info("method isMissionClickable result8 true");
                    return Boolean.TRUE;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"PASS", (CharSequence)((CharSequence)codeStatusMap.get(dto.getMapCode()))) && StringUtils.equalsIgnoreCase((CharSequence)"PASS", (CharSequence)prevMission.getMissionStatus())) {
                    log.info("method isMissionClickable result9 true");
                    return Boolean.TRUE;
                }
                log.info("method isMissionClickable result10 false");
                return Boolean.FALSE;
            }
            if (null == dto.getMissionType() || dto.getMissionType() <= 0) continue;
            prevMission = dto;
        }
        log.info("method isMissionClickable result11 false");
        return Boolean.FALSE;
    }

    private Boolean checkClickableOfHiddenMission(MissionClickableDto dto, List<MissionClickableDto> missionClickableDtoList) {
        if (StringUtils.isBlank((CharSequence)dto.getParentCode())) {
            log.info("method isMissionClickable result5 false");
            return Boolean.FALSE;
        }
        MissionClickableDto parentMission = missionClickableDtoList.stream().filter(m -> m.getMapCode().equalsIgnoreCase(dto.getMapCode()) && m.getMissionIndex().toString().equalsIgnoreCase(dto.getParentCode())).findFirst().orElse(new MissionClickableDto());
        if (StringUtils.isNotBlank((CharSequence)parentMission.getMissionStatus())) {
            log.info("method isMissionClickable result6 true");
            return Boolean.TRUE;
        }
        log.info("method isMissionClickable result7 false");
        return Boolean.FALSE;
    }

    public NextMissionInfoDto getJumpMissionInfo(Long currentMissionId, String uid) {
        UserMission userMission = this.userMissionMapper.selectByPrimaryKey(currentMissionId);
        if (userMission != null && userMission.getMissionType() != null && userMission.getMissionType().equals(0)) {
            NextMissionInfoDto nextMissionInfoDto = this.userMissionMapper.selectByMapCodeAndIndex(uid, userMission.getMapCode(), userMission.getMissionIndex());
            nextMissionInfoDto.setSnapLastUserMission(false);
            return nextMissionInfoDto;
        }
        NextMissionInfoDto result = new NextMissionInfoDto();
        if (null == currentMissionId) {
            return result;
        }
        List missions = this.missionMapper.selectAllUserMissionWithOrder(uid);
        missions.removeIf(tmp -> tmp.getMissionType() == null || tmp.getMissionType() == 0);
        int currentIndex = missions.stream().filter(m -> StringUtils.equalsIgnoreCase((CharSequence)m.getMissionId(), (CharSequence)currentMissionId.toString())).mapToInt(missions::indexOf).max().orElse(0);
        NextMissionInfoDto currentMission = (NextMissionInfoDto)missions.get(currentIndex);
        NextMissionInfoDto nextMission = null;
        if (currentIndex == missions.size() - 1) {
            List missionsx = this.missionMapper.selectAllWithOrder();
            missionsx.removeIf(tmp -> tmp.getMissionType() == null || tmp.getMissionType() == 0);
            int tmpIndex = missionsx.stream().filter(m -> currentMission.getMissionCode().equalsIgnoreCase(m.getMissionCode())).mapToInt(missionsx::indexOf).max().orElse(0);
            NextMissionInfoDto nextMissionInfoDto = nextMission = tmpIndex == missionsx.size() - 1 ? null : (NextMissionInfoDto)missionsx.get(tmpIndex + 1);
            if (nextMission != null) {
                nextMission.setSnapLastUserMission(true);
            }
            return nextMission;
        }
        nextMission = (NextMissionInfoDto)missions.get(currentIndex + 1);
        nextMission.setSnapLastUserMission(false);
        BeanUtils.copyProperties((Object)nextMission, (Object)result);
        result.setIsCrossMap(Boolean.valueOf(!StringUtils.equalsIgnoreCase((CharSequence)nextMission.getMapCode(), (CharSequence)currentMission.getMapCode())));
        return result;
    }

    public List<java.util.Map<String, Object>> selectMissionGoods(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<java.util.Map<String, Object>>();
        }
        return this.missionMapper.selectMissionGoods(codes);
    }

    public void moveInsertMissionIndex(String mapCode, Integer missionIndex) {
        Mission mission = this.missionMapper.selectByMapCodeAndOrder(mapCode, missionIndex);
        if (mission != null) {
            List missions = this.missionMapper.selectByMapCodeAndGreaterThanOrder(mapCode, missionIndex);
            missions = missions.stream().filter(item -> item.getMissionType() != null && !item.getMissionType().equals(0)).collect(Collectors.toList());
            for (int i = 0; i < missions.size(); ++i) {
                Mission item2 = (Mission)missions.get(i);
                item2.setMissionIndex(Integer.valueOf(item2.getMissionIndex() + 1));
                String coords = i == missions.size() - 1 ? MapUtils.getNextCoord((String)item2.getMissionCoords()) : ((Mission)missions.get(i + 1)).getMissionCoords();
                item2.setMissionCoords(coords);
                this.missionMapper.updateByPrimaryKeySelective(item2);
            }
        }
    }

    public void moveDelMissionIndex(String mapCode, Integer missionIndex, String coords, Integer lastVersion, Integer newVersion) {
        Mission mission = this.missionMapper.selectByMapCodeAndOrder(mapCode, missionIndex);
        if (mission != null) {
            List missions = this.missionMapper.selectByMapCodeAndGreaterThanOrder(mapCode, missionIndex);
            if ((missions = missions.stream().filter(item -> !item.getMissionIndex().equals(missionIndex) && !item.getMissionCoords().equals(coords)).collect(Collectors.toList())) == null || missions.size() == 0) {
                Mission lastHide = this.missionMapper.selectHideByIndex(mission.getMissionIndex());
                this.missionMapper.delHideByMissionIndex(mission.getMissionIndex());
                if (lastHide != null) {
                    this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_DEL.getValue(), mapCode, lastHide.getMissionCode(), null, lastVersion, newVersion);
                }
                this.mapMapper.minusMissionNumByMapCode(mapCode);
                return;
            }
            List<Mission> missionsx = missions.stream().filter(item -> item.getMissionType() != null && !item.getMissionType().equals(0)).collect(Collectors.toList());
            List<Mission> hideMissions = missions.stream().filter(item -> item.getMissionType() != null && item.getMissionType().equals(0)).collect(Collectors.toList());
            String preCoords = coords;
            Integer preMissionIndex = missionIndex;
            for (int i = 0; i < missionsx.size(); ++i) {
                Mission item2 = (Mission)missionsx.get(i);
                Integer currMissionIndex = item2.getMissionIndex();
                String currCoords = item2.getMissionCoords();
                item2.setMissionIndex(preMissionIndex);
                item2.setMissionCoords(preCoords);
                preCoords = currCoords;
                preMissionIndex = currMissionIndex;
            }
            Set missionIndexSet = missionsx.stream().map(BaseMission::getMissionIndex).collect(Collectors.toSet());
            ArrayList delHideMissions = new ArrayList();
            hideMissions.forEach(hideMission -> {
                if (!missionIndexSet.contains(hideMission.getMissionIndex())) {
                    log.info("moveDelMissionIndex,hideMission do not have a reference master mission " + hideMission.getMissionCode() + ":" + hideMission.getMissionIndex());
                    delHideMissions.add(hideMission);
                    return;
                }
            });
            if (delHideMissions.size() > 0) {
                delHideMissions.forEach(hideMission -> {
                    hideMission.setStatus("DELETE");
                    this.missionMapper.updateByPrimaryKeySelective(hideMission);
                    this.mapMapper.minusMissionNumByMapCode(mapCode);
                    this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_DEL.getValue(), mapCode, hideMission.getMissionCode(), null, lastVersion, newVersion);
                });
            }
            missionsx.forEach(record -> this.missionMapper.updateByPrimaryKeySelective(record));
        }
    }

    public void moveAndInsertAndDelUserMission(String uid, UserMap userMap) {
        if (userMap == null) {
            return;
        }
        String mapCode = userMap.getMapCode();
        List sysResourceUpdateLogList = this.sysResourceOperateService.getNeedUpdateResource(DataEnum.SYS_RESOURCE_TYPE.MAP.getValue(), mapCode, null, userMap.getVersion());
        if (sysResourceUpdateLogList == null || sysResourceUpdateLogList.size() == 0) {
            return;
        }
        ArrayList insertMasterMissions = new ArrayList();
        ArrayList insertSlaveMissions = new ArrayList();
        ArrayList delMissions = new ArrayList();
        ArrayList missions = new ArrayList();
        HashSet updateMissionCodeSet = new HashSet(16);
        sysResourceUpdateLogList.forEach(sysResourceUpdateLog -> {
            Mission mission = this.missionMapper.selectByMissionCode(sysResourceUpdateLog.getOpCode());
            if (!updateMissionCodeSet.contains(mission.getMissionCode())) {
                missions.add(mission);
            }
            if (mission.getMissionType() == null) {
                return;
            }
            MissionUpdateInfo missionUpdateInfo = new MissionUpdateInfo(this);
            missionUpdateInfo.setMissionCode(mission.getMissionCode());
            missionUpdateInfo.setMissionType(mission.getMissionType());
            missionUpdateInfo.setUpdateTime(sysResourceUpdateLog.getCreateTime());
            if (DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue().equals(sysResourceUpdateLog.getOpType()) && mission.getMissionType() > 0) {
                missionUpdateInfo.setInsert(true);
                insertMasterMissions.add(missionUpdateInfo);
            } else if (DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue().equals(sysResourceUpdateLog.getOpType()) && mission.getMissionType() == 0) {
                insertSlaveMissions.add(mission);
            } else if (DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_DEL.getValue().equals(sysResourceUpdateLog.getOpType())) {
                delMissions.add(missionUpdateInfo);
            }
            updateMissionCodeSet.add(mission.getMissionCode());
        });
        java.util.Map missionMap = missions.stream().collect(Collectors.toMap(BaseMission::getMissionCode, Function.identity()));
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andMapCodeEqualTo(mapCode).andUidEqualTo(uid);
        List userMissions = this.userMissionMapper.selectByExample(example);
        Set userMissionCodeSet = userMissions.stream().map(BaseMission::getMissionCode).collect(Collectors.toSet());
        java.util.Map userMissionMap = userMissions.stream().collect(Collectors.toMap(BaseMission::getMissionCode, Function.identity()));
        HashMap masterMissionStatusMap = new HashMap(16);
        ArrayList handleMissions = new ArrayList();
        handleMissions.addAll(insertMasterMissions);
        handleMissions.addAll(delMissions);
        handleMissions.stream().sorted(Comparator.comparing(MissionUpdateInfo::getUpdateTime));
        if (handleMissions.size() > 0) {
            handleMissions.forEach(handleMission -> {
                if (MissionUpdateInfo.access$000((MissionUpdateInfo)handleMission)) {
                    this.handleInsertUserMission(uid, handleMission.getMissionCode(), userMap, missionMap, userMissionMap, userMissions, masterMissionStatusMap, userMissionCodeSet);
                } else {
                    this.userMissionMapper.delByUidAndMissionCode(uid, MissionUpdateInfo.access$100((MissionUpdateInfo)handleMission));
                    if (!handleMission.getMissionType().equals(0)) {
                        this.handleUserMissionDoing(uid, mapCode, MissionUpdateInfo.access$100((MissionUpdateInfo)handleMission), userMissionMap);
                    }
                }
            });
        }
        if (insertSlaveMissions.size() > 0) {
            insertSlaveMissions.forEach(mission -> {
                String key;
                String isNew;
                if (userMissionCodeSet.contains(mission.getMissionCode())) {
                    return;
                }
                UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)userMap.getLevelCode());
                userMission.setStatus("NOTSTARTED");
                this.userMissionMapper.insertSelective(userMission);
                if ("PASS".equals(userMission.getStatus()) && (isNew = this.redisCache.get(key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT + ":" + uid + ":" + userMission.getMapCode())) == null) {
                    this.sysResourceOperateService.insertSysResourceNotify(uid, userMission.getMissionCode(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue());
                }
            });
        }
    }

    private void handleUserMissionDoing(String uid, String mapCode, String missionCode, java.util.Map<String, UserMission> userMissionMap) {
        UserMission userMission = userMissionMap.get(missionCode);
        if (userMission != null && userMission.getStatus().equals("DOING")) {
            Integer missionIndex = userMission.getMissionIndex();
            Mission newMission = this.missionMapper.selectByMapCodeAndOrder(mapCode, missionIndex);
            if (newMission != null) {
                UserMission newUserMission = userMissionMap.get(newMission.getMissionCode());
                if (newUserMission != null && !newUserMission.getStatus().equals("PASS")) {
                    this.setUserMissionAndMapDoing(newUserMission);
                }
            } else {
                UserMission nextUserMission = this.getNextUserMission(uid, mapCode);
                if (nextUserMission != null && !"PASS".equals(nextUserMission.getStatus()) && !nextUserMission.isBaseRecord()) {
                    this.setUserMissionAndMapDoing(nextUserMission);
                } else if (nextUserMission != null && nextUserMission.isBaseRecord()) {
                    this.userMapAndMissionService.updateUserMapAfterTest(nextUserMission.getLevelCode(), uid, nextUserMission.getMapCode(), nextUserMission.getMissionCode());
                    this.userMapMapper.updateUserMapPass(uid, mapCode);
                    this.userMapTService.updateUserMapAndMissionToDoing(uid, nextUserMission.getMapCode(), nextUserMission.getMissionCode());
                    this.userInfoService.updateUserLevelInfo(UpdateUserLevelRequest.builder().uid(uid).lexileLevel("NO").levelCode(nextUserMission.getLevelCode()).build());
                }
            }
        }
    }

    private void setUserMissionAndMapDoing(UserMission userMission) {
        userMission.setStatus("DOING");
        userMission.setUnlockTime(new Date());
        this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        UserMap userMap = this.userMapMapper.selectByUidAndMapCode(userMission.getUid(), userMission.getMapCode());
        if (userMap != null && !userMap.getStatus().equals("PASS")) {
            this.userMapMapper.updateUserMapNotStart(userMission.getUid());
            userMap.setStatus("DOING");
            this.userMapMapper.updateByPrimaryKeySelective(userMap);
        }
    }

    private void handleInsertUserMission(String uid, String missionCode, UserMap userMap, java.util.Map<String, Mission> missionMap, java.util.Map<String, UserMission> userMissionMap, List<UserMission> userMissions, java.util.Map<String, String> userMissionStatusMap, Set<String> userMissionCodeSet) {
        UserMission userMission;
        Mission mission = missionMap.get(missionCode);
        if (mission == null || mission.getMissionType() == null) {
            return;
        }
        Integer missionIndex = mission.getMissionIndex();
        String status = "NOTSTARTED";
        Mission oldMission = this.missionMapper.selectMinAbsMission(mission.getMapCode(), missionIndex, null);
        if (oldMission != null) {
            UserMission oldUserMission = userMissionMap.get(oldMission.getMissionCode());
            if (oldUserMission == null) {
                this.handleInsertUserMission(uid, oldMission.getMissionCode(), userMap, missionMap, userMissionMap, userMissions, userMissionStatusMap, userMissionCodeSet);
                return;
            }
            if ("PASS".equals(oldUserMission.getStatus()) || "DOING".equals(oldUserMission.getStatus())) {
                status = "PASS";
            }
        } else {
            userMission = this.getNextUserMission(uid, mission.getMapCode());
            if (userMission != null && !userMission.isBaseRecord() && ("PASS".equals(userMission.getStatus()) || "DOING".equals(userMission.getStatus()))) {
                status = "PASS";
            }
        }
        if (userMissionCodeSet.contains(mission.getMissionCode())) {
            return;
        }
        userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)userMap.getLevelCode());
        userMission.setStatus(status);
        this.userMissionMapper.insertSelective(userMission);
        userMissionStatusMap.put(userMission.getMissionCode(), status);
        userMissions.add(userMission);
        userMissionMap.put(userMission.getMissionCode(), userMission);
        userMissionCodeSet.add(userMission.getMissionCode());
        if ("PASS".equals(status)) {
            UserMissionGiveStoneFlow item = new UserMissionGiveStoneFlow();
            item.setMapCode(userMission.getMapCode());
            item.setMissionCode(userMission.getMissionCode());
            item.setUid(uid);
            item.setPassNum(userMission.getPassNum());
            item.setGiveNum(userMission.getPassNum());
            item.setIsGive(Integer.valueOf(0));
            item.setType(DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue());
            this.userMissionGiveStoneFlowMapper.insertSelective(item);
            String key = "SYS_RESOURCE_UPDATE:" + DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT + ":" + uid + ":" + userMission.getMapCode();
            String isNew = this.redisCache.get(key);
            if (isNew == null) {
                this.sysResourceOperateService.insertSysResourceNotify(uid, missionCode, DataEnum.SYS_RESOURCE_UPDATE_TYPE.MISSION_RESOURCE_INSERT.getValue());
            }
        }
    }

    private UserMission getNextUserMission(String uid, String mapCode) {
        Map preMap = this.mapMapper.selectByMapCode(mapCode);
        if (preMap == null) {
            return null;
        }
        Map map = this.mapMapper.selectMinAbsMap(preMap.getLevelCode(), preMap.getLevelOrder(), null);
        if (map == null) {
            String nextLevelCode = String.valueOf(Integer.parseInt(preMap.getLevelCode()) + 1);
            Map mapx = this.mapMapper.selectMinAbsMap(nextLevelCode, Integer.valueOf(0), null);
            if (mapx == null) {
                return null;
            }
            UserMission userMission = this.userMissionMapper.selectFirstMissionByMapCode(uid, mapx.getMapCode());
            if (userMission == null) {
                Mission mission = this.missionMapper.selectFirstMissionByMapCode(mapx.getMapCode());
                userMission = new UserMission();
                userMission.setBaseRecord(true);
                userMission.setMapCode(mission.getMapCode());
                userMission.setMissionCode(mission.getMissionCode());
                userMission.setLevelCode(mapx.getLevelCode());
                return userMission;
            }
            return userMission;
        }
        UserMission userMission = this.userMissionMapper.selectFirstMissionByMapCode(uid, map.getMapCode());
        return userMission;
    }

    private int getStoneNum(Integer missionType, Integer resourceId) {
        if (null == missionType || null == resourceId) {
            return 0;
        }
        Integer result = this.missionMapper.selectStoneNum(missionType, resourceId);
        return null == result ? 0 : result;
    }

    private java.util.Map<String, String> getCodeStatusMap(List<MissionClickableDto> missionClickableDtoList) {
        HashMap<String, String> result = new HashMap<String, String>(missionClickableDtoList.size());
        ArrayList tmpList = new ArrayList();
        missionClickableDtoList.forEach(m -> {
            if (!tmpList.contains(m.getMapCode() + ";" + m.getMapStatus())) {
                tmpList.add(m.getMapCode() + ";" + m.getMapStatus());
            }
        });
        for (int i = 0; i < tmpList.size(); ++i) {
            String[] tmp = ((String)tmpList.get(i)).split(";");
            if (i == 0) {
                result.put(tmp[0], null);
                continue;
            }
            String[] prevTmp = ((String)tmpList.get(i - 1)).split(";");
            result.put(tmp[0], prevTmp.length > 1 ? prevTmp[1] : null);
        }
        return result;
    }
}

