/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.BaseMap;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.UserCourseInfo;
import com.ella.resource.domain.UserCourseInfoExample;
import com.ella.resource.domain.UserLevelResourceVersion;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMapExample;
import com.ella.resource.domain.UserMission;
import com.ella.resource.domain.UserMissionExample;
import com.ella.resource.domain.UserMissionGiveStone;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.UserCourseInfoMapper;
import com.ella.resource.mapper.UserLevelResourceVersionMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionGiveStoneMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MapAndMissionUtilService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MapAndMissionUtilServiceImpl
implements MapAndMissionUtilService {
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserLevelResourceVersionMapper userLevelResourceVersionMapper;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private UserMissionGiveStoneMapper userMissionGiveStoneMapper;
    @Autowired
    private UserCourseInfoMapper userCourseInfoMapper;

    public java.util.Map<String, String> getUserMissionStatus(String uid) {
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(uid);
        List userMissions = this.userMissionMapper.selectByExample(example);
        java.util.Map<String, String> userMissionStatus = userMissions.stream().collect(Collectors.toMap(BaseMission::getMissionCode, BaseMission::getStatus));
        return userMissionStatus;
    }

    public java.util.Map<String, String> getUserMapStatus(String uid) {
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(uid);
        List userMaps = this.userMapMapper.selectByExample(example);
        java.util.Map<String, String> userMapStatus = userMaps.stream().collect(Collectors.toMap(BaseMap::getMapCode, UserMap::getStatus));
        return userMapStatus;
    }

    public void setUserMapNotStart(String uid) {
        this.userMapMapper.updateUserMapNotStart(uid);
    }

    public void setUserMissionNotStart(String uid) {
        this.userMissionMapper.updateUserMissionNotStart(uid);
    }

    public int getMissionIndex(String uid, String missionCode, String mapCode) {
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(uid).andMapCodeEqualTo(mapCode).andMissionTypeNotEqualTo(Integer.valueOf(0));
        example.setOrderByClause(" mission_index");
        List userMissionList = this.userMissionMapper.selectByExample(example);
        UserMission mission = this.userMissionMapper.selectByUidAndMissionCode(uid, missionCode);
        if (mission != null) {
            int missionIndex = 1;
            for (UserMission userMission : userMissionList) {
                if (userMission.getMissionCode().equals(missionCode)) {
                    return missionIndex;
                }
                ++missionIndex;
            }
        } else {
            Mission query = new Mission();
            query.setMapCode(mapCode);
            query.setStatus("NORMAL");
            List missionList = this.missionMapper.selectMissionList(query);
            List missions = missionList.stream().filter(m -> m.getMissionType() != 0).collect(Collectors.toList());
            int missionIndex = 1;
            for (Mission m2 : missions) {
                if (m2.getMissionCode().equals(missionCode)) {
                    return missionIndex;
                }
                ++missionIndex;
            }
        }
        return 0;
    }

    public List<String> getUserMissionCodes(String uid, String mapCode) {
        List userMissions;
        List<String> userMissionCodes = new ArrayList<String>();
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(uid);
        if (StringUtils.isNotBlank((String)mapCode)) {
            example.createCriteria().andMapCodeEqualTo(mapCode);
        }
        if (!CollectionUtils.isEmpty((Collection)(userMissions = this.userMissionMapper.selectByExample(example)))) {
            userMissionCodes = userMissions.stream().map(BaseMission::getMissionCode).collect(Collectors.toList());
        }
        return userMissionCodes;
    }

    public List<String> getUserMapCodes(String uid) {
        List userMapCodes = null;
        UserMapExample example = new UserMapExample();
        example.createCriteria().andUidEqualTo(uid);
        List userMaps = this.userMapMapper.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)userMaps)) {
            userMapCodes = userMaps.stream().map(BaseMap::getMapCode).collect(Collectors.toList());
        }
        return userMapCodes;
    }

    public Set<String> getUserMissionCodes(String uid) {
        UserMissionExample example = new UserMissionExample();
        example.createCriteria().andUidEqualTo(uid);
        List userMissions = this.userMissionMapper.selectByExample(example);
        Set<String> userMissionCodeSet = new HashSet<String>();
        if (userMissions != null && userMissions.size() > 0) {
            userMissionCodeSet = userMissions.stream().map(BaseMission::getMissionCode).collect(Collectors.toSet());
        }
        return userMissionCodeSet;
    }

    public void needMapUpdate(String uid) {
        List levelList = this.levelMapper.selectAll();
        if (levelList == null || levelList.size() == 0) {
            return;
        }
        levelList.forEach(level -> {
            String levelCode = level.getLevelCode();
            UserLevelResourceVersion userVersion = this.userLevelResourceVersionMapper.selectByUidAndLevelCode(uid, levelCode);
            if (userVersion != null && userVersion.getVersion().equals(level.getVersion())) {
                return;
            }
            boolean r = this.mapTService.moveAndInsertUserMap(uid, level, userVersion);
            if (userVersion == null) {
                userVersion = new UserLevelResourceVersion();
                userVersion.setUid(uid);
                userVersion.setLevelCode(levelCode);
            }
            if (r) {
                userVersion.setVersion(level.getVersion());
            }
            if (userVersion.getId() == null) {
                this.userLevelResourceVersionMapper.insertSelective(userVersion);
            } else {
                this.userLevelResourceVersionMapper.updateByPrimaryKeySelective(userVersion);
            }
        });
    }

    public void needMissionUpdate(String uid, UserMap userMap) {
        if (userMap == null) {
            return;
        }
        String mapCode = userMap.getMapCode();
        Map map = this.mapMapper.selectByMapCode(mapCode);
        if (map == null) {
            return;
        }
        if (userMap.getVersion().equals(map.getVersion())) {
            return;
        }
        this.missionTService.moveAndInsertAndDelUserMission(uid, userMap);
        UserMap updateItem = new UserMap();
        updateItem.setId(userMap.getId());
        updateItem.setVersion(map.getVersion());
        this.userMapMapper.updateByPrimaryKeySelective(updateItem);
    }

    public void needMissionResUpdate(String uid, UserMission userMission) {
        if (userMission == null) {
            return;
        }
        String missionCode = userMission.getMissionCode();
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        if (mission == null) {
            return;
        }
        if (mission.getVersion().compareTo(userMission.getVersion()) > 0) {
            this.missionTService.replaceMissionResHandle(uid, mission, userMission);
            userMission.setVersion(mission.getVersion());
            this.userMissionMapper.updateByPrimaryKeySelective(userMission);
        }
    }

    public String getBookCodeByMissionId(Long missionId) {
        UserMission userMission = this.userMissionMapper.selectByPrimaryKey(missionId);
        if (userMission == null) {
            return "";
        }
        Integer resourceId = userMission.getResourceId();
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(resourceId);
        if (courseBook == null) {
            return "";
        }
        return courseBook.getBookCode();
    }

    public Boolean judgeAddStoneNum(String uid, String missionCode, Integer addStone) {
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        Integer passNum = mission.getPassNum();
        UserMissionGiveStone userMissionGiveStone = this.userMissionGiveStoneMapper.selectByUidAndMissionCode(uid, missionCode);
        if (userMissionGiveStone == null || userMissionGiveStone.getIsHandle() == 1) {
            return true;
        }
        UserCourseInfoExample example = new UserCourseInfoExample();
        example.createCriteria().andUidEqualTo(uid).andMissionCodeEqualTo(missionCode).andCourseIdEqualTo(mission.getResourceId());
        UserCourseInfo userCourseInfo = this.userCourseInfoMapper.sumAndAvgByExample(example);
        Integer acquiredStoneNum = userCourseInfo.getStoneNum();
        if (acquiredStoneNum <= passNum) {
            return false;
        }
        return null;
    }

    public Boolean missionClickable(String uid, String missionCode, String status) {
        if (missionCode == null) {
            return false;
        }
        if ("PASS".equals(status)) {
            return true;
        }
        if ("DOING".equals(status)) {
            return true;
        }
        if ("UNLOCKED".equals(status)) {
            return true;
        }
        UserMission userMission = this.userMissionMapper.selectByUidAndMissionCode(uid, missionCode);
        if (userMission == null) {
            return false;
        }
        if (userMission.getMissionType() != null && userMission.getMissionType().equals(0)) {
            return true;
        }
        Mission mission = this.getBeforeMission(userMission.getMissionCode());
        if (mission == null) {
            return true;
        }
        UserMission preMission = this.userMissionMapper.selectByUidAndMissionCode(uid, mission.getMissionCode());
        if (preMission == null) {
            return false;
        }
        if ("PASS".equals(preMission.getStatus())) {
            return true;
        }
        Integer missionIndex = mission.getMissionIndex();
        List userMissions = this.userMissionMapper.selectNextPass(uid, missionIndex, mission.getMapCode());
        if (userMissions != null && userMissions.size() != 0) {
            return true;
        }
        return false;
    }

    public Mission getBeforeMission(String missionCode) {
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        if (mission == null) {
            return null;
        }
        Integer missionIndex = mission.getMissionIndex();
        Mission preMission = this.missionMapper.selectMinAbsMission(mission.getMapCode(), missionIndex, Integer.valueOf(1));
        if (preMission == null) {
            Map currentMap = this.mapMapper.selectByMapCode(mission.getMapCode());
            Map preMap = this.mapMapper.selectMinAbsMap(currentMap.getLevelCode(), currentMap.getLevelOrder(), Integer.valueOf(1));
            if (preMap == null) {
                return null;
            }
            return this.missionMapper.selectLastByMapCode(preMap.getMapCode());
        }
        return preMission;
    }

    public Mission getNextMission(String missionCode) {
        Mission mission = this.missionMapper.selectByMissionCode(missionCode);
        if (mission == null) {
            return null;
        }
        Integer missionIndex = mission.getMissionIndex();
        String mapCode = mission.getMapCode();
        Mission nextMission = this.missionMapper.selectMinAbsMission(mapCode, missionIndex, null);
        if (nextMission != null) {
            return nextMission;
        }
        Map preMap = this.mapMapper.selectByMapCode(mapCode);
        if (preMap == null) {
            return null;
        }
        Map map = this.mapMapper.selectMinAbsMap(preMap.getLevelCode(), preMap.getLevelOrder(), null);
        if (map == null) {
            String nextLevelCode = String.valueOf(Integer.parseInt(preMap.getLevelCode()) + 1);
            Map nextMap = this.mapMapper.selectMinAbsMap(nextLevelCode, Integer.valueOf(0), null);
            if (nextMap == null) {
                return null;
            }
            nextMission = this.missionMapper.selectFirstMissionByMapCode(nextMap.getMapCode());
            return nextMission;
        }
        nextMission = this.missionMapper.selectFirstMissionByMapCode(map.getMapCode());
        mission.setLevelCode(map.getLevelCode());
        return nextMission;
    }

    public UserMission getNextUserMission(String uid, String missionCode) {
        Mission mission = this.getNextMission(missionCode);
        if (mission == null) {
            return null;
        }
        UserMission userMission = this.userMissionMapper.selectByUidAndMissionCode(uid, missionCode);
        if (userMission == null) {
            userMission = new UserMission();
            userMission.setMapCode(mission.getMapCode());
            userMission.setMissionCode(mission.getMissionCode());
            userMission.setLevelCode(mission.getLevelCode());
            userMission.setBaseRecord(true);
        }
        return userMission;
    }

    public Integer getMissionNum(String mapCode) {
        Integer missionNum = this.missionMapper.selectMissionNumByMapCode(mapCode);
        Integer hideMissionNum = this.missionMapper.selectHideMissionNumByMapCode(mapCode);
        return missionNum + hideMissionNum;
    }

    public void snapUserLevelResource(String uid, Integer level) {
        List missions;
        List userMapCodes = this.getUserMapCodes(uid);
        Set userMissionCodes = this.getUserMissionCodes(uid);
        HashSet<String> result = new HashSet<String>();
        for (int i = 1; i <= level; ++i) {
            result.add(String.valueOf(i));
        }
        List maps = this.mapMapper.selectMapsByLevelCodes(result);
        ArrayList<String> mapCodes = new ArrayList<String>();
        ArrayList<UserMap> userMaps = new ArrayList<UserMap>();
        ArrayList<UserMission> userMissions = new ArrayList<UserMission>();
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            for (Map m : maps) {
                mapCodes.add(m.getMapCode());
                if (userMapCodes.contains(m.getMapCode())) continue;
                userMaps.add(MapUtils.mapToUserMap((Map)m, (String)uid, (Boolean)false));
                mapCodes.add(m.getMapCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(missions = this.missionMapper.selectMissionsByMapCodes(mapCodes)))) {
            for (int i = 0; i < missions.size(); ++i) {
                Mission mission = (Mission)missions.get(i);
                if (userMissionCodes.contains(mission.getMissionCode())) continue;
                UserMission userMission = MapUtils.missionToUserMission((Mission)mission, (String)uid, (String)mission.getLevelCode());
                userMissions.add(userMission);
            }
        }
        if (!CollectionUtils.isEmpty(userMaps)) {
            this.userMapMapper.insertBatch(userMaps);
        }
        if (!CollectionUtils.isEmpty(userMissions)) {
            this.userMissionMapper.batchInsert(userMissions);
        }
    }
}

