/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.domain.LexileEvaluation;
import com.ella.resource.domain.LexileEvaluationQuestion;
import com.ella.resource.domain.LexileEvaluationQuestionItem;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileEvaluationListDto;
import com.ella.resource.dto.LexileEvaluationPageDto;
import com.ella.resource.dto.LexileEvaluationQuestionDto;
import com.ella.resource.dto.LexileEvaluationQuestionItemDto;
import com.ella.resource.dto.request.lexile.DeleteLexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.EditLexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.EditLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.FindLexileQuestionItemRequest;
import com.ella.resource.dto.request.lexile.LexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.SaveLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.SelectOneLexileQuestionsRequest;
import com.ella.resource.mapper.LexileEvaluationMapper;
import com.ella.resource.mapper.LexileEvaluationQuestionItemMapper;
import com.ella.resource.mapper.LexileEvaluationQuestionMapper;
import com.ella.resource.service.transactional.LexileEvaluationTService;
import com.ella.resource.utils.ExcelUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LexileEvaluationTServiceImpl
implements LexileEvaluationTService {
    private static final Logger log = LogManager.getLogger(LexileEvaluationTServiceImpl.class);
    @Autowired
    LexileEvaluationMapper mapper;
    @Autowired
    LexileEvaluationQuestionMapper questionMapper;
    @Autowired
    LexileEvaluationQuestionItemMapper questionItemMapper;

    @Transactional(rollbackFor={Exception.class})
    public int addLexileEvaluation(SaveLexileEvaluationRequest request) {
        LexileEvaluation le = new LexileEvaluation();
        BeanUtils.copyProperties((Object)request, (Object)le);
        return this.mapper.insertSelective(le);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<LexileEvaluationListDto> getAllLexileEvaluation() {
        List list = this.mapper.selectAll();
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<LexileEvaluationListDto> dtoList = new ArrayList<LexileEvaluationListDto>();
        list.forEach(model -> {
            LexileEvaluationListDto le = new LexileEvaluationListDto();
            BeanUtils.copyProperties((Object)model, (Object)le);
            dtoList.add(le);
        });
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int saveLexiLeEvaluationDetail(LexileEvaluationQuestionRequest request) {
        LexileEvaluationQuestion q = new LexileEvaluationQuestion();
        BeanUtils.copyProperties((Object)request, (Object)q);
        Long qId = this.questionMapper.insert(q);
        List l = request.getDetailRequest();
        ArrayList questionItem = new ArrayList();
        l.forEach(d -> {
            LexileEvaluationQuestionItem i = new LexileEvaluationQuestionItem();
            BeanUtils.copyProperties((Object)d, (Object)i);
            i.setQuestionId(Long.valueOf(qId));
            questionItem.add(i);
        });
        this.questionItemMapper.batchInsert(questionItem);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateLexiLeEvaluationProperty(EditLexileEvaluationRequest request) {
        LexileEvaluationQuestion question = this.questionMapper.selectByPrimaryKey(request.getId());
        if (question == null) {
            return 0;
        }
        LexileEvaluation record = new LexileEvaluation();
        record.setId(question.getEvaluationId());
        record.setUpdateTime(Calendar.getInstance().getTime());
        this.mapper.updateByPrimaryKeySelective(record);
        return this.questionMapper.updateProperty(request);
    }

    @Transactional(rollbackFor={Exception.class})
    public int editLexiLeEvaluationDetail(EditLexileEvaluationQuestionRequest request) {
        LexileEvaluationQuestion le = new LexileEvaluationQuestion();
        BeanUtils.copyProperties((Object)request, (Object)le);
        this.questionMapper.updateByPrimaryKeySelective(le);
        List detailRequest = request.getDetailRequest();
        if (null == detailRequest || detailRequest.isEmpty()) {
            return 1;
        }
        detailRequest.forEach(detail -> {
            LexileEvaluationQuestionItem item = new LexileEvaluationQuestionItem();
            BeanUtils.copyProperties((Object)detail, (Object)item);
            this.questionItemMapper.updateByPrimaryKeySelective(item);
        });
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteLexiLeEvaluationDetail(DeleteLexileEvaluationQuestionRequest request) {
        return this.questionMapper.updateByDeleteDto(request);
    }

    @Transactional(rollbackFor={Exception.class})
    public LexileEvaluationQuestionDto queryLexiLeEvaluationDetail(FindLexileQuestionItemRequest request) {
        LexileEvaluationQuestion question = this.questionMapper.selectByEvaluationInfo(request);
        if (null == question) {
            return null;
        }
        List itemList = this.questionItemMapper.selectByQuestionId(question.getId());
        if (null == itemList || itemList.isEmpty()) {
            return null;
        }
        LexileEvaluationQuestionDto dto = new LexileEvaluationQuestionDto();
        BeanUtils.copyProperties((Object)question, (Object)dto);
        ArrayList dtoList = new ArrayList();
        itemList.forEach(item -> {
            LexileEvaluationQuestionItemDto i = new LexileEvaluationQuestionItemDto();
            BeanUtils.copyProperties((Object)item, (Object)i);
            dtoList.add(i);
        });
        dto.setQuestionItemDtoList(dtoList);
        return dto;
    }

    public Integer countEvaluationQuestiones(Long evaluationId) {
        return this.questionMapper.countByEvaluationId(evaluationId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int importLexileEvaluation(MultipartFile file, String evaluationId) {
        String fileName = file.getOriginalFilename();
        if (!fileName.matches(ExcelUtil.EXCEL_2003_POSTFIX) && !fileName.matches(ExcelUtil.EXCEL_2007_POSTFIX)) {
            throw new EllaEnglishException(CommonRetCode.SERVER_ERROR.getCode(), CommonRetCode.SERVER_ERROR.getMsg(), CommonRetCode.SERVER_ERROR.getDescription());
        }
        Workbook wb = ExcelUtil.getWorkbook((MultipartFile)file, (String)fileName);
        Sheet sheet = wb.getSheetAt(0);
        if (null == sheet) {
            return 0;
        }
        Date now = Calendar.getInstance().getTime();
        DataFormatter formatter = new DataFormatter();
        for (int r = 1; r <= sheet.getLastRowNum(); ++r) {
            Row row = sheet.getRow(r);
            if (null == row) continue;
            LexileEvaluationQuestion question = new LexileEvaluationQuestion();
            String optionA = null;
            String optionB = null;
            String optionC = null;
            String optionD = null;
            String key = null;
            try {
                String formId = formatter.formatCellValue(row.getCell(0));
                if (null == formId || "".equals(formId)) continue;
                String wordCount = null;
                try {
                    wordCount = formatter.formatCellValue(row.getCell(6));
                }
                catch (Exception e) {
                    wordCount = "NONE";
                }
                optionA = formatter.formatCellValue(row.getCell(9));
                optionB = formatter.formatCellValue(row.getCell(10));
                optionC = formatter.formatCellValue(row.getCell(11));
                optionD = formatter.formatCellValue(row.getCell(12));
                key = formatter.formatCellValue(row.getCell(13));
                this.setQuestion(evaluationId, now, formatter, row, question, formId, wordCount);
            }
            catch (Exception e) {
                log.info("{}", (Throwable)e);
                throw new EllaEnglishException(CommonRetCode.FILE_FORMAT_ERROR.getCode(), CommonRetCode.FILE_FORMAT_ERROR.getMsg(), null);
            }
            LexileEvaluationQuestion ques = new LexileEvaluationQuestion();
            ques.setIdx(question.getIdx());
            ques.setImsId(question.getImsId());
            ques.setStatus("NORMAL");
            ques.setEvaluationId(Long.valueOf(evaluationId));
            int count = this.questionMapper.isExistQuestion(ques);
            if (count > 0) {
                log.info("excel \u7b2c{}\u884c\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u3002\u8be6\u60c5\uff1a{}", (Object)r, (Object)JSONObject.toJSONString((Object)ques));
                continue;
            }
            this.questionMapper.insert(question);
            ArrayList<LexileEvaluationQuestionItem> list = new ArrayList<LexileEvaluationQuestionItem>();
            for (int i = 0; i < 4; ++i) {
                LexileEvaluationQuestionItem item = new LexileEvaluationQuestionItem();
                item.setQuestionId(question.getId());
                item.setOptionKey("word");
                item.setIsMultiChocie(Boolean.valueOf(false));
                item.setCreateTime(now);
                item.setStatus("NORMAL");
                if (i == 0) {
                    item.setOptionKey("A");
                    item.setOptionContent(optionA);
                    if (optionA.trim().equalsIgnoreCase(key.trim())) {
                        item.setIsTrueAnswer(Boolean.valueOf(true));
                    } else {
                        item.setIsTrueAnswer(Boolean.valueOf(false));
                    }
                } else if (i == 1) {
                    item.setOptionKey("B");
                    item.setOptionContent(optionB);
                    if (optionB.trim().equalsIgnoreCase(key.trim())) {
                        item.setIsTrueAnswer(Boolean.valueOf(true));
                    } else {
                        item.setIsTrueAnswer(Boolean.valueOf(false));
                    }
                } else if (i == 2) {
                    item.setOptionKey("C");
                    item.setOptionContent(optionC);
                    if (optionC.trim().equalsIgnoreCase(key.trim())) {
                        item.setIsTrueAnswer(Boolean.valueOf(true));
                    } else {
                        item.setIsTrueAnswer(Boolean.valueOf(false));
                    }
                } else if (i == 3) {
                    item.setOptionKey("D");
                    item.setOptionContent(optionD);
                    if (optionD.trim().equalsIgnoreCase(key.trim())) {
                        item.setIsTrueAnswer(Boolean.valueOf(true));
                    } else {
                        item.setIsTrueAnswer(Boolean.valueOf(false));
                    }
                }
                list.add(item);
            }
            this.questionItemMapper.batchInsert(list);
        }
        return 1;
    }

    private void setQuestion(String evaluationId, Date now, DataFormatter formatter, Row row, LexileEvaluationQuestion question, String formId, String wordCount) {
        question.setEvaluationId(Long.valueOf(evaluationId));
        question.setGenre(formatter.formatCellValue(row.getCell(5)));
        question.setQuestionType(formatter.formatCellValue(row.getCell(4)));
        question.setQuestionStem(formatter.formatCellValue(row.getCell(8)));
        question.setQuestionText(formatter.formatCellValue(row.getCell(7)));
        question.setFormId(formId);
        question.setFormName(formatter.formatCellValue(row.getCell(1)));
        question.setImsId(formatter.formatCellValue(row.getCell(3)));
        question.setIdx(Integer.valueOf("".equals(formatter.formatCellValue(row.getCell(2))) ? 0 : Integer.valueOf(formatter.formatCellValue(row.getCell(2)))));
        question.setWordCount(Integer.valueOf("NONE".equalsIgnoreCase(wordCount) || "".equalsIgnoreCase(wordCount) ? 0 : Integer.valueOf(wordCount)));
        question.setCreateTime(now);
        question.setStatus("NORMAL");
    }

    @Transactional(rollbackFor={Exception.class})
    public LexileEvaluationPageDto getOneLexileQuestions(SelectOneLexileQuestionsRequest request) {
        LexileEvaluation lexile = this.mapper.selectByPrimaryKey(request.getId());
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List list = this.questionMapper.selectByEvaluationId(request.getId());
        LexileEvaluationPageDto dto = new LexileEvaluationPageDto();
        BeanUtils.copyProperties((Object)lexile, (Object)dto);
        dto.setQuestionDtoList(new PageInfo(list));
        return dto;
    }

    public LexileEvaluationDto selectByLevelCode(String levelCode) {
        return this.selectDetailByLevelCode(levelCode, false);
    }

    public LexileEvaluationDto selectDetailByLevelCode(String levelCode) {
        return this.selectDetailByLevelCode(levelCode, true);
    }

    private LexileEvaluationDto selectDetailByLevelCode(String levelCode, boolean withDetail) {
        LexileEvaluation eva = this.mapper.selectByLevelId(Integer.valueOf(LevelEnum.ofCode((String)levelCode).getId()));
        return this.eva2EvaDto(withDetail, eva);
    }

    public LexileEvaluationDto selectById(Long id) {
        return this.selectById(id, false);
    }

    public LexileEvaluationDto selectDetailById(Long id) {
        return this.selectById(id, true);
    }

    private LexileEvaluationDto selectById(Long id, boolean withDetail) {
        LexileEvaluation eva = this.mapper.selectByPrimaryKey(id);
        return this.eva2EvaDto(withDetail, eva);
    }

    private LexileEvaluationDto eva2EvaDto(boolean withDetail, LexileEvaluation eva) {
        LexileEvaluationDto le = null;
        if (Objects.nonNull(eva)) {
            le = new LexileEvaluationDto();
            BeanUtils.copyProperties((Object)eva, (Object)le);
            if (withDetail) {
                this.handleEvaluationDetail(le);
            }
        }
        return le;
    }

    public void handleEvaluationDetail(LexileEvaluationDto eva) {
        List qds = this.questionMapper.listQuestionDetail(eva.getId());
        if (qds != null) {
            TreeMap questions = new TreeMap();
            qds.forEach(m -> {
                ArrayList<LexileEvaluationQuestionItemDto> qis;
                Integer qidx = (Integer)m.get("qidx");
                LexileEvaluationQuestionDto q = (LexileEvaluationQuestionDto)questions.get(qidx);
                if (q == null) {
                    q = new LexileEvaluationQuestionDto();
                    q.setId((Long)m.get("qid"));
                    q.setIdx(qidx);
                    q.setQuestionType((String)m.get("qtype"));
                    q.setQuestionText((String)m.get("qtext"));
                    q.setWordCount((Integer)m.get("qwc"));
                    q.setQuestionStem((String)m.get("qstem"));
                    q.setFormId((String)m.get("qformid"));
                    q.setImsId((String)m.get("qimsid"));
                    questions.put(qidx, q);
                }
                if ((qis = q.getQuestionItemDtoList()) == null) {
                    qis = new ArrayList<LexileEvaluationQuestionItemDto>();
                    q.setQuestionItemDtoList(qis);
                }
                LexileEvaluationQuestionItemDto qi = new LexileEvaluationQuestionItemDto();
                qi.setId((Long)m.get("iid"));
                qi.setOptionKey((String)m.get("iok"));
                qi.setOptionContent((String)m.get("ioc"));
                qi.setOptionType((String)m.get("iot"));
                qi.setIsTrueAnswer((Boolean)m.get("itrueanswer"));
                qis.add(qi);
            });
            eva.setQuestionDtoList(new ArrayList(questions.values()));
        }
    }

    public LexileEvaluationQuestionDto getQuestionDetail(Long questionId) {
        LexileEvaluationQuestion question = this.questionMapper.selectByPrimaryKey(questionId);
        if (null == question) {
            return null;
        }
        List itemList = this.questionItemMapper.selectByQuestionId(question.getId());
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return null;
        }
        LexileEvaluationQuestionDto dto = new LexileEvaluationQuestionDto();
        BeanUtils.copyProperties((Object)question, (Object)dto);
        ArrayList dtoList = new ArrayList();
        itemList.forEach(item -> {
            LexileEvaluationQuestionItemDto i = new LexileEvaluationQuestionItemDto();
            BeanUtils.copyProperties((Object)item, (Object)i);
            dtoList.add(i);
        });
        dto.setQuestionItemDtoList(dtoList);
        return dto;
    }
}

