/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.ella.resource.domain.Attach;
import com.ella.resource.domain.Level;
import com.ella.resource.dto.appdto.LevelPopupDto;
import com.ella.resource.mapper.AttachMapper;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.service.transactional.LevelTService;
import com.ella.resource.utils.FillModeUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class LevelTServiceImpl
implements LevelTService {
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private AttachMapper attachMapper;
    @Autowired
    private MapMapper mapMapper;

    @Transactional(rollbackFor={Exception.class})
    public int updateLevel(Level level) {
        Attach attach = null;
        List attachList = this.attachMapper.selectByRelCode(level.getLevelCode());
        if (CollectionUtils.isEmpty((Collection)attachList)) {
            attach = FillModeUtils.fillAttach((String)level.getAttachCode(), (String)level.getLevelCode(), null);
            this.attachMapper.insertSelective(attach);
            level.setAttachCode(attach.getCode());
        } else {
            attach = (Attach)attachList.get(0);
            attach.setFilePath(level.getAttachCode());
            this.attachMapper.updateByPrimaryKeySelective(attach);
        }
        level.setAttachCode(attach.getCode());
        return this.levelMapper.updateByPrimaryKeySelective(level);
    }

    public LevelPopupDto getLevelDtoByCode(String code) {
        Level level = this.levelMapper.selectByCode(code);
        if (null == level) {
            return null;
        }
        LevelPopupDto result = new LevelPopupDto();
        BeanUtils.copyProperties((Object)level, (Object)result);
        int mapNums = this.mapMapper.selectMapNums(code);
        result.setMapNum(Integer.valueOf(mapNums));
        result.setMissionNum(Integer.valueOf(this.mapMapper.selectMissionNums(code)));
        Attach attach = this.attachMapper.selectByCode(level.getAttachCode());
        result.setAttachCode(null == attach ? "" : attach.getFilePath());
        return result;
    }
}

