/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional.impl;

import com.alibaba.fastjson.JSONObject;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.ExamRemark;
import com.ella.resource.domain.QuestionRecord;
import com.ella.resource.domain.ResExam;
import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.ResExamDetailDto;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.EnTestDto;
import com.ella.resource.dto.appdto.ExamTestResultDto;
import com.ella.resource.dto.appdto.TestRecordDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.app.TestAnswerInfoRequest;
import com.ella.resource.dto.request.app.TestAnswerRequest;
import com.ella.resource.mapper.ResExamDetailMapper;
import com.ella.resource.mapper.ResExamMapper;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.AbstractEnTest;
import com.ella.resource.service.transactional.RpcService;
import com.ella.resource.utils.ModeTransformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExamTestServiceImpl
extends AbstractEnTest {
    private static final Logger log = LogManager.getLogger(ExamTestServiceImpl.class);
    @Autowired
    private ResQuestionMapper resQuestionMapper;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private ResExamMapper resExamMapper;
    @Autowired
    private ResExamDetailMapper resExamDetailMapper;

    protected AnalysisTestInfoDto doAnalysisTestAnswer(TestAnswerRequest request, BaseMission mission) {
        AnalysisTestInfoDto result = new AnalysisTestInfoDto();
        boolean isPass = this.isPass(request, mission);
        result.setIsPass(Boolean.valueOf(isPass));
        ExamTestResultDto dto = new ExamTestResultDto();
        ArrayList errorQuestionIds = new ArrayList();
        Map idAnswerMap = this.getIdAnswerMap(request);
        ResExam resExam = this.resExamMapper.selectByPrimaryKey(Long.valueOf(mission.getResourceId().longValue()));
        List resExamDetailList = this.resExamDetailMapper.selectDetailsById(Long.valueOf(mission.getResourceId().longValue()));
        Integer[] score = new Integer[]{0, 0};
        HashMap errorQuestionIdMissionInfoMap = new HashMap(resExamDetailList.size());
        resExamDetailList.forEach(r -> {
            score[0] = score[0] + Optional.ofNullable(r.getQuestionScore()).orElse(0);
            if (idAnswerMap.containsKey(r.getQuestionId()) && !((TestAnswerInfoRequest)idAnswerMap.get(r.getQuestionId())).getIsTrue().booleanValue()) {
                score[1] = score[1] + Optional.ofNullable(r.getQuestionScore()).orElse(0);
                errorQuestionIds.add(r.getQuestionId());
                errorQuestionIdMissionInfoMap.put(r.getQuestionId(), r.getKnowledgeMission());
            }
        });
        ArrayList enTestDtoList = new ArrayList();
        this.transformToEnTestDtoList(enTestDtoList, this.getResQuestionList(errorQuestionIds), this.getResQuestionItemList(errorQuestionIds));
        this.setMissionIfo(enTestDtoList, idAnswerMap, errorQuestionIdMissionInfoMap, request.getUid());
        dto.setErrorNum(Integer.valueOf(errorQuestionIds.size()));
        dto.setTotalScore(score[0]);
        dto.setGotScore(Integer.valueOf(score[0] - score[1]));
        dto.setRemark(ExamTestServiceImpl.getRemark((String)resExam.getRemark(), (Integer)dto.getGotScore()));
        dto.setErrorTestList(enTestDtoList);
        dto.setPassNum(mission.getPassNum());
        dto.setRightNum(this.getPassNum(request));
        result.setAnalysisResult((Object)dto);
        return result;
    }

    protected void afterCompletion(TestAnswerRequest request, BaseMission mission, UserMission userMission) {
        log.info("ExamTestServiceImpl.afterCompletion mission :{}", (Object)mission);
        Integer passNum = this.getPassNum(request);
        if (passNum > userMission.getCorrectNum()) {
            log.info("ExamTestServiceImpl.afterCompletion addUserStoneNum param {},{},{} ", (Object)request.getUid(), (Object)mission.getId(), (Object)this.getPassNum(request));
            this.rpcService.addUserStoneNum(request.getUid(), mission.getId(), Integer.valueOf(passNum - userMission.getCorrectNum()));
            userMission.setCorrectNum(passNum);
        }
        Map idAnswerMap = this.getIdAnswerMap(request);
        List resExamDetailList = this.resExamDetailMapper.selectDetailsById(Long.valueOf(mission.getResourceId().longValue()));
        Integer[] score = new Integer[]{0};
        resExamDetailList.forEach(r -> {
            score[0] = score[0] + (idAnswerMap.containsKey(r.getQuestionId()) ? (((TestAnswerInfoRequest)idAnswerMap.get(r.getQuestionId())).getIsTrue().booleanValue() ? Optional.ofNullable(r.getQuestionScore()).orElse(0) : 0) : 0);
        });
        Integer totalNum = request.getAnswerInfoList().size();
        userMission.setScore(Float.valueOf(score[0].floatValue()));
        userMission.setTestNum(totalNum);
        userMission.setStatus("PASS");
        log.info("ExamTestServiceImpl.afterCompletion begin updateByPrimaryKeySelective");
        this.userMissionMapper.updateByPrimaryKeySelective(userMission);
    }

    protected List<ResQuestion> getResQuestion(Long resourceId) {
        return this.resQuestionMapper.selectExamQuestionByExamId(resourceId);
    }

    protected void doQuestionRecord(TestRecordDto result, List<QuestionRecord> questionRecords, BaseMission mission) {
        List questionIds = questionRecords.stream().map(QuestionRecord::getQuestionId).collect(Collectors.toList());
        Map missionMaps = ModeTransformUtils.getCodeAndTMap((List)this.getAllMissionInfo(), (String)"missionId");
        List missionInfoDtoList = this.selectAllUserMissionWithOrder(result.getUid());
        List resExamDetailList = this.resExamDetailMapper.selectDetailsById(Long.valueOf(mission.getResourceId().longValue()));
        if (!CollectionUtils.isEmpty((Collection)resExamDetailList)) {
            for (ResExamDetailDto r : resExamDetailList) {
                NextMissionInfoDto missionInfo;
                if (!questionIds.contains(r.getQuestionId())) continue;
                if (CollectionUtils.isEmpty((Collection)result.getContentFroms())) {
                    result.setContentFroms(new ArrayList());
                }
                if (!Objects.nonNull(missionInfo = this.getEventualMissionInfo(missionInfoDtoList, missionMaps, r.getKnowledgeMission()))) continue;
                result.getContentFroms().add(missionInfo);
            }
            result.setIsPass(Boolean.valueOf(resExamDetailList.size() - questionIds.size() >= mission.getPassNum()));
        }
    }

    private void setMissionIfo(List<EnTestDto> enTestDtoList, Map<Long, TestAnswerInfoRequest> idAnswerMap, Map<Long, String> errorQuestionIdMissionInfoMap, String uid) {
        Map missionMaps = ModeTransformUtils.getCodeAndTMap((List)this.getAllMissionInfo(), (String)"missionId");
        List missionInfoDtoList = this.selectAllUserMissionWithOrder(uid);
        enTestDtoList.forEach(e -> {
            e.setUserOption(this.getItemKey((TestAnswerInfoRequest)idAnswerMap.get(e.getQuestionId())));
            e.setContentFrom(this.getContentFrom(missionMaps, e, errorQuestionIdMissionInfoMap, missionInfoDtoList));
        });
    }

    private NextMissionInfoDto getContentFrom(Map<String, Object> missionMaps, EnTestDto e, Map<Long, String> errorQuestionIdMissionInfoMap, List<NextMissionInfoDto> missionInfoDtoList) {
        if (null == errorQuestionIdMissionInfoMap.get(e.getQuestionId())) {
            return new NextMissionInfoDto();
        }
        if (null == missionMaps.get(errorQuestionIdMissionInfoMap.get(e.getQuestionId()))) {
            return new NextMissionInfoDto();
        }
        return this.getEventualMissionInfo(missionInfoDtoList, missionMaps, errorQuestionIdMissionInfoMap.get(e.getQuestionId()));
    }

    private Map<Long, TestAnswerInfoRequest> getIdAnswerMap(TestAnswerRequest request) {
        HashMap<Long, TestAnswerInfoRequest> result = new HashMap<Long, TestAnswerInfoRequest>(request.getAnswerInfoList().size());
        request.getAnswerInfoList().forEach(a -> result.put(a.getQuestionId().longValue(), (TestAnswerInfoRequest)a));
        return result;
    }

    private static String getRemark(String remark, Integer gotScore) {
        log.info("ExamTest remark is {},gotScore is {}", (Object)remark, (Object)gotScore);
        if (StringUtils.isBlank((CharSequence)remark)) {
            return "";
        }
        try {
            List examRemarkList = JSONObject.parseArray((String)remark, ExamRemark.class);
            if (CollectionUtils.isEmpty((Collection)examRemarkList)) {
                return "";
            }
            examRemarkList.removeIf(e -> Objects.isNull(e) || Objects.isNull(e.getFloor()));
            List collect = examRemarkList.stream().filter(e -> e.getFloor() <= gotScore && e.getTop() >= gotScore).map(ExamRemark::getTips).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return "";
            }
            return (String)collect.get(0);
        }
        catch (Exception e2) {
            log.error("getRemark error {}", (Throwable)e2);
            return "";
        }
    }

    public static void main(String[] args) {
        String remark = "[{\"floor\":0,\"top\":29,\"tips\":\"\u4e0d\u53ca\u683c\uff0c\u8bf7\u52a0\u6cb9\u54e6~\"},{\"floor\":30,\"top\":89,\"tips\":\"\u5f88\u4e0d\u9519\u54e6\uff0c\u4f60\u8fc7\u5173\u5566\uff01\"},{\"floor\":90,\"top\":100,\"tips\":\"\u597d\u68d2\u554a\uff0c\u5c45\u7136\u5168\u90e8\u505a\u5bf9\u4e86\uff01\"},{},{}]";
        System.out.println(ExamTestServiceImpl.getRemark((String)remark, (Integer)89));
    }
}

