/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service.transactional;

import com.ella.resource.api.EnTest;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.domain.BaseMission;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.QuestionRecord;
import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.ResQuestionItem;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.appdto.AnalysisTestInfoDto;
import com.ella.resource.dto.appdto.EnTestDto;
import com.ella.resource.dto.appdto.EnTestItemsDto;
import com.ella.resource.dto.appdto.TestRecordDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.app.GetEnTestListRequest;
import com.ella.resource.dto.request.app.TestAnswerInfoRequest;
import com.ella.resource.dto.request.app.TestAnswerRequest;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.QuestionRecordMapper;
import com.ella.resource.mapper.ResQuestionItemMapper;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.MissionTService;
import com.ella.resource.service.transactional.UserMapTService;
import com.ella.resource.service.transactional.UserMissionTService;
import com.ella.resource.utils.EnTestTypeEnum;
import com.ella.resource.utils.ModeTransformUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public abstract class AbstractEnTest
implements EnTest {
    private static final Logger log = LogManager.getLogger(AbstractEnTest.class);
    @Autowired
    private QuestionRecordMapper questionRecordMapper;
    @Autowired
    private ResQuestionItemMapper resQuestionItemMapper;
    @Autowired
    private ResQuestionMapper resQuestionMapper;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private MissionTService missionTService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private UserMapTService userMapTService;
    @Autowired
    private UserMissionTService userMissionTService;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private LevelMapper levelMapper;

    @Transactional(rollbackFor={Exception.class})
    public List<EnTestDto> getTestList(GetEnTestListRequest request) {
        ArrayList<EnTestDto> result = new ArrayList<EnTestDto>();
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission) {
            return result;
        }
        this.autoAcquireForFreeMission(request, mission);
        List resQuestionList = this.getResQuestion(Long.valueOf(mission.getResourceId().longValue()));
        if (CollectionUtils.isEmpty((Collection)resQuestionList)) {
            return result;
        }
        List questionIds = this.getQuestionIds(resQuestionList);
        this.transformToEnTestDtoList(result, resQuestionList, this.getResQuestionItemList(questionIds));
        return result;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public AnalysisTestInfoDto analysisTestAnswer(TestAnswerRequest request) {
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission) {
            return new AnalysisTestInfoDto();
        }
        AnalysisTestInfoDto result = this.doAnalysisTestAnswer(request, mission);
        UserMission userMission = this.userMissionMapper.selectByUidAndMissionCode(request.getUid(), mission.getMissionCode());
        Integer preCorrectNum = userMission.getCorrectNum() == null ? 0 : userMission.getCorrectNum();
        if (result.getIsPass().booleanValue()) {
            boolean isFirstPass = false;
            boolean isLastMission = false;
            if (!"PASS".equals(userMission.getStatus())) {
                isFirstPass = true;
                UserMission lastUserMission = this.userMissionMapper.selectLastMissionByLevel(userMission.getUid(), userMission.getLevelCode());
                if (lastUserMission != null && lastUserMission.getMissionCode().equals(userMission.getMissionCode())) {
                    isLastMission = true;
                }
            }
            Integer passNum = this.getPassNum(request);
            result.setGotStoneNum(passNum);
            if (null != userMission) {
                this.userMapTService.updateUserMapWhenMissionFinish(userMission.getMapCode(), request.getUid(), userMission.getMissionCode(), Integer.valueOf(passNum > userMission.getCorrectNum() ? passNum - userMission.getCorrectNum() : 0), userMission.getStatus());
                this.afterCompletion(request, mission, userMission);
            }
            NextMissionInfoDto nextMissionInfoDto = this.missionTService.getJumpMissionInfo(mission.getId(), request.getUid());
            result.setNextMissionInfo(nextMissionInfoDto);
            if (nextMissionInfoDto != null && nextMissionInfoDto.isSnapLastUserMission()) {
                NextMissionInfoDto nextMissionInfoDtox;
                String nextLevelCode = userMission.getLevelCode();
                if (isLastMission) {
                    nextLevelCode = String.valueOf(Integer.valueOf(nextLevelCode) + 1);
                }
                if ((nextMissionInfoDtox = this.userMapAndMissionService.updateUserMapAfterTest(isLastMission ? nextLevelCode : null, request.getUid(), nextMissionInfoDto.getMapCode(), nextMissionInfoDto.getMissionCode())) != null) {
                    result.setNextMissionInfo(nextMissionInfoDtox);
                    if (isFirstPass && isLastMission) {
                        this.userInfoService.updateUserLevelInfo(UpdateUserLevelRequest.builder().uid(request.getUid()).lexileLevel("NO").levelCode(nextLevelCode).build());
                    }
                }
            }
            if (result.getNextMissionInfo() != null && userMission.getMissionType() != null && !userMission.getMissionType().equals(0)) {
                this.userMapTService.updateUserMapAndMissionToDoing(request.getUid(), nextMissionInfoDto.getMapCode(), nextMissionInfoDto.getMissionCode());
            }
        } else {
            this.userMissionTService.updateUserMissionStatusToDoing(userMission, null);
        }
        if (result.getNextMissionInfo() == null && "PASS".equals(userMission.getStatus())) {
            NextMissionInfoDto nextMissionInfoDto = this.missionTService.getJumpMissionInfo(mission.getId(), request.getUid());
            result.setNextMissionInfo(nextMissionInfoDto);
        }
        mission.setStatus(userMission.getStatus());
        this.recordTestAnswer(request, mission, result, preCorrectNum, userMission.getCorrectNum());
        if ("PASS".equals(mission.getStatus())) {
            result.setIsPass(Boolean.valueOf(true));
        }
        return result;
    }

    public TestRecordDto getLastTimeQuestionRecord(GetEnTestListRequest request) {
        TestRecordDto result = new TestRecordDto();
        result.setUid(request.getUid());
        BaseMission mission = this.userMissionTService.getMissionById(request.getId());
        if (null == mission) {
            return result;
        }
        result.setPassNum(mission.getPassNum());
        QuestionRecord param = new QuestionRecord();
        param.setMessionId(mission.getMissionCode());
        param.setUserId(request.getUid());
        param.setExamType(request.getTestType().toUpperCase());
        param.setIsTrue(Boolean.FALSE);
        List questionRecords = this.questionRecordMapper.selectList(param);
        if (CollectionUtils.isEmpty((Collection)questionRecords)) {
            result.setIsPass(Boolean.TRUE);
            result.setNextMissionInfo(this.missionTService.getJumpMissionInfo(mission.getId(), request.getUid()));
            return result;
        }
        result.setErrorNum(Integer.valueOf(questionRecords.size()));
        this.doQuestionRecord(result, questionRecords, mission);
        if (result.getIsPass().booleanValue()) {
            result.setNextMissionInfo(this.missionTService.getJumpMissionInfo(mission.getId(), request.getUid()));
        }
        return result;
    }

    public List<EnTestDto> testListPreview(GetEnTestListRequest request) {
        ArrayList<EnTestDto> result = new ArrayList<EnTestDto>();
        List resQuestionList = this.getResQuestion(request.getId());
        if (CollectionUtils.isEmpty((Collection)resQuestionList)) {
            return result;
        }
        List questionIds = this.getQuestionIds(resQuestionList);
        this.transformToEnTestDtoList(result, resQuestionList, this.getResQuestionItemList(questionIds));
        return result;
    }

    protected List<NextMissionInfoDto> getAllMissionInfo() {
        return this.missionMapper.selectAllWithOrder();
    }

    protected List<NextMissionInfoDto> selectAllUserMissionWithOrder(String uid) {
        return this.missionMapper.selectAllUserMissionWithOrder(uid);
    }

    protected NextMissionInfoDto getSnapshotInfoByMissionCode(String missionCode, String uid) {
        if (StringUtils.isBlank((CharSequence)missionCode)) {
            return null;
        }
        List nextMissionInfoDtos = this.selectAllUserMissionWithOrder(uid);
        if (CollectionUtils.isEmpty((Collection)nextMissionInfoDtos)) {
            return null;
        }
        List result = nextMissionInfoDtos.stream().filter(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getMissionCode(), (CharSequence)missionCode)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return (NextMissionInfoDto)result.get(0);
    }

    protected NextMissionInfoDto getSnapshotInfoByMissionCode(List<NextMissionInfoDto> nextMissionInfoDtos, String missionCode) {
        if (StringUtils.isBlank((CharSequence)missionCode) || CollectionUtils.isEmpty(nextMissionInfoDtos)) {
            return null;
        }
        List result = nextMissionInfoDtos.stream().filter(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getMissionCode(), (CharSequence)missionCode)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return (NextMissionInfoDto)result.get(0);
    }

    protected NextMissionInfoDto getEventualMissionInfo(List<NextMissionInfoDto> nextMissionInfoDtos, java.util.Map<String, Object> missionMaps, String missionId) {
        NextMissionInfoDto nextMissionInfoDto = (NextMissionInfoDto)missionMaps.get(missionId);
        if (Objects.nonNull(nextMissionInfoDto)) {
            NextMissionInfoDto userNextMissionInfoDto = this.getSnapshotInfoByMissionCode(nextMissionInfoDtos, nextMissionInfoDto.getMissionCode());
            if (Objects.nonNull(userNextMissionInfoDto)) {
                return userNextMissionInfoDto;
            }
            if ("NORMAL".equalsIgnoreCase(nextMissionInfoDto.getMissionStatus())) {
                return nextMissionInfoDto;
            }
            log.info("method doQuestionRecord mission status of knowledgeMission is:{}", (Object)nextMissionInfoDto.getMissionStatus());
            return null;
        }
        log.info("method doQuestionRecord knowledgeMission id {} is not exist", (Object)missionId);
        return null;
    }

    protected Map getMapByCode(String mapCode) {
        return this.mapMapper.selectByMapCode(mapCode);
    }

    protected Boolean recordTestAnswer(TestAnswerRequest request, BaseMission mission, AnalysisTestInfoDto response, Integer preCorrectNum, Integer newCorrectNum) {
        int result = 0;
        QuestionRecord param = new QuestionRecord();
        param.setUserId(request.getUid());
        param.setMessionId(mission.getMissionCode());
        param.setExamId(Long.valueOf(mission.getResourceId().longValue()));
        param.setExamType(request.getTestType().toUpperCase());
        Integer correctNumx = this.questionRecordMapper.selectCorrectNum(request.getUid(), mission.getMissionCode(), mission.getResourceId(), "EXAM");
        List recordList = this.questionRecordMapper.selectList(param);
        AtomicInteger correctNum = new AtomicInteger();
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            ArrayList insertBatchParam = new ArrayList(request.getAnswerInfoList().size());
            request.getAnswerInfoList().forEach(a -> {
                QuestionRecord record = new QuestionRecord();
                record.setMessionId(mission.getMissionCode());
                record.setUserId(request.getUid());
                record.setCreateBy(request.getUid());
                record.setCreateTime(new Date());
                record.setExamId(Long.valueOf(mission.getResourceId().longValue()));
                record.setExamType(request.getTestType().toUpperCase());
                record.setIsTrue(a.getIsTrue());
                record.setItemKey(this.getItemKey(a));
                record.setQuestionId(Long.valueOf(a.getQuestionId().longValue()));
                record.setQuestionType(a.getQuestionType());
                record.setStatus("NORMAL");
                record.setUpdateBy(request.getUid());
                insertBatchParam.add(record);
                if (a.getIsTrue().booleanValue()) {
                    correctNum.getAndIncrement();
                }
            });
            result = this.questionRecordMapper.insertBatch(insertBatchParam);
            if (response.getIsPass().booleanValue()) {
                response.setGotTotalStoneNum(Integer.valueOf(correctNum.get()));
            }
        } else {
            java.util.Map keyAnswerMap = this.getKeyAnswerMap(request, mission);
            recordList.forEach(r -> {
                String key = r.getQuestionId().toString() + r.getExamType();
                r.setUpdateBy(request.getUid());
                r.setUpdateTime(new Date());
                if (keyAnswerMap.containsKey(key)) {
                    r.setIsTrue(((TestAnswerInfoRequest)keyAnswerMap.get(key)).getIsTrue());
                    r.setItemKey(this.getItemKey((TestAnswerInfoRequest)keyAnswerMap.get(key)));
                }
                if (r.getIsTrue().booleanValue()) {
                    correctNum.getAndIncrement();
                }
            });
            result = this.questionRecordMapper.updateBatch(recordList);
        }
        if ("PASS".equals(mission.getStatus())) {
            response.setGotTotalStoneNum(newCorrectNum);
        }
        if ("PASS".equals(mission.getStatus()) && response.getIsPass().booleanValue() && preCorrectNum < correctNum.get()) {
            response.setAddGotStoneNum(Integer.valueOf(correctNum.get() - preCorrectNum));
        }
        return result > 0;
    }

    protected void transformToEnTestDtoList(List<EnTestDto> result, List<ResQuestion> resQuestionList, List<ResQuestionItem> resQuestionItemList) {
        java.util.Map questionIdItemsMap = ModeTransformUtils.getCodeAndTListMap(resQuestionItemList, (String)"questionId");
        resQuestionList.forEach(r -> {
            EnTestDto enTestDto = new EnTestDto();
            this.jointEnTestDtoWithResQuestion(enTestDto, r);
            enTestDto.setEnTestItems(this.getEnTestItemsListFromResQuestionItemList((List)questionIdItemsMap.get(r.getId().toString())));
            result.add(enTestDto);
        });
    }

    protected Boolean isPass(TestAnswerRequest request, BaseMission mission) {
        if (mission.getPassNum() > this.getPassNum(request)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Integer getPassNum(TestAnswerRequest request) {
        return request.getAnswerInfoList().stream().filter(TestAnswerInfoRequest::getIsTrue).collect(Collectors.toList()).size();
    }

    protected List<ResQuestion> getResQuestionList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ResQuestion>();
        }
        return this.resQuestionMapper.selectByIds(ids);
    }

    protected List<ResQuestionItem> getResQuestionItemList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ResQuestionItem>();
        }
        return this.resQuestionItemMapper.selectByQuestionIds(ids);
    }

    private java.util.Map<String, TestAnswerInfoRequest> getKeyAnswerMap(TestAnswerRequest request, BaseMission mission) {
        HashMap<String, TestAnswerInfoRequest> result = new HashMap<String, TestAnswerInfoRequest>(request.getAnswerInfoList().size());
        request.getAnswerInfoList().forEach(a -> result.put(a.getQuestionId().toString() + request.getTestType().toUpperCase(), (TestAnswerInfoRequest)a));
        return result;
    }

    protected String getItemKey(TestAnswerInfoRequest a) {
        if (null == a) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        a.getTestAnswerItems().forEach(t -> result.append(StringUtils.isBlank((CharSequence)t.getItemKey()) ? t.getItemId().toString() : t.getItemKey()).append(" "));
        return result.toString();
    }

    private List<Long> getQuestionIds(List<ResQuestion> resQuestionList) {
        return resQuestionList.stream().map(ResQuestion::getId).collect(Collectors.toList());
    }

    private void jointEnTestDtoWithResQuestion(EnTestDto enTestDto, ResQuestion resQuestion) {
        enTestDto.setQuestionId(resQuestion.getId());
        enTestDto.setCorrectAnswer(resQuestion.getCorrectAnswer());
        enTestDto.setQuestionName(resQuestion.getQuestionName());
        enTestDto.setQuestionType(resQuestion.getQuestionType());
        enTestDto.setVoice(resQuestion.getVoice());
    }

    private List<EnTestItemsDto> getEnTestItemsListFromResQuestionItemList(List<Object> resQuestionItemList) {
        ArrayList<EnTestItemsDto> enTestItemsDtoList = new ArrayList<EnTestItemsDto>();
        if (CollectionUtils.isEmpty(resQuestionItemList)) {
            return enTestItemsDtoList;
        }
        resQuestionItemList.forEach(r -> {
            ResQuestionItem questionItem = (ResQuestionItem)r;
            EnTestItemsDto dto = new EnTestItemsDto();
            dto.setAnswerAnalysis(questionItem.getAnswerAnalysis());
            dto.setIsTrueAnswer(questionItem.getIsTrueAnswer());
            dto.setItemId(questionItem.getId());
            dto.setQuestionId(questionItem.getQuestionId());
            dto.setItemKey(questionItem.getItemKey());
            dto.setResItem(questionItem.getResItem());
            dto.setTextItem(questionItem.getTextItem());
            enTestItemsDtoList.add(dto);
        });
        return enTestItemsDtoList;
    }

    private void autoAcquireForFreeMission(GetEnTestListRequest request, BaseMission mission) {
        this.userMapTService.updateUserMapAndMissionToDoing(request.getUid(), mission.getMapCode(), mission.getMissionCode());
        if (request.getTestType().equalsIgnoreCase(EnTestTypeEnum.EXAM.getType()) || request.getTestType().equalsIgnoreCase(EnTestTypeEnum.TEST.getType())) {
            this.userMissionTService.insertUserMissionIfNotExist(request.getUid(), mission.getMissionCode(), mission.getMissionIndex(), mission.getMapCode(), this.getMapByCode(mission.getMapCode()).getLevelCode());
        }
    }

    protected abstract AnalysisTestInfoDto doAnalysisTestAnswer(TestAnswerRequest var1, BaseMission var2);

    protected abstract void afterCompletion(TestAnswerRequest var1, BaseMission var2, UserMission var3);

    protected abstract List<ResQuestion> getResQuestion(Long var1);

    protected abstract void doQuestionRecord(TestRecordDto var1, List<QuestionRecord> var2, BaseMission var3);
}

