/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.common.api.OssService;
import com.ella.common.api.dictionary.YoudaoService;
import com.ella.common.dto.dictionary.AudioTypeEnum;
import com.ella.common.dto.dictionary.DictionaryDto;
import com.ella.common.dto.dictionary.GetEnToCnTranslateRequest;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.CoreUtil;
import com.ella.resource.api.WordListImportService;
import com.ella.resource.domain.WordCategoryRelation;
import com.ella.resource.domain.WordCategoryRelationExample;
import com.ella.resource.domain.WordList;
import com.ella.resource.dto.WordCategoryDto;
import com.ella.resource.dto.WordListImportDto;
import com.ella.resource.dto.request.WordListImportReq;
import com.ella.resource.dto.request.WordListReq;
import com.ella.resource.mapper.BaseBookMapper;
import com.ella.resource.mapper.CategoryLevelRelationMapper;
import com.ella.resource.mapper.WordBookCodeRelationMapper;
import com.ella.resource.mapper.WordCategoryRelationMapper;
import com.ella.resource.mapper.WordListMapper;
import com.ella.resource.properties.WordListConfigProperties;
import com.ella.resource.utils.ExcelUtil;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.WordListUtil;
import com.ella.user.api.enums.DataStatusEnum;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class WordListImoprtServiceImpl
implements WordListImportService {
    private static final Logger log = LogManager.getLogger(WordListImoprtServiceImpl.class);
    @Autowired
    private CategoryLevelRelationMapper categoryLevelRelationMapper;
    @Autowired
    private WordListConfigProperties wordListConfigProperties;
    @Autowired
    private WordCategoryRelationMapper wordCategoryRelationMapper;
    @Autowired
    private WordListMapper wordListMapper;
    @Autowired
    private WordBookCodeRelationMapper wordBookCodeRelationMapper;
    @Autowired
    private BaseBookMapper baseBookMapper;
    @Autowired
    private YoudaoService youdaoService;
    @Autowired
    private DistributedCache redis;
    @Autowired
    private OssService ossService;

    @RequestMapping(value={"importWordListExcel/v1"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseParams<String> importWordListExcel(@RequestPart(value="file", required=false) MultipartFile file) {
        try {
            String filename = file.getOriginalFilename();
            ResponseParams responseParams = this.checkExcelName(filename);
            if (Objects.nonNull(responseParams)) {
                return responseParams;
            }
            List mapList = ExcelUtil.fileToList((MultipartFile)file);
            List wordListImportDtos = this.mapListToWordListImportDto(mapList);
            return this.checkWordsExists(wordListImportDtos);
        }
        catch (Exception e) {
            log.error("\u5355\u8bcd\u672c\u6279\u91cf\u5bfc\u5165\u5355\u8bcd\u6587\u4ef6\u89e3\u6790\u9519\u8bef -----> {[]}", (Throwable)e);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
        }
    }

    private List<WordListImportDto> mapListToWordListImportDto(List<Map<Integer, Object>> mapList) {
        ArrayList<WordListImportDto> wordListImportDtos = new ArrayList<WordListImportDto>();
        if (CollectionUtils.isNotEmpty(mapList)) {
            mapList.remove(0);
            for (Map<Integer, Object> objectMap : mapList) {
                Object obj;
                WordListImportDto wordListImportDto = new WordListImportDto();
                wordListImportDto.setWord(objectMap.get(0).toString());
                wordListImportDto.setLevelAndCategory(objectMap.get(1).toString());
                ArrayList<String> bookCodes = new ArrayList<String>();
                for (int i = 2; i < objectMap.size() && Objects.nonNull(obj = objectMap.get(i)) && StringUtils.isNotBlank((CharSequence)obj.toString()); ++i) {
                    bookCodes.add(obj.toString());
                }
                wordListImportDto.setBookCodes(bookCodes);
                wordListImportDtos.add(wordListImportDto);
            }
        }
        return wordListImportDtos;
    }

    private ResponseParams<String> checkWordsExists(List<WordListImportDto> wordListImportDtos) {
        String tempKey = CoreUtil.createCommonsCore((String)"TEMP");
        ArrayList categoryHasError = new ArrayList();
        ArrayList wordIllegal = new ArrayList();
        ArrayList categoryChanged = new ArrayList();
        ArrayList saveToDb = new ArrayList();
        if (CollectionUtils.isEmpty(wordListImportDtos)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
        }
        Map allCategoryAndLevelRelationMap = this.getAllCategoryAndLevelRelationMap();
        if (MapUtils.isEmpty((Map)allCategoryAndLevelRelationMap)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null, (String)"\u7b49\u7ea7\u7c7b\u522b\u5173\u7cfb\u8868\u5b58\u5728\u9519\u8bef");
        }
        List allWordToDb = this.getAllWordToDb(wordListImportDtos, categoryHasError, allCategoryAndLevelRelationMap);
        if (CollectionUtils.isEmpty((Collection)allWordToDb)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null, (String)"\u7b49\u7ea7\u7c7b\u522b\u5173\u7cfb\u8868\u5b58\u5728\u9519\u8bef\u6216word\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0a\u4f20");
        }
        ResponseParams responseParams = this.checkCategoryAndLevelIsChange(allWordToDb, categoryChanged, saveToDb, wordIllegal);
        if (Objects.nonNull(responseParams)) {
            return responseParams;
        }
        if (CollectionUtils.isNotEmpty(categoryHasError)) {
            this.redis.set("BOE:EN:LIST:ERROR:" + tempKey, (Object)JSONObject.toJSONString(categoryHasError), 180);
        }
        if (CollectionUtils.isNotEmpty(categoryChanged)) {
            this.redis.set("BOE:EN:LIST:CHANGED:" + tempKey, (Object)JSONObject.toJSONString(categoryChanged), 180);
        }
        if (CollectionUtils.isNotEmpty(wordIllegal)) {
            this.redis.set("BOE:EN:LIST:ILLEGAL:" + tempKey, (Object)JSONObject.toJSONString(wordIllegal), 180);
        }
        if (CollectionUtils.isNotEmpty(saveToDb)) {
            this.redis.set("BOE:EN:LIST:SAVE:" + tempKey, (Object)JSONObject.toJSONString(saveToDb), 180);
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(categoryChanged)) {
            String wordsStr = categoryChanged.stream().map(WordListImportDto::getWord).limit(this.wordListConfigProperties.getWordMaxAlertNum().intValue()).collect(Collectors.toList()).toString();
            responseParams = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
            returnMap.put("tempKey", tempKey);
            returnMap.put("words", wordsStr);
            responseParams.setData((Object)JSONObject.toJSONString(returnMap));
            return responseParams;
        }
        responseParams = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        returnMap.put("tempKey", tempKey);
        responseParams.setData((Object)JSONObject.toJSONString(returnMap));
        return responseParams;
    }

    private ResponseParams<String> checkCategoryAndLevelIsChange(List<WordListImportDto> allWordToDb, List<WordListImportDto> categoryChanged, List<WordListImportDto> saveToDb, List<WordListImportDto> wordIllegal) {
        int toIndex = 100;
        for (int i = 0; i < allWordToDb.size(); i += 100) {
            List<WordListImportDto> dtoList;
            List illegalWords;
            if (i + 100 > allWordToDb.size()) {
                toIndex = allWordToDb.size() - i;
            }
            if (CollectionUtils.isNotEmpty(illegalWords = (dtoList = allWordToDb.subList(i, i + toIndex)).stream().filter(e -> Objects.isNull(e) || StringUtils.isBlank((CharSequence)e.getWord()) || WordListUtil.checkWordIllegal((String)e.getWord()) || StringUtils.trim((String)e.getWord()).length() > this.wordListConfigProperties.getWordMaxSize()).collect(Collectors.toList()))) {
                wordIllegal.addAll(illegalWords);
                dtoList.removeAll(illegalWords);
            }
            if (CollectionUtils.isEmpty(dtoList)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null, (String)"\u8868\u683c\u4e2d\u4e0a\u4f20\u6240\u6709\u5355\u8bcd\u5747\u5b58\u5728\u9519\u8bef\uff0c\u5355\u8bcd\u53ea\u652f\u6301\u82f1\u6587\u548c\u7a7a\u683c\uff0c\u4e14\u6700\u591a20\u4e2a\u82f1\u6587\u5b57\u6bcd\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0a\u4f20");
            }
            List<String> words = dtoList.stream().map(WordListImportDto::getWord).collect(Collectors.toList());
            Map<String, WordListImportDto> wordListImportDtoMap = dtoList.stream().collect(Collectors.toMap(WordListImportDto::getWord, e -> e, (e1, e2) -> e1));
            List relationCodesExistInDb = this.wordCategoryRelationMapper.getRelationCodesByWords(words);
            if (CollectionUtils.isEmpty((Collection)relationCodesExistInDb)) {
                saveToDb.addAll(dtoList);
                continue;
            }
            List wordsExistsInRelation = relationCodesExistInDb.stream().map(WordListImportDto::getWord).collect(Collectors.toList());
            words.removeAll(wordsExistsInRelation);
            if (CollectionUtils.isNotEmpty(words)) {
                words.forEach(e -> saveToDb.add((WordListImportDto)wordListImportDtoMap.get(e)));
            }
            relationCodesExistInDb.forEach(word -> {
                String relationCodeStr = word.getLevelAndCategory();
                word.setRelationCodes(Arrays.asList(relationCodeStr.split(",")));
                boolean containsRelationCodeNotInDb = ((WordListImportDto)wordListImportDtoMap.get(word.getWord())).getRelationCodes().stream().anyMatch(relationCodeNeedCheck -> word.getRelationCodes().indexOf(relationCodeNeedCheck) == -1);
                if (containsRelationCodeNotInDb) {
                    categoryChanged.add((WordListImportDto)wordListImportDtoMap.get(word.getWord()));
                } else {
                    saveToDb.add((WordListImportDto)wordListImportDtoMap.get(word.getWord()));
                }
            });
        }
        return null;
    }

    private List<WordListImportDto> getAllWordToDb(List<WordListImportDto> wordListImportDtos, List<WordListImportDto> categoryHasError, Map<String, String> allCategoryAndLevelRelationMap) {
        ArrayList<WordListImportDto> allExcelWordToDb = new ArrayList<WordListImportDto>();
        for (WordListImportDto wordListImportDto : wordListImportDtos) {
            if (StringUtils.isBlank((CharSequence)wordListImportDto.getLevelAndCategory()) || StringUtils.isBlank((CharSequence)wordListImportDto.getWord())) {
                categoryHasError.add(wordListImportDto);
                continue;
            }
            ArrayList categoryAndLevel = new ArrayList();
            String levelAndCategory = this.splitCategoryAndLevel(wordListImportDto.getLevelAndCategory(), categoryAndLevel);
            if (StringUtils.isNotBlank((CharSequence)levelAndCategory)) {
                categoryHasError.add(wordListImportDto);
                continue;
            }
            if (CollectionUtils.isEmpty(categoryAndLevel)) {
                categoryHasError.add(wordListImportDto);
                continue;
            }
            if (categoryAndLevel.stream().anyMatch(s -> StringUtils.isBlank((CharSequence)((CharSequence)allCategoryAndLevelRelationMap.get(s))))) {
                categoryHasError.add(wordListImportDto);
                continue;
            }
            List relationCodes = categoryAndLevel.stream().map(allCategoryAndLevelRelationMap::get).collect(Collectors.toList());
            WordListImportDto word = WordListImportDto.builder().word(wordListImportDto.getWord()).bookCodes(wordListImportDto.getBookCodes()).relationCodes(relationCodes).build();
            allExcelWordToDb.add(word);
        }
        return allExcelWordToDb;
    }

    private Map<String, String> getAllCategoryAndLevelRelationMap() {
        List levelAndCategories = this.categoryLevelRelationMapper.getAllLevelAndCategories();
        HashMap<String, String> allWordCategoryRelationMap = new HashMap<String, String>(32);
        for (WordCategoryDto levelAndCategory : levelAndCategories) {
            String key = levelAndCategory.getLevelCode() + ":" + levelAndCategory.getCategoryName();
            allWordCategoryRelationMap.put(key, levelAndCategory.getRelationCode());
        }
        return allWordCategoryRelationMap;
    }

    private String splitCategoryAndLevel(String levelAndCategory, List<String> categoryAndLevel) {
        Object[] levelAndCategoryArr = levelAndCategory.split("/");
        if (ArrayUtils.isNotEmpty((Object[])levelAndCategoryArr)) {
            for (Object oneLevelAndCategory : levelAndCategoryArr) {
                Object[] split = ((String)oneLevelAndCategory).split(":");
                if (ArrayUtils.isEmpty((Object[])split) || split.length != 2) continue;
                Object level = split[0];
                Object categoriesStr = split[1];
                String[] categories = ((String)categoriesStr).split(",");
                if (categories.length > this.wordListConfigProperties.getCategoryMaxNumOfLevelOneWord()) {
                    return levelAndCategory;
                }
                for (String category : categories) {
                    categoryAndLevel.add((String)level + ":" + category);
                }
            }
        }
        return null;
    }

    private String concatCategoryAndLevel(List<String> levelAndCategory) {
        if (CollectionUtils.isNotEmpty(levelAndCategory)) {
            HashMap<String, StringBuilder> levelAndCategoryMap = new HashMap<String, StringBuilder>();
            for (String oneCategory : levelAndCategory) {
                String[] split = oneCategory.split(":");
                String levelCode = split[0];
                if (StringUtils.isBlank((CharSequence)((CharSequence)levelAndCategoryMap.get(levelCode)))) {
                    levelAndCategoryMap.put(levelCode, new StringBuilder(oneCategory));
                    continue;
                }
                StringBuilder levelAndCategoryStr = (StringBuilder)levelAndCategoryMap.get(levelCode);
                levelAndCategoryStr.append(",");
                levelAndCategoryStr.append(split[1]);
                levelAndCategoryMap.put(levelCode, levelAndCategoryStr);
            }
            if (MapUtils.isNotEmpty(levelAndCategoryMap)) {
                StringBuilder str = new StringBuilder();
                for (StringBuilder value : levelAndCategoryMap.values()) {
                    str.append((CharSequence)value);
                    str.append("/");
                }
                return str.toString();
            }
        }
        return null;
    }

    private ResponseParams<String> checkExcelName(String filename) {
        String[] split = filename.split("\\.");
        if (StringUtils.isBlank((CharSequence)split[1]) || !StringUtils.equalsIgnoreCase((CharSequence)split[1], (CharSequence)"xlsx")) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
        return null;
    }

    @RequestMapping(value={"importWordListToDb/v1"}, method={RequestMethod.POST})
    public ResponseParams<String> importWordListToDb(@RequestBody WordListImportReq req) {
        if (StringUtils.isBlank((CharSequence)req.getTempKey()) || StringUtils.isBlank((CharSequence)req.getUid())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        ArrayList categoryHasError = new ArrayList();
        ArrayList wordIllegal = new ArrayList();
        ArrayList categoryChanged = new ArrayList();
        ArrayList saveToDb = new ArrayList();
        ArrayList wordsCanInsert = new ArrayList();
        ResponseParams responseParams = this.strToList(req.getTempKey(), categoryHasError, categoryChanged, saveToDb, wordIllegal);
        if (Objects.nonNull(responseParams)) {
            return responseParams;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getCategoryChangedUpdate()) && StringUtils.equalsIgnoreCase((CharSequence)req.getCategoryChangedUpdate(), (CharSequence)Boolean.TRUE.toString())) {
            saveToDb.addAll(categoryChanged);
        }
        String url = this.buildExcel(categoryHasError, saveToDb, wordsCanInsert, wordIllegal);
        new Thread(() -> this.insertWords(wordsCanInsert, req.getUid())).start();
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)url);
    }

    private void insertWords(List<WordListImportDto> wordsCanInsert, String uid) {
        try {
            if (CollectionUtils.isNotEmpty(wordsCanInsert)) {
                ArrayList words = new ArrayList();
                List collect = wordsCanInsert.stream().filter(Objects::nonNull).map(WordListImportDto::getWord).collect(Collectors.toList());
                Set wordsExists = this.wordListMapper.getWordsExists(collect);
                List<Object> wordListImportTemp = new ArrayList<WordListImportDto>(wordsCanInsert);
                if (CollectionUtils.isNotEmpty((Collection)wordsExists)) {
                    wordListImportTemp = wordListImportTemp.stream().filter(Objects::nonNull).filter(e -> !wordsExists.contains(e.getWord())).collect(Collectors.toList());
                }
                wordListImportTemp.forEach(e -> {
                    WordList newWord = WordList.builder().word(e.getWord()).createBy(uid).status(DataStatusEnum.NORMAL.getCode()).createTime(new Date()).build();
                    GetEnToCnTranslateRequest getEnToCnTranslateRequest = new GetEnToCnTranslateRequest();
                    getEnToCnTranslateRequest.setWordText(e.getWord());
                    getEnToCnTranslateRequest.setAudioType(AudioTypeEnum.MP3);
                    ResponseParams translate = this.youdaoService.getEnToCnTranslate(getEnToCnTranslateRequest);
                    if (translate.getCode().equals(CommonRetCode.SUCCESS.getCode())) {
                        String explains = ((DictionaryDto)translate.getData()).getExplains();
                        if (StringUtils.isNotBlank((CharSequence)explains)) {
                            try {
                                explains = URLDecoder.decode(explains, "utf-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        newWord.setExplains(explains);
                    }
                    words.add(newWord);
                });
                if (CollectionUtils.isNotEmpty((Collection)wordsExists)) {
                    this.wordListMapper.updateStatusBatch((Collection)wordsExists, uid, DataStatusEnum.NORMAL.getCode());
                }
                if (CollectionUtils.isNotEmpty(words)) {
                    this.wordListMapper.insertBatch(words);
                }
                wordsCanInsert.forEach(e -> {
                    WordListReq req = new WordListReq();
                    req.setWord(e.getWord());
                    req.setUid(uid);
                    this.wordCategoryRelationMapper.updateStatusByWordAndRelationCodes(e.getWord(), uid, e.getRelationCodes());
                    WordCategoryRelationExample example = new WordCategoryRelationExample();
                    example.createCriteria().andWordEqualTo(e.getWord()).andStatusEqualTo(DataStatusEnum.NORMAL.getCode());
                    List wordCategoryRelationList = this.wordCategoryRelationMapper.selectByExample(example);
                    List<Object> relationCodes = new ArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)wordCategoryRelationList)) {
                        relationCodes = wordCategoryRelationList.stream().map(WordCategoryRelation::getRelationCode).collect(Collectors.toList());
                    }
                    if (CollectionUtils.isNotEmpty(relationCodes)) {
                        e.getRelationCodes().removeAll(relationCodes);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)e.getRelationCodes())) {
                        this.wordCategoryRelationMapper.insertBatch(req, e.getRelationCodes());
                    }
                    this.wordBookCodeRelationMapper.updateBatch(e.getWord(), e.getBookCodes());
                });
            }
        }
        catch (Exception e2) {
            log.error("Excel\u5bfc\u5165\u5355\u8bcd\uff0c\u5b58\u5165\u6570\u636e\u5e93\u65f6\u51fa\u9519 --->", (Throwable)e2);
        }
    }

    private String buildExcel(List<WordListImportDto> categoryHasError, List<WordListImportDto> saveToDb, List<WordListImportDto> wordsCanInsert, List<WordListImportDto> wordIllegal) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        this.generateSheetTitle(sheet);
        Set allBookCodes = this.baseBookMapper.getAllBookCodes();
        if (CollectionUtils.isNotEmpty(categoryHasError)) {
            this.buildCategoryHasError(categoryHasError, allBookCodes, sheet);
        }
        if (CollectionUtils.isNotEmpty(wordIllegal)) {
            this.buildWordIllegal(wordIllegal, allBookCodes, sheet);
        }
        if (CollectionUtils.isNotEmpty(saveToDb)) {
            this.checkBookCodesExists(saveToDb, allBookCodes, wordsCanInsert, sheet);
        }
        return this.uploadToAli((Workbook)workbook);
    }

    private void generateSheetTitle(XSSFSheet sheet) {
        XSSFRow xssfRow = sheet.createRow(0);
        xssfRow.createCell(0).setCellValue("\u586b\u5199\u8bf4\u660e:\u6b63\u5f0f\u5bfc\u5165\u524d,\u8bf7\u5220\u9664\u7ea2\u8272\u4f8b\u5b50\u884c,\u8bf7\u52ff\u5220\u9664\u672c\u884c\uff1b\n1.\u5355\u8bcd\u662f\u5fc5\u586b,\u652f\u6301\u82f1\u6587,\u652f\u6301\u505a\u591a15\u4e2a\u5b57\u6bcd\uff1b\n2.\u81f3\u5c11\u8981\u586b\u5199\u4e00\u4e2a\u7b49\u7ea7\u7c7b\u522b\uff1b\u82e5\u5b58\u5728\u591a\u4e2a\u7b49\u7ea7\u7c7b\u522b,\u53ef\u4ee5\u6309\u7167\u4f8b\u5b50\uff1b\n3.\u56fe\u7247\u3001BOOKID\u4e3a\u9009\u586b\u9879\uff1b\u56fe\u7247\u652f\u6301JPG\\PNG\u683c\u5f0f,\u5efa\u8bae\u5927\u5c0f:XX*XX\uff1b\n4.\u8bf7\u52ff\u5bf9\u8be5\u6587\u6863\u8fdb\u884c\u91cd\u547d\u540d\u4ee5\u53ca\u4efb\u4f55\u683c\u5f0f\u8c03\u6574");
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 6);
        sheet.addMergedRegion(cellRangeAddress);
        XSSFRow title = sheet.createRow(1);
        title.createCell(0).setCellValue("\u5355\u8bcd");
        title.createCell(1).setCellValue("\u7b49\u7ea7\u7c7b\u522b");
        title.createCell(2).setCellValue("\u6765\u6e90BookID1");
        title.createCell(3).setCellValue("\u6765\u6e90BookID2");
        title.createCell(4).setCellValue("\u6765\u6e90BookID3");
        title.createCell(5).setCellValue("\u6765\u6e90BookID4");
        title.createCell(6).setCellValue("\u6765\u6e90BookID5");
    }

    private void checkBookCodesExists(List<WordListImportDto> saveToDb, Set<String> allBookCodes, List<WordListImportDto> wordsCanInsert, XSSFSheet sheet) {
        Map allLevelAndCategoryRelation = this.getAllLevelAndCategoryRelation(saveToDb);
        for (WordListImportDto word : saveToDb) {
            List bookCodes = word.getBookCodes();
            if (CollectionUtils.isNotEmpty((Collection)bookCodes)) {
                if (bookCodes.stream().anyMatch(e -> !allBookCodes.contains(e))) {
                    XSSFRow xssfRow = sheet.createRow(sheet.getLastRowNum() + 1);
                    XSSFCell cell0 = xssfRow.createCell(0);
                    cell0.setCellValue(word.getWord());
                    XSSFCell cell1 = xssfRow.createCell(1);
                    List relationCodes = word.getRelationCodes();
                    ArrayList levelAndCategories = new ArrayList();
                    relationCodes.forEach(e -> {
                        if (StringUtils.isNotBlank((CharSequence)((CharSequence)allLevelAndCategoryRelation.get(e)))) {
                            levelAndCategories.add(allLevelAndCategoryRelation.get(e));
                        }
                    });
                    cell1.setCellValue(this.concatCategoryAndLevel(levelAndCategories));
                    this.checkAndSetBookCodesErrorStyle(bookCodes, xssfRow, allBookCodes);
                    continue;
                }
                wordsCanInsert.add(word);
                continue;
            }
            wordsCanInsert.add(word);
        }
    }

    private void buildCategoryHasError(List<WordListImportDto> categoryHasError, Set<String> allBookCodes, XSSFSheet sheet) {
        for (WordListImportDto word : categoryHasError) {
            XSSFRow xssfRow = sheet.createRow(sheet.getLastRowNum() + 1);
            XSSFCell cell0 = xssfRow.createCell(0);
            cell0.setCellValue(word.getWord());
            XSSFCell cell1 = xssfRow.createCell(1);
            cell1.setCellValue(word.getLevelAndCategory());
            cell1.setCellStyle(this.errorStyle(sheet.getWorkbook()));
            List bookCodes = word.getBookCodes();
            if (!CollectionUtils.isNotEmpty((Collection)bookCodes)) continue;
            this.checkAndSetBookCodesErrorStyle(bookCodes, xssfRow, allBookCodes);
        }
    }

    private void buildWordIllegal(List<WordListImportDto> wordIllegal, Set<String> allBookCodes, XSSFSheet sheet) {
        Map allLevelAndCategoryRelation = this.getAllLevelAndCategoryRelation(wordIllegal);
        for (WordListImportDto word : wordIllegal) {
            XSSFRow xssfRow = sheet.createRow(sheet.getLastRowNum() + 1);
            XSSFCell cell0 = xssfRow.createCell(0);
            cell0.setCellValue(word.getWord());
            cell0.setCellStyle(this.errorStyle(sheet.getWorkbook()));
            XSSFCell cell1 = xssfRow.createCell(1);
            List relationCodes = word.getRelationCodes();
            ArrayList levelAndCategories = new ArrayList();
            relationCodes.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)allLevelAndCategoryRelation.get(e)))) {
                    levelAndCategories.add(allLevelAndCategoryRelation.get(e));
                }
            });
            cell1.setCellValue(this.concatCategoryAndLevel(levelAndCategories));
            List bookCodes = word.getBookCodes();
            if (!CollectionUtils.isNotEmpty((Collection)bookCodes)) continue;
            this.checkAndSetBookCodesErrorStyle(bookCodes, xssfRow, allBookCodes);
        }
    }

    private Map<String, String> getAllLevelAndCategoryRelation(List<WordListImportDto> list) {
        HashSet allRelationCodes = new HashSet();
        list.stream().map(WordListImportDto::getRelationCodes).forEach(allRelationCodes::addAll);
        List allLevelAndCategoryRelationStr = this.categoryLevelRelationMapper.getLevelAndCategoryNameByCode(allRelationCodes);
        HashMap<String, String> allLevelAndCategoryRelation = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)allLevelAndCategoryRelationStr)) {
            allLevelAndCategoryRelationStr.forEach(e -> {
                String[] split = e.split(",");
                allLevelAndCategoryRelation.put(split[0], split[1]);
            });
        }
        return allLevelAndCategoryRelation;
    }

    private void checkAndSetBookCodesErrorStyle(List<String> bookCodes, XSSFRow xssfRow, Set<String> allBookCodes) {
        for (int j = 0; j < bookCodes.size(); ++j) {
            XSSFCell cell = xssfRow.createCell(j + 2);
            cell.setCellValue(bookCodes.get(j));
            if (allBookCodes.contains(bookCodes.get(j))) continue;
            cell.setCellStyle(this.errorStyle(xssfRow.getSheet().getWorkbook()));
        }
    }

    private CellStyle errorStyle(XSSFWorkbook workbook) {
        XSSFFont errorFont = workbook.createFont();
        errorFont.setColor((short)10);
        XSSFCellStyle errorStyle = workbook.createCellStyle();
        errorStyle.setFont((Font)errorFont);
        return errorStyle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadToAli(Workbook workbook) {
        if (workbook.getSheetAt(0).getLastRowNum() <= 1) return null;
        String path = "/data/tmp";
        String fileName = this.wordListConfigProperties.getExcelName() + ".xlsx";
        String filePath = path + fileName;
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            workbook.write((OutputStream)fos);
            String string = (String)this.ossService.uploadAndDelFileByName(filePath, fileName).getData();
            return string;
        }
        catch (IOException ioException) {
            log.error((Object)ioException);
        }
        return null;
    }

    private ResponseParams<String> strToList(String tempKey, List<WordListImportDto> categoryHasError, List<WordListImportDto> categoryChanged, List<WordListImportDto> saveToDb, List<WordListImportDto> wordIllegal) {
        String categoryHasErrorStr = this.redis.get("BOE:EN:LIST:ERROR:" + tempKey);
        String categoryChangedStr = this.redis.get("BOE:EN:LIST:CHANGED:" + tempKey);
        String saveToDbStr = this.redis.get("BOE:EN:LIST:SAVE:" + tempKey);
        String wordIllegalStr = this.redis.get("BOE:EN:LIST:ILLEGAL:" + tempKey);
        if (StringUtils.isBlank((CharSequence)categoryHasErrorStr) && StringUtils.isBlank((CharSequence)categoryChangedStr) && StringUtils.isBlank((CharSequence)saveToDbStr) && StringUtils.isBlank((CharSequence)wordIllegalStr)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null, (String)"\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20excel");
        }
        categoryHasError.addAll(this.parseStrToList(categoryHasErrorStr));
        categoryChanged.addAll(this.parseStrToList(categoryChangedStr));
        saveToDb.addAll(this.parseStrToList(saveToDbStr));
        wordIllegal.addAll(this.parseStrToList(wordIllegalStr));
        return null;
    }

    private List<WordListImportDto> parseStrToList(String str) {
        List list;
        ArrayList<WordListImportDto> wordListImportDtos = new ArrayList<WordListImportDto>();
        if (StringUtils.isNotBlank((CharSequence)str) && CollectionUtils.isNotEmpty((Collection)(list = (List)JSONObject.parseObject((String)str, List.class)))) {
            list.forEach(e -> {
                WordListImportDto wordListImportDto = (WordListImportDto)JSONObject.toJavaObject((JSON)e, WordListImportDto.class);
                wordListImportDtos.add(wordListImportDto);
            });
        }
        return wordListImportDtos;
    }
}

