/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.OrderUtil;
import com.ella.resource.api.MapService;
import com.ella.resource.constants.DataEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.Level;
import com.ella.resource.domain.Map;
import com.ella.resource.domain.MapResourceRel;
import com.ella.resource.domain.Mission;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.domain.ResourcePackage;
import com.ella.resource.domain.UserMap;
import com.ella.resource.dto.MapAndOrderDto;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.map.GetMapListRequest;
import com.ella.resource.dto.request.map.SaveMapRequest;
import com.ella.resource.dto.request.map.SetMapIcoRequest;
import com.ella.resource.dto.request.map.UpdateMapRequest;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.MissionMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.service.transactional.ResourcePackageTService;
import com.ella.resource.service.transactional.SysResourceOperateService;
import com.ella.resource.utils.MapUtils;
import com.ella.resource.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MapServiceImpl
implements MapService {
    private static final Logger log = LogManager.getLogger(MapServiceImpl.class);
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private MapTService mapTService;
    @Autowired
    private ResourcePackageTService packageTService;
    @Autowired
    private MissionMapper missionMapper;
    @Autowired
    private ResourceOccupantMapper resourceOccupantMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Autowired
    private SysResourceOperateService sysResourceOperateService;

    public ResponseParams<List<MapDto>> getMapList(@RequestBody GetMapListRequest request) {
        Map map = new Map();
        if (null != request) {
            BeanUtils.copyProperties((Object)request, (Object)map);
        }
        List mapDtoList = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getApplyType())) {
            java.util.Map queryMap = MapUtils.java2Map((Object)request);
            mapDtoList = this.mapMapper.selectUnusedMapList(queryMap);
        } else {
            mapDtoList = this.mapMapper.selectMapList(map);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)mapDtoList);
    }

    @EnableValidate
    public ResponseParams<MapDto> getMapInfo(@RequestBody GetMapInfoRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getId());
        MapDto result = new MapDto();
        if (null == map) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        BeanUtils.copyProperties((Object)map, (Object)result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<Integer> saveMap(@RequestBody SaveMapRequest request) {
        if (request.getLevelOrder() != null && request.getLevelOrder() <= 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Integer maxLevelOrder = this.mapMapper.selectMaxOrderByLevelCode(request.getLevelCode());
        if (request.getLevelOrder() == null) {
            request.setLevelOrder(Integer.valueOf(maxLevelOrder + 1));
        } else {
            int abs = request.getLevelOrder() - maxLevelOrder;
            if (abs > 1) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.MAP_INDEX_ERROR, null);
            }
            if (abs < 1) {
                this.mapTService.moveInsertMapIndex(request.getLevelCode(), request.getLevelOrder());
            }
        }
        Map map = new Map();
        map.setLevelCode(request.getLevelCode());
        map.setLevelOrder(request.getLevelOrder());
        map.setMapName(request.getMapName());
        map.setUnit(request.getUnit());
        map.setStatus("UNSURE");
        map.setMapCode(OrderUtil.createNo((String)"EM", (Integer)2));
        map.setCreateTime(new Date());
        map.setCreateBy(request.getUid());
        int result = this.mapTService.saveMap(map);
        this.mapTService.moveLexileMission(map.getMapCode());
        Level level = this.levelMapper.selectByCode(map.getLevelCode());
        Integer lastVersion = level.getVersion();
        this.mapTService.incrSysVersion(level);
        this.sysResourceOperateService.addSysResourceOperateLog(DataEnum.SYS_RESOURCE_TYPE.LEVEL.getValue(), DataEnum.SYS_RESOURCE_UPDATE_TYPE.MAP_RESOURCE_INSERT.getValue(), request.getLevelCode(), map.getMapCode(), request.getUid(), lastVersion, level.getVersion());
        this.autoResourcePackage(map);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @EnableValidate
    public ResponseParams<Boolean> updateMap(@RequestBody UpdateMapRequest request) {
        Map tmpMap = this.mapMapper.selectByPrimaryKey(request.getId());
        Map map = new Map();
        BeanUtils.copyProperties((Object)request, (Object)map);
        map.setUpdateBy(request.getUid());
        int result = this.mapTService.updateMap(map);
        this.mapTService.moveLexileMission(tmpMap.getMapCode());
        Level level = this.levelMapper.selectByCode(map.getLevelCode());
        this.mapTService.incrSysVersion(level);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> deleteMap(@RequestBody GetMapInfoRequest request) {
        Map map = this.mapMapper.selectByPrimaryKey(request.getId());
        RetCodeEnum errorEnum = this.checkMapStatus(map);
        if (null != errorEnum) {
            return ResponseParamUtils.build((RetCodeEnum)errorEnum);
        }
        map.setUpdateBy(request.getUid());
        this.updateResourceOccupant(map.getMapCode());
        this.mapTService.moveDelMapIndex(map.getLevelCode(), map.getLevelOrder());
        int result = this.mapTService.deleteMap(map);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> setMapIco(@RequestBody SetMapIcoRequest request) {
        int result = this.mapMapper.setMapIco(request.getId(), request.getIcoUrl(), null);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    @EnableValidate
    public ResponseParams<Boolean> setMapBottomUrl(@RequestBody SetMapIcoRequest request) {
        int result = this.mapMapper.setMapIco(request.getId(), null, request.getIcoUrl());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<List<MapAndOrderDto>> selectMapAndOrder() {
        List levelList = this.levelMapper.selectAll();
        if (levelList == null || levelList.size() == 0) {
            ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        ArrayList dataList = new ArrayList();
        levelList.forEach(level -> {
            Integer maxLevelOrder = this.mapMapper.selectMaxOrderByLevelCode(level.getLevelCode());
            MapAndOrderDto data = new MapAndOrderDto();
            data.setLevelCode(level.getLevelCode());
            data.setLevelOrder(maxLevelOrder);
            dataList.add(data);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, dataList);
    }

    private RetCodeEnum checkMapStatus(Map map) {
        if (null == map) {
            return RetCodeEnum.MAP_NOT_EXISTS;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"SURE", (CharSequence)map.getStatus())) {
            return RetCodeEnum.UNABLE_OPERATE_FOR_SURE;
        }
        return null;
    }

    private void autoResourcePackage(Map map) {
        ResourcePackage resourcePackage = new ResourcePackage();
        resourcePackage.setCode(OrderUtil.createNo((String)"ER", (Integer)2));
        resourcePackage.setCreateTime(new Date());
        resourcePackage.setName("DEFAULT");
        resourcePackage.setStatus("NORMAL");
        this.packageTService.saveResourcePackage(resourcePackage);
        MapResourceRel resourceRel = new MapResourceRel();
        resourceRel.setMapCode(map.getMapCode());
        resourceRel.setResourcePackageCode(resourcePackage.getCode());
        this.packageTService.saveMapResourceRel(resourceRel);
    }

    private void updateResourceOccupant(String mapCode) {
        log.info("method MapServiceImpl.updateResourceOccupant param:{}", (Object)mapCode);
        Mission param = new Mission();
        param.setMapCode(mapCode);
        List missions = this.missionMapper.selectMissionList(param);
        if (CollectionUtils.isEmpty((Collection)missions)) {
            return;
        }
        List ids = missions.stream().map(m -> (long)m.getId()).collect(Collectors.toList());
        ResourceOccupantExample occupantExample = new ResourceOccupantExample();
        occupantExample.createCriteria().andOccupantTypeEqualTo(DataEnum.RO_OccupantType.Occupant_MISSION.getType()).andOccupantIdIn(ids);
        this.resourceOccupantMapper.deleteByExample(occupantExample);
    }

    public String getNextMapId(String uid, String mapCode) {
        UserMap userMap = this.userMapMapper.selectByUidAndMapCode(uid, mapCode);
        String level = userMap.getLevelCode();
        String levelx = String.valueOf(Integer.parseInt(level) + 1);
        Long id = this.mapMapper.selectFirstMapIdByLevelCode(uid, levelx);
        if (id == null || id == 0L) {
            id = this.mapMapper.selectFirstMapidByLevelCode(levelx);
        }
        return id == null ? null : String.valueOf(id);
    }
}

