/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.LexileUtil;
import com.ella.resource.api.LevelService;
import com.ella.resource.api.LexileLevelHistoryService;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.LexileEvaluationStatusEnum;
import com.ella.resource.domain.Level;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.resource.domain.UserMap;
import com.ella.resource.domain.UserMission;
import com.ella.resource.dto.GetLevelInfoResponse;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelInfoDto;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileLevelHistoryDto;
import com.ella.resource.dto.StartLexileEvaluationRequest;
import com.ella.resource.dto.appdto.GetInitiativeInfoResponse;
import com.ella.resource.dto.request.lexile.LexileEvalutionHandOverRequest;
import com.ella.resource.dto.request.question.LexileAnswerResponse;
import com.ella.resource.dto.request.question.LexileEvaHistoryDetailDto;
import com.ella.resource.mapper.LevelMapper;
import com.ella.resource.mapper.LexileLevelHistoryMapper;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.QuestionLexileRecordMapper;
import com.ella.resource.mapper.UserMapMapper;
import com.ella.resource.mapper.UserMissionMapper;
import com.ella.resource.service.transactional.LexileEvaluationTService;
import com.ella.resource.service.transactional.LexileLevelHistoryTService;
import com.ella.resource.service.transactional.MapTService;
import com.ella.resource.utils.LexileR2bScoreUtil;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.AccountDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.account.EventTypeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LexileLevelHistoryServiceImpl
implements LexileLevelHistoryService {
    private static final Logger log = LogManager.getLogger(LexileLevelHistoryServiceImpl.class);
    @Autowired
    LexileR2bScoreUtil lexileScoreUtil;
    @Autowired
    LexileLevelHistoryMapper mapper;
    @Autowired
    LexileLevelHistoryTService lexileLevelHistoryTService;
    @Autowired
    QuestionLexileRecordMapper questionLexileRecordMapper;
    @Autowired
    LexileEvaluationTService lexileService;
    @Autowired
    LevelService levelService;
    @Autowired
    MapTService mapTService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private UserMissionMapper userMissionMapper;
    @Autowired
    private UserMapMapper userMapMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private LevelMapper levelMapper;
    @Value(value="${lexile.promotion.enableDays:60}")
    private Integer enableDays;

    public ResponseParams<LexileLevelHistoryDto> latestLexileHistory(@RequestParam(value="uid", required=true) String uid) {
        LexileLevelHistory history = this.mapper.findLatestHistoryForDisplay(uid);
        if (history == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        LexileLevelHistoryDto result = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)history, (Object)result);
        this.checkLexileLevelHistoryStatus(result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    @EnableValidate
    public ResponseParams<LexileLevelHistoryDto> createLexileHistory(@RequestBody StartLexileEvaluationRequest request) {
        log.info("createLexileHistory --- req :{}", (Object)request);
        LexileLevelHistoryDto historyDto = new LexileLevelHistoryDto();
        LexileLevelHistory history = null;
        LexileEvaluationDto evaluation = null;
        Date now = new Date();
        evaluation = this.lexileService.selectDetailById(request.getCurrentEvaluationId());
        if (evaluation == null) {
            log.error("Lexile evaluation [{}] not existed!", (Object)request.getCurrentEvaluationId());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        LevelEnum curLevel = LevelEnum.ofId((int)evaluation.getLevelId().intValue());
        if (evaluation.getStoneNum() > 0) {
            String relationId = LexileUtil.formartStoneOrderRelationId((String)curLevel.getCode());
            ResponseParams checkRes = this.userAccountService.checkStoneHasConsumed(request.getUid(), EventTypeEnum.LEXILE_TEST, relationId);
            if (!CommonRetCode.SUCCESS.equalTo(checkRes.getCode()) || !((Boolean)checkRes.getData()).booleanValue()) {
                return ResponseParams.build((String)checkRes.getCode(), (String)"\u5c1a\u672a\u89e3\u9501\uff01");
            }
        }
        String levelCode = curLevel.getCode();
        history = LexileLevelHistory.builder().uid(request.getUid()).evaluationId(Integer.valueOf(request.getCurrentEvaluationId().intValue())).age(request.getAge()).levelCode(levelCode).originLevelCode(levelCode).testNum(Integer.valueOf(evaluation.getQuestionDtoList().size())).correctNum(Integer.valueOf(0)).status(LexileEvaluationStatusEnum.UNDERWAY.getCode()).lexileLevel("").promotion(Boolean.FALSE).startTime(now).createTime(now).remark(levelCode).build();
        int insertRows = this.mapper.insertSelective(history);
        if (insertRows < 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
        }
        history = this.mapper.findLatestHistory(request.getUid());
        this.lexileLevelHistoryTService.updateUserLexileLevelHistoryStatus(history.getUid(), history.getId(), LexileEvaluationStatusEnum.UNDERWAY.getCode(), LexileEvaluationStatusEnum.UNCOMPLETED.getCode());
        BeanUtils.copyProperties((Object)history, (Object)historyDto);
        historyDto.setEvaluation(evaluation);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)historyDto);
    }

    private void checkLexileLevelHistoryStatus(LexileLevelHistoryDto historyDto) {
        LexileLevelHistory his;
        int affectRow;
        Date deadLine = DateUtils.addHours((Date)new Date(), (int)-1);
        if (LexileEvaluationStatusEnum.UNDERWAY.equalTo(historyDto.getStatus()) && historyDto.getStartTime().before(deadLine) && (affectRow = this.mapper.updateByPrimaryKeySelective(his = LexileLevelHistory.builder().id(historyDto.getId()).status(LexileEvaluationStatusEnum.UNCOMPLETED.getCode()).build())) > 0) {
            historyDto.setStatus(LexileEvaluationStatusEnum.UNCOMPLETED.getCode());
        }
    }

    @EnableValidate
    public ResponseParams<LexileAnswerResponse> handover(@RequestBody LexileEvalutionHandOverRequest request) {
        ResponseParams respResult = null;
        try {
            LexileAnswerResponse result = null;
            result = this.lexileLevelHistoryTService.handover(request);
            respResult = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        catch (EllaEnglishException e) {
            respResult = new ResponseParams(e.getCode(), e.getMessage());
            log.error("Lexile evaluation user handover biz error [{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            respResult = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
            log.error("Lexile evaluation user handover sys error [{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
        return respResult;
    }

    public ResponseParams<List<Map<String, Object>>> wrongAnswerMissonInfoByHistoryId(@RequestParam(value="historyId", required=true) int historyId) {
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.mapper.selectWrongAnswerMissionInfoByHistoryId(Integer.valueOf(historyId)));
    }

    public ResponseParams<GetInitiativeInfoResponse> getInitiativeInfo(@RequestParam String uid) {
        LexileLevelHistory history = this.mapper.findLatestHistoryForDisplay(uid);
        GetInitiativeInfoResponse response = new GetInitiativeInfoResponse();
        if (history == null) {
            response.setLastTestTime("-");
            response.setEnableTime("-");
            response.setIsEnable(Boolean.valueOf(true));
        } else {
            Date lastTime = history.getEndTime();
            Date enableTime = DateUtil.plusDay((int)this.enableDays, (Date)lastTime);
            response.setLastTestTime(DateUtil.dateToString((Date)history.getEndTime(), (String)DateUtil.DEFAULT_DATE_FORMAT));
            response.setEnableTime(DateUtil.dateToString((Date)enableTime, (String)DateUtil.DEFAULT_DATE_FORMAT));
            response.setIsEnable(Boolean.valueOf(this.judgeEnableTest(uid, lastTime, enableTime)));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)response);
    }

    public ResponseParams<GetLevelInfoResponse> getLevelInfo(@RequestParam String uid) {
        GetLevelInfoResponse response = new GetLevelInfoResponse();
        ResponseParams responseParams = this.userInfoService.selectUserByUid(uid);
        String levelCode = null;
        if (responseParams != null && CommonRetCode.SUCCESS.getCode().equals(responseParams.getCode())) {
            UserInfoDto userInfoDto = (UserInfoDto)responseParams.getData();
            levelCode = this.levelService.transferLexileLevel(userInfoDto.getLexileLevel());
            response.setLevelLexile(userInfoDto.getLexileLevel());
            response.setLevelCode(levelCode);
        }
        response.setLevelInfoDto(this.getAllLevelInfo(levelCode));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)response);
    }

    public ResponseParams<LexileLevelHistory> getHistoryInfo(String uid) {
        LexileLevelHistory history = this.mapper.selectMaxScoreHistoryByUid(uid);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)history);
    }

    private List<LevelInfoDto> getAllLevelInfo(String levelCode) {
        ArrayList<LevelInfoDto> result = new ArrayList<LevelInfoDto>();
        List<Level> levels = this.levelMapper.listAllEnableLevels();
        if (!CollectionUtils.isEmpty(levels = levels.stream().filter(level -> !"0".equals(level.getLevelCode())).collect(Collectors.toList()))) {
            String finalLevelCode = levelCode;
            levels.forEach(l -> {
                LevelInfoDto ld = new LevelInfoDto();
                if (l.getReadStartIndex() != null && l.getReadStartIndex() < 0) {
                    ld.setReadStartIndex("BR" + l.getReadStartIndex() * -1 + "L");
                } else {
                    ld.setReadStartIndex(String.valueOf(l.getReadStartIndex()) + "L");
                }
                if (l.getReadEndIndex() != null && l.getReadEndIndex() < 0) {
                    ld.setReadEndIndex("BR" + l.getReadEndIndex() * -1 + "L");
                } else {
                    ld.setReadEndIndex(String.valueOf(l.getReadEndIndex()) + "L");
                }
                ld.setLevelAbilityDesc(l.getLevelAbilityDesc());
                if (l.getLevelCode().equals(finalLevelCode)) {
                    ld.setEnable(Boolean.valueOf(true));
                }
                ld.setLevel("level" + l.getLevelCode());
                result.add(ld);
            });
        }
        return result;
    }

    private boolean judgeEnableTest(String uid, Date lastTime, Date enableTime) {
        Date now = new Date();
        long abs = enableTime.getTime() - now.getTime();
        return abs <= 0L;
    }

    public ResponseParams<LexileEvaHistoryDetailDto> historyDetail(@RequestParam(value="historyId", required=true) Integer historyId, @RequestParam(value="uid", required=true) String uid) {
        LexileEvaHistoryDetailDto result = null;
        LexileLevelHistory history = this.mapper.selectByPrimaryKey(historyId);
        if (Objects.isNull(history)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, result);
        }
        if (!Objects.equals(history.getUid(), uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, result);
        }
        result = this.handleHistoryDetail(history);
        ResponseParams responseParams = this.userInfoService.getUserAccountInfo(uid);
        if (responseParams != null && CommonRetCode.isSuccess((String)responseParams.getCode())) {
            result.setStoneNum(((AccountDto)responseParams.getData()).getStoneNum());
        }
        String maxLevelCode = this.mapMapper.selectMaxLevelCode();
        if (history.getLevelCode().compareTo(maxLevelCode) > 0) {
            result.setLevelOverFlow(Boolean.valueOf(true));
        }
        result.setLevelAllInfo(this.getAllLevelInfo(null));
        Date lastTime = history.getEndTime();
        Date enableTime = DateUtil.plusDay((int)this.enableDays, (Date)lastTime);
        result.setLastTestTime(DateUtil.dateToString((Date)history.getEndTime(), (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setEnableTime(DateUtil.dateToString((Date)enableTime, (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setIsEnable(Boolean.valueOf(this.judgeEnableTest(uid, lastTime, enableTime)));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByLevelCode(@RequestParam(value="levelCode", required=true) String levelCode, @RequestParam(value="uid", required=true) String uid) {
        LexileEvaHistoryDetailDto result = null;
        LexileLevelHistory history = this.mapper.selectMaxScoreHistoryByLevelcodeAndUid(uid, levelCode);
        if (Objects.isNull(history)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, result);
        }
        if (!Objects.equals(history.getUid(), uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, result);
        }
        result = this.handleHistoryDetail(history);
        String maxLevelCode = this.mapMapper.selectMaxLevelCode();
        if (history.getLevelCode().compareTo(maxLevelCode) > 0) {
            result.setLevelOverFlow(Boolean.valueOf(true));
        }
        result.setLevelAllInfo(this.getAllLevelInfo(null));
        Date lastTime = history.getEndTime();
        LexileLevelHistory historyx = this.mapper.findLatestHistoryForDisplay(uid);
        if (historyx != null) {
            lastTime = historyx.getEndTime();
        }
        Date enableTime = DateUtil.plusDay((int)this.enableDays, (Date)lastTime);
        result.setLastTestTime(DateUtil.dateToString((Date)lastTime, (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setEnableTime(DateUtil.dateToString((Date)enableTime, (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setIsEnable(Boolean.valueOf(this.judgeEnableTest(uid, lastTime, enableTime)));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private LexileEvaHistoryDetailDto handleHistoryDetail(LexileLevelHistory history) {
        LexileLevelHistoryDto hd = null;
        LevelDto levelDto = null;
        LexileEvaHistoryDetailDto result = new LexileEvaHistoryDetailDto();
        hd = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)history, (Object)hd);
        ResponseParams lsRes = this.levelService.getLevelByCode(history.getLevelCode());
        if (CommonRetCode.isSuccess((String)lsRes.getCode())) {
            levelDto = (LevelDto)lsRes.getData();
        }
        String uid = history.getUid();
        List missionInfo = this.mapper.selectWrongAnswerMissionInfoByHistoryId(history.getId());
        if (missionInfo != null) {
            missionInfo.forEach(item -> {
                String missionCode;
                UserMission userMission;
                String mapCode = (String)item.get("mapCode");
                UserMap userMap = this.userMapMapper.selectByUidAndMapCode(uid, mapCode);
                if (userMap != null) {
                    item.put("mapId", userMap.getId());
                }
                if ((userMission = this.userMissionMapper.selectByUidAndMissionCode(uid, missionCode = (String)item.get("missionCode"))) != null) {
                    item.put("missionId", userMission.getId());
                }
            });
        }
        Long mapId = this.mapTService.getFirstMapIdByLevelCode(history.getUid(), history.getLevelCode());
        result.setHistory(hd);
        result.setPromotion(hd.getPromotion());
        result.setLevelInfo(levelDto);
        result.setMissionInfo(missionInfo);
        result.setMapId(String.valueOf(mapId));
        return result;
    }

    public ResponseParams<LexileLevelHistoryDto> maxScoreHistoryByOriginLevelCode(@RequestParam(value="levelCode", required=true) String levelCode, @RequestParam(value="uid", required=true) String uid) {
        LexileLevelHistoryDto result = null;
        LexileLevelHistory history = this.mapper.selectMaxScoreHistoryByOriginLevelcodeAndUid(uid, levelCode);
        if (Objects.isNull(history) || !LexileEvaluationStatusEnum.COMPLETED.getCode().equals(history.getStatus()) || !history.getPromotion().booleanValue()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, result);
        }
        result = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)history, (Object)result);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByOriginLevelCode(@RequestParam(value="levelCode", required=true) String levelCode, @RequestParam(value="uid", required=true) String uid) {
        LexileEvaHistoryDetailDto result = null;
        LexileLevelHistory history = this.mapper.selectMaxScoreHistoryByOriginLevelcodeAndUid(uid, levelCode);
        if (Objects.isNull(history)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, result);
        }
        if (!Objects.equals(history.getUid(), uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, result);
        }
        result = this.handleHistoryDetail(history);
        Date lastTime = history.getEndTime();
        Date enableTime = DateUtil.plusDay((int)this.enableDays, (Date)lastTime);
        result.setLastTestTime(DateUtil.dateToString((Date)history.getEndTime(), (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setEnableTime(DateUtil.dateToString((Date)enableTime, (String)DateUtil.DEFAULT_DATE_FORMAT));
        result.setIsEnable(Boolean.valueOf(this.judgeEnableTest(uid, lastTime, enableTime)));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }
}

