/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LexileEvaluationService;
import com.ella.resource.domain.LexileEvaluation;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileEvaluationListDto;
import com.ella.resource.dto.LexileEvaluationPageDto;
import com.ella.resource.dto.LexileEvaluationQuestionDto;
import com.ella.resource.dto.request.lexile.DeleteLexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.EditLexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.EditLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.FindLexileQuestionItemRequest;
import com.ella.resource.dto.request.lexile.LexileEvaluationQuestionRequest;
import com.ella.resource.dto.request.lexile.ModifyLexileEvaluationInfRequest;
import com.ella.resource.dto.request.lexile.SaveLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.SelectOneLexileQuestionsRequest;
import com.ella.resource.mapper.LexileEvaluationMapper;
import com.ella.resource.service.transactional.LexileEvaluationTService;
import com.ella.resource.utils.ResponseParamUtils;
import com.ella.resource.utils.ValidationUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class LexileEvaluationServiceImpl
implements LexileEvaluationService {
    private static final Logger log = LogManager.getLogger(LexileEvaluationServiceImpl.class);
    @Autowired
    LexileEvaluationTService lexileService;
    @Autowired
    private LexileEvaluationMapper lexileEvalMapper;

    public ResponseParams<Boolean> saveLexileEvaluation(@RequestBody SaveLexileEvaluationRequest request) {
        log.info("\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b\u57fa\u672c\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("saveLexileEvaluation param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.lexileService.addLexileEvaluation(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<List<LexileEvaluationListDto>> getAllLexileInfo() {
        log.info("\u83b7\u53d6\u84dd\u601d\u8bc4\u6d4b\u5217\u8868");
        List result = this.lexileService.getAllLexileEvaluation();
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> saveLexiLeEvaluationDetail(@RequestBody LexileEvaluationQuestionRequest request) {
        log.info("\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("saveLexiLeEvaluationDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.lexileService.saveLexiLeEvaluationDetail(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> updateLexiLeEvaluationProperty(@RequestBody EditLexileEvaluationRequest request) {
        log.info("\u7f16\u8f91\u84dd\u601d\u8bc4\u6d4b\u5c5e\u6027\u503c\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("updateLexiLeEvaluationProperty param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.lexileService.updateLexiLeEvaluationProperty(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> editLexiLeEvaluationDetail(@RequestBody EditLexileEvaluationQuestionRequest request) {
        log.info("\u7f16\u8f91\u84dd\u601d\u9898\u76ee\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("editLexiLeEvaluationDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.lexileService.editLexiLeEvaluationDetail(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<Boolean> deleteLexiLeEvaluationDetail(@RequestBody DeleteLexileEvaluationQuestionRequest request) {
        log.info("\u5220\u9664\u84dd\u601d\u9898\u76ee\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("deleteLexiLeEvaluationDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int result = this.lexileService.deleteLexiLeEvaluationDetail(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<LexileEvaluationQuestionDto> queryLexiLeEvaluationDetail(@RequestBody FindLexileQuestionItemRequest request) {
        log.info("\u67e5\u8be2\u5355\u4e2a\u84dd\u601d\u9898\u76ee\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("deleteLexiLeEvaluationDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LexileEvaluationQuestionDto result = this.lexileService.queryLexiLeEvaluationDetail(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> importLexileEvaluation(@RequestParam(value="file") MultipartFile file, @RequestParam(value="evaluationId") String evaluationId) {
        int result = this.lexileService.importLexileEvaluation(file, evaluationId);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams<LexileEvaluationPageDto> getOneLexileQuestions(@RequestBody SelectOneLexileQuestionsRequest request) {
        log.info("\u67e5\u770b\u8bc4\u6d4b\u9898\u76ee\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getOneLexileQuestions param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LexileEvaluationPageDto result = this.lexileService.getOneLexileQuestions(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LexileEvaluationDto> getEvaluationByLevelCode(@RequestParam(value="levelCode", required=true) String levelCode) {
        LexileEvaluationDto eva = this.lexileService.selectByLevelCode(levelCode);
        return ResponseParamUtils.build((CommonRetCode)(eva == null ? CommonRetCode.DATA_NOT_EXISTED : CommonRetCode.SUCCESS), (Object)eva);
    }

    public ResponseParams<Integer> countEvaluationQuestiones(@RequestParam(value="evaluationId", required=true) Long evaluationId) {
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.lexileService.countEvaluationQuestiones(evaluationId));
    }

    public ResponseParams<LexileEvaluationDto> getEvaluationDetailById(@RequestParam(value="id", required=true) Long id) {
        LexileEvaluationDto eva = this.lexileService.selectDetailById(id);
        return ResponseParamUtils.build((CommonRetCode)(eva == null ? CommonRetCode.DATA_NOT_EXISTED : CommonRetCode.SUCCESS), (Object)eva);
    }

    public ResponseParams<LexileEvaluationDto> getEvaluationDetailByLevelCode(@RequestParam(value="levelCode", required=true) String levelCode) {
        LexileEvaluationDto eva = this.lexileService.selectDetailByLevelCode(levelCode);
        return ResponseParamUtils.build((CommonRetCode)(eva == null ? CommonRetCode.DATA_NOT_EXISTED : CommonRetCode.SUCCESS), (Object)eva);
    }

    public ResponseParams<LexileEvaluationQuestionDto> getQuestionDetail(@RequestParam(value="questionId", required=true) Long questionId) {
        LexileEvaluationQuestionDto result = this.lexileService.getQuestionDetail(questionId);
        return ResponseParamUtils.build((CommonRetCode)(result == null ? CommonRetCode.DATA_NOT_EXISTED : CommonRetCode.SUCCESS), (Object)result);
    }

    public ResponseParams<LexileEvaluationDto> getEvaluationById(@RequestParam(value="id", required=true) Long id) {
        LexileEvaluationDto eva = this.lexileService.selectById(id);
        return ResponseParamUtils.build((CommonRetCode)(Objects.nonNull(eva) ? CommonRetCode.SUCCESS : CommonRetCode.DATA_NOT_EXISTED), (Object)eva);
    }

    @EnableValidate
    public ResponseParams<Boolean> modifyLexileEvaluationInf(@RequestBody ModifyLexileEvaluationInfRequest req) {
        log.info("modifyLexileEvaluationInf --- req :{}", (Object)req);
        LexileEvaluation eval = new LexileEvaluation();
        BeanUtils.copyProperties((Object)req, (Object)eval);
        int count = this.lexileEvalMapper.updateByPrimaryKeySelective(eval);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)(count > 0 ? 1 : 0));
    }
}

