/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.domain.IraReadReport;
import com.ella.resource.domain.IraReadReportExample;
import com.ella.resource.dto.IraReportDto;
import com.ella.resource.dto.IraSecondAbilityTotalDto;
import com.ella.resource.mapper.IraReadReportMapper;
import com.ella.resource.mapper.UserCourseMapper;
import com.ella.resource.mapper.UserMapper;
import com.ella.resource.service.transactional.GenerateReadReportService;
import com.ella.resource.service.transactional.IraReadReportTService;
import com.ella.resource.utils.ResponseParamUtils;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GenerateReadReportServiceImpl
implements GenerateReadReportService {
    private static final Logger log = LoggerFactory.getLogger(GenerateReadReportServiceImpl.class);
    @Autowired
    private IraReadReportTService iraReadReportTService;
    @Autowired
    private IraReadReportMapper iraReadReportMapper;
    @Autowired
    private UserCourseMapper userCourseMapper;
    @Autowired
    private DistributedCache redis;
    @Autowired
    private UserMapper userMapper;

    public void generateFunbookReadReport() {
        log.info("--------------------\u5f00\u59cb\u751f\u6210IRA\u9605\u8bfb\u62a5\u544a------------------------------");
        int pageNum = 1;
        Map secondAbilityTotalMap = this.getSecondAbilityTotalMap();
        while (true) {
            PageHelper.startPage((int)pageNum, (int)200);
            List childrenUidList = this.userCourseMapper.getChildrenUidList();
            if (CollectionUtils.isEmpty((Collection)childrenUidList)) {
                return;
            }
            boolean lock = this.redis.setExpireNX("BOE:EN:IRA:LOCK_KEY:" + childrenUidList, 30, "true");
            if (lock) {
                for (String uid : childrenUidList) {
                    this.generateOneReport(uid, secondAbilityTotalMap);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)childrenUidList) && childrenUidList.size() < 200) {
                return;
            }
            ++pageNum;
        }
    }

    private Map<String, List<IraSecondAbilityTotalDto>> getSecondAbilityTotalMap() {
        HashMap<String, List<IraSecondAbilityTotalDto>> secondAbilityTotalMap = new HashMap<String, List<IraSecondAbilityTotalDto>>();
        List mapCodeList = this.iraReadReportTService.listMapCode();
        if (CollectionUtils.isNotEmpty((Collection)mapCodeList)) {
            for (String mapCode : mapCodeList) {
                if (!StringUtils.isNotBlank((CharSequence)mapCode)) continue;
                List secondTotalList = this.iraReadReportTService.listSecondAbilityTotal(mapCode);
                secondAbilityTotalMap.put(mapCode, secondTotalList);
            }
        }
        return secondAbilityTotalMap;
    }

    public ResponseParams<Boolean> generateOneReport(String uid, Map<String, List<IraSecondAbilityTotalDto>> secondAbilityTotalMap) {
        if (MapUtils.isEmpty(secondAbilityTotalMap)) {
            secondAbilityTotalMap = this.getSecondAbilityTotalMap();
        }
        try {
            log.info("--------------------\u5f00\u59cb\u751f\u6210\u7528\u6237\u3010 " + uid + " \u3011\u7684IRA\u9605\u8bfb\u62a5\u544a---------------------");
            ArrayList<IraReportDto> iraReadReportSaveList = new ArrayList<IraReportDto>();
            ArrayList<IraReportDto> iraReadReportUpdateList = new ArrayList<IraReportDto>();
            List iraReadReportList = this.iraReadReportTService.generateReadVolumeReport(uid);
            if (CollectionUtils.isEmpty((Collection)iraReadReportList)) {
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
            }
            this.iraReadReportTService.generateFirstAbilities(iraReadReportList, secondAbilityTotalMap);
            IraReadReportExample iraReadReportExample = new IraReadReportExample();
            iraReadReportExample.createCriteria().andUidEqualTo(uid);
            List readReportListGenerated = this.iraReadReportMapper.selectByExample(iraReadReportExample);
            if (CollectionUtils.isEmpty((Collection)readReportListGenerated)) {
                this.iraReadReportTService.saveReport(iraReadReportList);
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
            }
            Map<String, String> mapReportCodeMap = readReportListGenerated.stream().collect(Collectors.toMap(IraReadReport::getMapCode, IraReadReport::getReportCode));
            for (IraReportDto e : iraReadReportList) {
                if (StringUtils.isBlank((CharSequence)mapReportCodeMap.get(e.getMapCode()))) {
                    iraReadReportSaveList.add(e);
                    continue;
                }
                iraReadReportUpdateList.add(e);
            }
            this.iraReadReportTService.saveReport(iraReadReportSaveList);
            this.iraReadReportTService.updateReport(iraReadReportUpdateList);
            log.info("--------------------\u751f\u6210\u7528\u6237\u3010 " + uid + " \u3011\u7684IRA\u9605\u8bfb\u62a5\u544a\u5b8c\u6210---------------------");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        catch (Exception e) {
            log.error("--------\u751f\u6210\u7528\u6237\u3010 " + uid + " \u3011\u7684IRA\u9605\u8bfb\u62a5\u544a\u5f02\u5e38\uff1a", (Throwable)e);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)false);
        }
    }
}

