/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.OrderUtil;
import com.ella.resource.api.CourseService;
import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.constants.LexileResTypeEnum;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.domain.BaseBook;
import com.ella.resource.domain.BaseBookExample;
import com.ella.resource.domain.CouresQuestion;
import com.ella.resource.domain.CouresQuestionExample;
import com.ella.resource.domain.CourseBook;
import com.ella.resource.domain.CourseBookExample;
import com.ella.resource.domain.LexileResTypeRel;
import com.ella.resource.domain.PictureBookExample;
import com.ella.resource.domain.ResQuestion;
import com.ella.resource.domain.ResourceOccupant;
import com.ella.resource.domain.ResourceOccupantExample;
import com.ella.resource.dto.CourseListDto;
import com.ella.resource.dto.CourseQuestionListDto;
import com.ella.resource.dto.request.AddCourseQestionRes;
import com.ella.resource.dto.request.BaseBookListRes;
import com.ella.resource.dto.request.ChangeCourseQuestionIndexRes;
import com.ella.resource.dto.request.CourseQuestionListReq;
import com.ella.resource.dto.request.CourseRequest;
import com.ella.resource.dto.request.CourseVedioReq;
import com.ella.resource.dto.request.GetCourseInfoReq;
import com.ella.resource.mapper.BaseBookMapper;
import com.ella.resource.mapper.CouresQuestionMapper;
import com.ella.resource.mapper.CourseBookMapper;
import com.ella.resource.mapper.LexileResTypeMapper;
import com.ella.resource.mapper.PictureBookMapper;
import com.ella.resource.mapper.ResQuestionMapper;
import com.ella.resource.mapper.ResourceOccupantMapper;
import com.ella.resource.utils.Putil;
import com.ella.resource.utils.RedisAssistUtils;
import com.ella.resource.utils.ResponseParamUtils;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CourseServiceImpl
implements CourseService {
    private static final Logger log = LogManager.getLogger(CourseServiceImpl.class);
    @Autowired
    private DistributedCache redis;
    @Autowired
    private CourseBookMapper courseBookMapper;
    @Autowired
    private BaseBookMapper baseBookMapper;
    @Autowired
    private CouresQuestionMapper couresQuestionMapper;
    @Autowired
    private ResQuestionMapper resQuestionMapper;
    @Autowired
    private ResourceOccupantMapper resourceOccupantMapper;
    @Autowired
    private PictureBookMapper pictureBookMapper;
    @Autowired
    private LexileResTypeMapper lexileResTypeMapper;
    @Autowired
    private LexileResTypeService lexileResTypeService;

    public ResponseParams selectBookList(@RequestBody BaseBookListRes res) {
        log.info("\u8bfe\u7a0b/\u7ed8\u672c \u9009\u53d6\u52a8\u753b\u4e66\u63a5\u53e3--{}", (Object)res);
        PageHelper.startPage((int)res.getPageNo(), (int)res.getPageSize());
        List baseBooks = this.resourceOccupantMapper.selectBookList(res.getType(), res.getName());
        baseBooks.stream().forEach(baseBook -> {
            Integer cardinal = Optional.ofNullable(new RedisAssistUtils(this.redis).getIntByKey("COURSE_STONE_CARDINAL")).orElse(3);
            int questionNumber = baseBook.getQuestionNumber();
            int stoneNum = cardinal * questionNumber;
            baseBook.setStoneNum(Integer.valueOf(stoneNum));
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Putil.build((List)baseBooks));
    }

    @EnableValidate
    public ResponseParams getCourseInfo(@RequestBody GetCourseInfoReq req) {
        log.info("call [GetCourseInfoReq] request---> {}", (Object)JSONObject.toJSONString((Object)req));
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(req.getId());
        LexileResTypeRel lexileResTypeRel = this.lexileResTypeMapper.selectByResCode(courseBook.getCourseCode());
        if (lexileResTypeRel != null) {
            courseBook.setLexileResTypeCode(lexileResTypeRel.getLexileResTypeCode());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)courseBook);
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams addCourseVedio(@RequestBody CourseVedioReq req) {
        log.info("\u8bfe\u7a0b\u5217\u8868\u6dfb\u52a0\u89c6\u9891-----> {}", (Object)JSONObject.toJSONString((Object)req));
        CourseBookExample courseBookExample = new CourseBookExample();
        courseBookExample.createCriteria().andCourseCodeEqualTo(req.getCourseCode()).andStatusEqualTo("NORMAL");
        List courseBooks = this.courseBookMapper.selectByExample(courseBookExample);
        if (!CollectionUtils.isEmpty((Collection)courseBooks)) {
            ((CourseBook)courseBooks.get(0)).setVideoUrl(req.getVideoUrl());
            this.courseBookMapper.updateByPrimaryKey((CourseBook)courseBooks.get(0));
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        return ResponseParams.build((String)CommonRetCode.DATA_NOT_EXISTED.getCode(), (String)CommonRetCode.DATA_NOT_EXISTED.getMsg());
    }

    public ResponseParams courseList(@RequestBody CourseRequest request) {
        log.info("\u8bfe\u7a0b\u5217\u8868--\u5206\u9875-----> {}", (Object)JSONObject.toJSONString((Object)request));
        CourseBookExample courseBookExample = new CourseBookExample();
        courseBookExample.setOrderByClause("update_time desc");
        courseBookExample.createCriteria().andStatusEqualTo("NORMAL");
        if (StringUtils.isNotEmpty((String)request.getName())) {
            courseBookExample.clear();
            courseBookExample.createCriteria().andStatusEqualTo("NORMAL").andCourseNameLike(request.getName());
            courseBookExample.or().andSeriesNameLike(request.getName()).andStatusEqualTo("NORMAL");
        }
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List courseBooks = this.courseBookMapper.selectByExample(courseBookExample);
        courseBooks.stream().forEach(item -> {
            ResourceOccupantExample example = new ResourceOccupantExample();
            example.createCriteria().andResIdEqualTo(Long.valueOf(item.getId().intValue())).andStatusEqualTo("NORMAL").andResTypeEqualTo("COURSE");
            List resourceOccupants = this.resourceOccupantMapper.selectByExample(example);
            if (!CollectionUtils.isEmpty((Collection)resourceOccupants)) {
                item.setUseStatus("Y");
            } else {
                item.setUseStatus("N");
            }
            item.setLexileLevel(this.lexileResTypeService.getLexileLevelCode(item.getCourseCode(), item.getLexileLevel()));
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Putil.build((List)courseBooks));
    }

    public ResponseParams addCourse(@RequestBody CourseListDto dto) {
        log.info("\u8bfe\u7a0b\u65b0\u589e----> {}", (Object)JSONObject.toJSONString((Object)dto));
        PictureBookExample pictureBookExample = new PictureBookExample();
        pictureBookExample.createCriteria().andPicBookCodeEqualTo(dto.getBookCode()).andStatusEqualTo("NORMAL");
        List pictureBooks = this.pictureBookMapper.selectByExample(pictureBookExample);
        if (!CollectionUtils.isEmpty((Collection)pictureBooks)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.EXISTS_IN_PICTURE_BOOK);
        }
        if (StringUtils.isBlank((String)dto.getBookCode()) || StringUtils.isBlank((String)dto.getBookName())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.INCOMPLETE_PARAMETERS_ERROR);
        }
        CourseBook courseBook = new CourseBook();
        BeanUtils.copyProperties((Object)dto, (Object)courseBook);
        String kc = OrderUtil.createNo((String)"KC", (Integer)1);
        courseBook.setCourseCode(kc);
        courseBook.setCreateTime(new Date());
        this.updateCourseNameAndBookCode(dto, courseBook);
        courseBook.setStatus("NORMAL");
        Integer cardinal = Optional.ofNullable(new RedisAssistUtils(this.redis).getIntByKey("COURSE_STONE_CARDINAL")).orElse(3);
        BaseBook baseBook = this.baseBookMapper.selectByBookCode(courseBook.getBookCode());
        int questionNumber = baseBook.getQuestionNumber();
        int stoneNum = cardinal * questionNumber;
        courseBook.setTestNum(Integer.valueOf(stoneNum));
        this.courseBookMapper.insertSelective(courseBook);
        ResourceOccupant occupant = new ResourceOccupant();
        occupant.setResCode(dto.getBookCode());
        occupant.setResType("BOOK");
        occupant.setOccupantType("COURSE");
        occupant.setOccupantId(Long.valueOf(courseBook.getId().intValue()));
        occupant.setCreateTime(new Date());
        occupant.setStatus("NORMAL");
        this.resourceOccupantMapper.insertSelective(occupant);
        if (dto.getLexileResTypeCode() != null && !dto.getLexileResTypeCode().equals("")) {
            LexileResTypeRel record = LexileResTypeRel.builder().lexileResTypeCode(dto.getLexileResTypeCode()).resType("COURSE").resCode(courseBook.getCourseCode()).build();
            this.lexileResTypeMapper.insertSelective(record);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    private void updateCourseNameAndBookCode(CourseListDto dto, CourseBook courseBook) {
        if (dto.getBookCode() == null) {
            CourseBook courseBookPo = this.courseBookMapper.selectByPrimaryKey(dto.getId());
            dto.setBookCode(courseBookPo.getBookCode());
        }
        BaseBookExample baseBookExample = new BaseBookExample();
        baseBookExample.createCriteria().andBookCodeEqualTo(dto.getBookCode());
        List baseBooks = this.baseBookMapper.selectByExample(baseBookExample);
        if (!CollectionUtils.isEmpty((Collection)baseBooks)) {
            courseBook.setCourseName(((BaseBook)baseBooks.get(0)).getBookName());
            courseBook.setSeriesName(((BaseBook)baseBooks.get(0)).getSeriesName());
            courseBook.setBookCode(((BaseBook)baseBooks.get(0)).getBookCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams updateCourse(@RequestBody CourseListDto dto) {
        log.info("\u8bfe\u7a0b\u4fee\u6539----> {}", (Object)JSONObject.toJSONString((Object)dto));
        if ("EXCEPTION".equals(dto.getStatus())) {
            ResourceOccupantExample resourceOccupantExample = new ResourceOccupantExample();
            resourceOccupantExample.createCriteria().andResIdEqualTo(Long.valueOf(dto.getId().intValue())).andResTypeEqualTo("COURSE").andStatusEqualTo("NORMAL");
            List resourceOccupants = this.resourceOccupantMapper.selectByExample(resourceOccupantExample);
            if (!CollectionUtils.isEmpty((Collection)resourceOccupants)) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.DELETE_FILL);
            }
            ResourceOccupant resourceOccupant = new ResourceOccupant();
            resourceOccupant.setStatus("EXCEPTION");
            ResourceOccupantExample resourceOccupantExamplex = new ResourceOccupantExample();
            resourceOccupantExamplex.createCriteria().andOccupantIdEqualTo(Long.valueOf(dto.getId().intValue())).andOccupantTypeEqualTo("COURSE");
            this.resourceOccupantMapper.updateByExampleSelective(resourceOccupant, resourceOccupantExamplex);
        }
        CourseBook courseBook = new CourseBook();
        BeanUtils.copyProperties((Object)dto, (Object)courseBook);
        this.updateCourseNameAndBookCode(dto, courseBook);
        int i = this.courseBookMapper.updateByPrimaryKeySelective(courseBook);
        if (LexileResTypeEnum.NP.getCode().equals(dto.getLexileResTypeCode())) {
            CourseBook item = new CourseBook();
            item.setLexileLevel("");
            item.setId(dto.getId());
            this.courseBookMapper.updateByPrimaryKeySelective(item);
        }
        if (i > 0) {
            LexileResTypeRel lexileResTypeRel;
            CourseBook record = this.courseBookMapper.selectByPrimaryKey(dto.getId());
            if (dto.getLexileResTypeCode() != null && !dto.getLexileResTypeCode().equals("")) {
                if (record != null) {
                    lexileResTypeRel = LexileResTypeRel.builder().lexileResTypeCode(dto.getLexileResTypeCode()).resType("COURSE").resCode(record.getCourseCode()).build();
                    this.lexileResTypeMapper.udpateByResCodeAndType(lexileResTypeRel);
                }
            } else {
                lexileResTypeRel = LexileResTypeRel.builder().resType("COURSE").resCode(record.getCourseCode()).build();
                this.lexileResTypeMapper.deleteByResCodeAndType(lexileResTypeRel);
            }
            ResourceOccupant resourceOccupant = new ResourceOccupant();
            resourceOccupant.setResCode(record.getBookCode());
            ResourceOccupantExample example = new ResourceOccupantExample();
            example.createCriteria().andOccupantIdEqualTo(Long.valueOf(dto.getId().intValue())).andOccupantTypeEqualTo("COURSE");
            this.resourceOccupantMapper.updateByExampleSelective(resourceOccupant, example);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UPDATE_FILL);
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams addCourseQestion(@RequestBody AddCourseQestionRes res) {
        log.info("\u8bfe\u7a0b\u6dfb\u52a0\u9898\u76ee---->  {}", (Object)JSONObject.toJSONString((Object)res));
        String courseCode = res.getCourseCode();
        CouresQuestion couresQuestion = new CouresQuestion();
        List questionCode = res.getQuestionId();
        questionCode.stream().forEach(item -> {
            couresQuestion.setQuestionCode(String.valueOf(item));
            couresQuestion.setIndx(Integer.valueOf(questionCode.indexOf(item) + 1));
            couresQuestion.setCourseCode(courseCode);
            couresQuestion.setCreateTime(new Date());
            this.couresQuestionMapper.insertSelective(couresQuestion);
            ResourceOccupant resourceOccupant = new ResourceOccupant();
            resourceOccupant.setResId(item);
            resourceOccupant.setResType("QUESTION");
            resourceOccupant.setOccupantId(res.getId());
            resourceOccupant.setOccupantType("COURSE");
            resourceOccupant.setCreateTime(new Date());
            resourceOccupant.setStatus("NORMAL");
            this.resourceOccupantMapper.insertSelective(resourceOccupant);
        });
        CouresQuestionExample couresQuestionExample = new CouresQuestionExample();
        couresQuestionExample.createCriteria().andCourseCodeEqualTo(courseCode);
        int i1 = this.couresQuestionMapper.countByExample(couresQuestionExample);
        CourseBookExample courseBookExample = new CourseBookExample();
        courseBookExample.createCriteria().andCourseCodeEqualTo(courseCode);
        List courseBooks = this.courseBookMapper.selectByExample(courseBookExample);
        ((CourseBook)courseBooks.get(0)).setTestNum(Integer.valueOf(i1));
        this.courseBookMapper.updateByPrimaryKey((CourseBook)courseBooks.get(0));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams changeCourseQuestionIndex(@RequestBody ChangeCourseQuestionIndexRes res) {
        log.info("\u8bfe\u7a0b\u4e60\u9898\u4ea4\u6362\u4f4d\u7f6e---> {}", (Object)JSONObject.toJSONString((Object)res));
        String courseCode = res.getCourseCode();
        List questionCodes = res.getQuestionCodes();
        if (questionCodes.size() != 2) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        CouresQuestionExample couresQuestionExample = new CouresQuestionExample();
        CouresQuestionExample.Criteria criteria = couresQuestionExample.createCriteria().andCourseCodeEqualTo(courseCode).andQuestionCodeIn(questionCodes);
        List couresQuestions = this.couresQuestionMapper.selectByExample(couresQuestionExample);
        Integer id = ((CouresQuestion)couresQuestions.get(1)).getId();
        Integer id1 = ((CouresQuestion)couresQuestions.get(0)).getId();
        ((CouresQuestion)couresQuestions.get(0)).setId(id);
        ((CouresQuestion)couresQuestions.get(1)).setId(id1);
        couresQuestions.stream().forEach(item -> this.couresQuestionMapper.updateByPrimaryKey(item));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    @RequestMapping(value={"v1/courseQuestionList"}, method={RequestMethod.POST})
    @EnableValidate
    public ResponseParams courseQuestionList(@RequestBody CourseQuestionListReq res) {
        log.info("\u8bfe\u7a0b\u4e60\u9898\u5217\u8868---> {}", (Object)JSONObject.toJSONString((Object)res));
        ArrayList list = new ArrayList();
        CouresQuestionExample example = new CouresQuestionExample();
        example.createCriteria().andCourseCodeEqualTo(res.getCourseCode());
        example.setOrderByClause("id asc");
        List couresQuestions = this.couresQuestionMapper.selectByExample(example);
        couresQuestions.stream().forEach(item -> {
            CourseQuestionListDto dto = new CourseQuestionListDto();
            String questionCode = item.getQuestionCode();
            ResQuestion resQuestion = this.resQuestionMapper.selectByPrimaryKey(Long.valueOf(questionCode));
            dto.setKnowledgePoint(resQuestion.getKnowledgePoint());
            dto.setSrialNumber(Integer.valueOf(couresQuestions.indexOf(item) + 1));
            dto.setQuestionId(resQuestion.getId());
            dto.setType(resQuestion.getKnowledgeType());
            list.add(dto);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, list);
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams courseQuestionDel(@RequestBody CourseQuestionListReq res) {
        log.info("\u8bfe\u7a0b\u4e60\u9898\u5220\u9664---> {}", (Object)JSONObject.toJSONString((Object)res));
        if (StringUtils.isEmpty((String)String.valueOf(res.getQuestionId()))) {
            return new ResponseParams(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg());
        }
        CouresQuestionExample example = new CouresQuestionExample();
        example.createCriteria().andCourseCodeEqualTo(res.getCourseCode()).andQuestionCodeEqualTo(String.valueOf(res.getQuestionId()));
        int i = this.couresQuestionMapper.deleteByExample(example);
        ResourceOccupantExample resourceOccupantExample = new ResourceOccupantExample();
        resourceOccupantExample.createCriteria().andResIdEqualTo(res.getQuestionId()).andResTypeEqualTo("QUESTION").andOccupantIdEqualTo(res.getQuestionId()).andOccupantTypeEqualTo("COURSE").andStatusEqualTo("NORMAL");
        List resourceOccupants = this.resourceOccupantMapper.selectByExample(resourceOccupantExample);
        if (!CollectionUtils.isEmpty((Collection)resourceOccupants)) {
            resourceOccupants.stream().forEach(item -> {
                item.setStatus("EXCEPTION");
                this.resourceOccupantMapper.updateByPrimaryKey(item);
            });
        }
        CourseBook courseBook = this.courseBookMapper.selectByPrimaryKey(Integer.valueOf(res.getCourseId().intValue()));
        courseBook.setTestNum(Integer.valueOf(courseBook.getTestNum() - 1));
        this.courseBookMapper.updateByPrimaryKey(courseBook);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)i);
    }
}

