/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.mapper.cache.handler;

import com.ella.frame.cache.DistributedCache;
import com.ella.resource.domain.Map;
import com.ella.resource.mapper.MapMapper;
import com.ella.resource.mapper.cache.handler.ICacheHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MapMapperCacheHandler
implements ICacheHandler {
    @Autowired
    private MapMapper mapMapper;
    @Autowired
    private DistributedCache redisCache;

    public void evictCache(String resourceName, Object[] args) {
        if (args == null || args.length == 0) {
            this.redisCache.batchDelLike(resourceName + "*");
            return;
        }
        Map map = (Map)args[0];
        Long id = map.getId();
        Map data = this.mapMapper.selectByPrimaryKey(id);
        if (data == null) {
            return;
        }
        String mapCode = data.getMapCode();
        String key = "db_resource_" + resourceName + mapCode;
        this.redisCache.del(key);
    }
}

