/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.configure;

import feign.RequestInterceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignHeadConfiguration {
    private static final Logger log = LogManager.getLogger(FeignHeadConfiguration.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            HttpServletRequest request;
            Enumeration headerNames;
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null && (headerNames = (request = requestAttributes.getRequest()).getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    String value = request.getHeader(name);
                    if (!"Authorization".equalsIgnoreCase(name) && !"enHeadParam".equalsIgnoreCase(name)) continue;
                    requestTemplate.header(name, new String[]{value});
                }
            }
        };
    }
}

