/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.configure;

import com.ella.frame.aop.util.DataCacheHandler;
import com.ella.frame.cache.DistributedCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
@Component
public class DataCacheInterceptor
implements Interceptor {
    @Autowired
    private DistributedCache redisCache;
    private Set<String> dbCacheSet;
    private Set<String> serviceCacheSet;
    private Set<String> serviceResourceCacheSet;
    @Value(value="#{${service_cache_map}}")
    private Map<String, String> serviceCacheMap = new HashMap();
    private Map<String, String> dbCacheMap = new HashMap();
    @Autowired
    private DataCacheHandler dataCacheHandler;

    @PostConstruct
    void init() {
        this.dbCacheSet = new HashSet();
        this.transferMap2Set(this.dbCacheMap, this.dbCacheSet, null);
        this.serviceCacheSet = new HashSet();
        this.serviceResourceCacheSet = new HashSet();
        this.transferMap2Set(this.serviceCacheMap, this.serviceCacheSet, this.serviceResourceCacheSet);
    }

    private void transferMap2Set(Map<String, String> cacheMap, Set<String> cacheSet, Set<String> resourceSet) {
        cacheMap.keySet().forEach(k -> {
            String[] valueStr;
            String v = (String)cacheMap.get(k);
            for (String value : valueStr = v.split(":")) {
                if (resourceSet != null) {
                    resourceSet.add(value);
                }
                value = k + ":" + value;
                cacheSet.add(value);
            }
        });
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String[] ids = mappedStatement.getId().split("\\.");
        String resource = ids[ids.length - 2];
        String dbResource = ids[ids.length - 2] + ":" + ids[ids.length - 1];
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        String paramsKey = "";
        if (parameter instanceof String) {
            paramsKey = parameter.toString();
        } else if (parameter instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameter;
            for (Object key : paramMap.keySet()) {
                Object value = paramMap.get(key);
                if (value == null) continue;
                paramsKey = paramsKey + value.toString();
            }
        }
        if (this.serviceResourceCacheSet != null && this.serviceResourceCacheSet.contains(resource) && !mappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            String operate = "UPDATE";
            if (mappedStatement.getSqlCommandType().equals((Object)SqlCommandType.INSERT)) {
                operate = "INSERT";
            } else if (mappedStatement.getSqlCommandType().equals((Object)SqlCommandType.DELETE)) {
                operate = "DELETE";
            }
            this.dataCacheHandler.handleForOne(operate, this.serviceCacheSet, resource);
        }
        if (this.dbCacheSet != null && this.dbCacheSet.contains(dbResource) && mappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            Object cacheData = this.dataCacheHandler.handleForOne("SELECT", null, dbResource = dbResource + paramsKey);
            if (cacheData != null) {
                return cacheData;
            }
            Object data = invocation.proceed();
            if (paramsKey != null && !paramsKey.equals("")) {
                this.dataCacheHandler.cache("one", null, null, dbResource, data);
            }
            return data;
        }
        Object data = invocation.proceed();
        return data;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

