/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.configure;

import com.ella.frame.aop.annotion.EnableDataCache;
import com.ella.frame.aop.annotion.EvictDataCache;
import com.ella.frame.aop.util.DataCacheHandler;
import com.ella.resource.mapper.cache.handler.ICacheHandler;
import com.ella.resource.service.cache.IServiceCacheHandler;
import com.ella.resource.utils.ApplicationContextHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataCacheAspect {
    private static final Logger log = LogManager.getLogger(DataCacheAspect.class);
    @Autowired
    DataCacheHandler dataCacheHandler;

    @Pointcut(value="@annotation(com.ella.frame.aop.annotion.EnableDataCache)")
    public void enableDataCachePointcut() {
    }

    @Pointcut(value="@annotation(com.ella.frame.aop.annotion.EvictDataCache)")
    public void evictDataCachePointcut() {
    }

    @Around(value="enableDataCachePointcut()")
    public Object enableDataCache(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        EnableDataCache enableDataCache = ((MethodSignature)signature).getMethod().getAnnotation(EnableDataCache.class);
        String methodName = ((MethodSignature)signature).getMethod().getName();
        String[] resourceNames = enableDataCache.resourceName();
        Class clazz = enableDataCache.clazz();
        String beanName = this.transferFirstLowerCase(clazz.getSimpleName()) + "CacheHandler";
        IServiceCacheHandler handler = (IServiceCacheHandler)ApplicationContextHelper.getBean((String)beanName);
        String uid = "";
        Object result = handler.getCache(methodName, resourceNames, args);
        if (result != null) {
            return result;
        }
        Object resultObj = joinPoint.proceed(args);
        handler.cache(methodName, args, resultObj);
        return resultObj;
    }

    @Around(value="evictDataCachePointcut()")
    public Object evictDataCache(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        EvictDataCache evictDataCache = ((MethodSignature)signature).getMethod().getAnnotation(EvictDataCache.class);
        String methodName = ((MethodSignature)signature).getMethod().getName();
        String[] resourceNames = evictDataCache.resourceName();
        String cacheLevel = evictDataCache.cacheLevel();
        boolean evictAll = evictDataCache.evictAll();
        String uid = "";
        if ("two".equals(cacheLevel)) {
            return joinPoint.proceed(args);
        }
        Object resultObj = joinPoint.proceed(args);
        for (String resourceName : resourceNames) {
            String beanName = this.transferFirstLowerCase(resourceName).substring(0, resourceName.indexOf(":")) + "CacheHandler";
            ICacheHandler handler = (ICacheHandler)ApplicationContextHelper.getBean((String)beanName);
            if (evictAll) {
                handler.evictCache(resourceName, null);
                continue;
            }
            handler.evictCache(resourceName, args);
        }
        return resultObj;
    }

    private String transferFirstLowerCase(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

