/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.config;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.util.Base64Util;
import com.ella.frame.common.util.HeadParamTl;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HeadParamUtil {
    private static final Logger log = LogManager.getLogger(HeadParamUtil.class);
    private static final String EMPTY = "";

    public static HeadParamTl getHeadParamTl() {
        HeadParamTl headParamTl = new HeadParamTl();
        HttpServletRequest request = HeadParamUtil.getHttpServletRequest();
        String enHeadParam = HeadParamUtil.getStrFromBase64(request.getHeader("enHeadParam"));
        if (StringUtils.isBlank((CharSequence)enHeadParam)) {
            return headParamTl;
        }
        try {
            headParamTl = (HeadParamTl)JSONObject.parseObject((String)enHeadParam, HeadParamTl.class);
            log.info("method HeadParamUtil.getHeadParamTl result:{}", (Object)headParamTl.toString());
        }
        catch (Exception e) {
            return headParamTl;
        }
        return headParamTl;
    }

    private static HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getRequest();
    }

    public static String getAuthorization() {
        return Optional.ofNullable(HeadParamUtil.getHttpServletRequest().getHeader("Authorization")).orElse(EMPTY);
    }

    private static String getStrFromBase64(String header) {
        if (StringUtils.isBlank((CharSequence)header)) {
            return EMPTY;
        }
        try {
            return Base64Util.decodeBase64StrNew((String)header);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException ie) {
            return EMPTY;
        }
    }

    public static String getChannelCode() {
        return Optional.ofNullable(HeadParamUtil.getHeadParamTl().getChannelCode()).orElse(EMPTY);
    }

    public static String getClientRole() {
        return Optional.ofNullable(HeadParamUtil.getHeadParamTl().getClientRole()).orElse(EMPTY);
    }

    public static String getClientType() {
        return Optional.ofNullable(HeadParamUtil.getHeadParamTl().getClientType()).orElse(EMPTY);
    }

    public static String getDeviceNo() {
        return Optional.ofNullable(HeadParamUtil.getHeadParamTl().getDeviceNo()).orElse(EMPTY);
    }

    public static String getResource() {
        return Optional.ofNullable(HeadParamUtil.getHeadParamTl().getResource()).orElse(EMPTY);
    }
}

