/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.resource.dto.GetLevelInfoResponse;
import com.ella.resource.dto.LexileLevelHistoryDto;
import com.ella.resource.dto.StartLexileEvaluationRequest;
import com.ella.resource.dto.appdto.GetInitiativeInfoResponse;
import com.ella.resource.dto.request.lexile.LexileEvalutionHandOverRequest;
import com.ella.resource.dto.request.question.LexileAnswerResponse;
import com.ella.resource.dto.request.question.LexileEvaHistoryDetailDto;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="en-resource-service")
public interface LexileLevelHistoryService {
    @RequestMapping(value={"/v1/lexile-test/latest-history"}, method={RequestMethod.GET})
    public ResponseParams<LexileLevelHistoryDto> latestLexileHistory(@RequestParam(value="uid", required=true) String var1);

    @RequestMapping(value={"/v1/lexile-test/start"}, method={RequestMethod.POST})
    public ResponseParams<LexileLevelHistoryDto> createLexileHistory(@RequestBody StartLexileEvaluationRequest var1);

    @RequestMapping(value={"/v1/lexile-test/handover"}, method={RequestMethod.POST})
    public ResponseParams<LexileAnswerResponse> handover(@RequestBody LexileEvalutionHandOverRequest var1);

    @RequestMapping(value={"/v1/lexile-test/history-detail"}, method={RequestMethod.POST})
    public ResponseParams<LexileEvaHistoryDetailDto> historyDetail(@RequestParam(value="historyId", required=true) Integer var1, @RequestParam(value="uid", required=true) String var2);

    @RequestMapping(value={"/v1/lexile-test/history-detail-by-levelcode"}, method={RequestMethod.GET})
    public ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByLevelCode(@RequestParam(value="levelCode", required=true) String var1, @RequestParam(value="uid", required=true) String var2);

    @RequestMapping(value={"/v1/lexile-test/history-detail-by-origin-levelcode"}, method={RequestMethod.GET})
    public ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByOriginLevelCode(@RequestParam(value="levelCode", required=true) String var1, @RequestParam(value="uid", required=true) String var2);

    @RequestMapping(value={"/v1/lexile-test/max-socre-history-by-Origin-levelcode"}, method={RequestMethod.GET})
    public ResponseParams<LexileLevelHistoryDto> maxScoreHistoryByOriginLevelCode(@RequestParam(value="levelCode", required=true) String var1, @RequestParam(value="uid", required=true) String var2);

    @RequestMapping(value={"/v1/lexile-test/wrong-answer-missioninfo-by-history-id"}, method={RequestMethod.GET})
    public ResponseParams<List<Map<String, Object>>> wrongAnswerMissonInfoByHistoryId(@RequestParam(value="historyId", required=true) int var1);

    @RequestMapping(value={"/v1/getInitiativeInfo"}, method={RequestMethod.GET})
    public ResponseParams<GetInitiativeInfoResponse> getInitiativeInfo(@RequestParam(value="uid") String var1);

    @RequestMapping(value={"/v1/getLevelInfo"}, method={RequestMethod.GET})
    public ResponseParams<GetLevelInfoResponse> getLevelInfo(@RequestParam(value="uid") String var1);

    @RequestMapping(value={"/v1/getHistoryInfo"}, method={RequestMethod.GET})
    public ResponseParams<LexileLevelHistory> getHistoryInfo(@RequestParam(value="uid") String var1);
}

