/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelListDto;
import com.ella.resource.dto.request.GetLevelInfoRequest;
import com.ella.resource.dto.request.UpdateLevelRequest;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="en-resource-service")
public interface LevelService {
    @RequestMapping(value={"/v1/level/getLevelList"}, method={RequestMethod.GET})
    public ResponseParams<List<LevelListDto>> getLevelList();

    @RequestMapping(value={"/v1/level/getLevelInfo"}, method={RequestMethod.POST})
    public ResponseParams<LevelDto> getLevelInfo(@RequestBody GetLevelInfoRequest var1);

    @RequestMapping(value={"/v1/level/updateLevel"}, method={RequestMethod.POST})
    public ResponseParams<Boolean> updateLevel(@RequestBody UpdateLevelRequest var1);

    @RequestMapping(value={"/v1/level/doSureLevel"}, method={RequestMethod.POST})
    public ResponseParams<Boolean> doSureLevel(GetLevelInfoRequest var1);

    @RequestMapping(value={"/v1/level/all-enable-levels"}, method={RequestMethod.GET})
    public ResponseParams<List<LevelDto>> allEnableLevels();

    @RequestMapping(value={"/v1/level/default"}, method={RequestMethod.GET})
    public ResponseParams<LevelDto> defaultLevel();

    @RequestMapping(value={"/v1/level/get-by-code"}, method={RequestMethod.GET})
    public ResponseParams<LevelDto> getLevelByCode(@RequestParam(value="code", required=true) String var1);

    @RequestMapping(value={"/v1/level/get-by-index"}, method={RequestMethod.GET})
    public ResponseParams<LevelDto> getLevelByIndex(@RequestParam(value="levelIndex", required=true) Integer var1);

    @RequestMapping(value={"/v1/level/getLevelByCode"}, method={RequestMethod.POST})
    public ResponseParams<LevelDto> getLevelByCode(GetLevelInfoRequest var1);

    @RequestMapping(value={"/v1/level/get-by-ability"}, method={RequestMethod.GET})
    public ResponseParams<LevelDto> getLevelByAbility(@RequestParam(value="ability", required=true) Integer var1);

    @RequestMapping(value={"/v1/level/getLexileResTypeCodeList"}, method={RequestMethod.GET})
    public ResponseParams<List<String>> getLexileResTypeCodeList();

    @RequestMapping(value={"/v1/level/transferLexileLevel"}, method={RequestMethod.POST})
    public String transferLexileLevel(@RequestParam(value="lexileLevel") String var1);
}

