/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.utils;

import com.alibaba.fastjson.JSONObject;
import com.ella.order.utils.MD5Util;
import com.ella.order.utils.WxpayConfig;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jdom.Attribute;

/*
 * Exception performing whole class analysis ignored.
 */
public class WeixinPayUtils {
    private static final Logger log = LogManager.getLogger(WeixinPayUtils.class);
    public static final String URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";

    public static Map<String, String> goToUnifieDorder(String outTradeNo, String subject, String body, String price, String memberIP) {
        TreeMap map = new TreeMap();
        String sign = WeixinPayUtils.getUnifieDorderSign((String)outTradeNo, (String)subject, (String)body, (String)price, (String)memberIP, map);
        return WeixinPayUtils.getConnectionXmlResponse((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", map, (String)"POST");
    }

    private static Map<String, String> getConnectionXmlResponse(String url, TreeMap<String, String> map, String method) {
        Map result = null;
        String xml = WeixinPayUtils.mapToXml(map);
        log.debug("\u5fae\u4fe1\u63a5\u53e3\u53c2\u6570\uff1a" + xml);
        log.debug("\u5fae\u4fe1\u8c03\u7528URL\uff1a" + url);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            if (map.size() != 0) {
                OutputStream os = connection.getOutputStream();
                os.write(xml.getBytes("utf-8"));
                os.close();
            } else {
                connection.connect();
            }
            InputStream is = connection.getInputStream();
            String xmlResult = WeixinPayUtils.inputStreamToString((InputStream)is);
            log.info("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\u8fd4\u56deXML\u4fe1\u606f\uff1a" + xmlResult);
            result = WeixinPayUtils.xmlToMap((String)xmlResult);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String inputStreamToString(InputStream is) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader reader = new InputStreamReader(is, "utf-8");
            BufferedReader br = new BufferedReader(reader);
            String str = "";
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            log.debug("\u5fae\u4fe1\u8f93\u5165\u6d41\u89e3\u6790\u7ed3\u679c:" + sb);
            br.close();
            reader.close();
            is.close();
            is = null;
        }
        catch (UnsupportedEncodingException e) {
            log.debug("\u5fae\u4fe1\u8f93\u5165\u6d41\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            e.printStackTrace();
        }
        catch (IOException e) {
            log.debug("\u5fae\u4fe1\u5b57\u7b26\u6d41\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Map<String, String> xmlToMap(String xml) {
        if (StringUtils.isEmpty((String)(xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")))) {
            return null;
        }
        Map map = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("utf-8"));
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)in);
            Element root = doc.getRootElement();
            map = WeixinPayUtils.parseXML((Element)root, new HashMap());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String mapToXml(Map<String, String> map) {
        StringBuffer xml = new StringBuffer("<xml>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    private static Map<String, String> parseXML(Element ele, Map<String, String> map) {
        Iterator i = ele.elementIterator();
        while (i.hasNext()) {
            Element node = (Element)i.next();
            if (node.attributes() != null && node.attributes().size() > 0) {
                Iterator j = node.attributeIterator();
                while (j.hasNext()) {
                    Attribute item = (Attribute)j.next();
                    map.put(item.getName(), item.getValue());
                }
            }
            if (node.getText().length() > 0) {
                map.put(node.getName(), node.getText());
            }
            if (!node.elementIterator().hasNext()) continue;
            WeixinPayUtils.parseXML((Element)node, map);
        }
        return map;
    }

    public static String getUnifieDorderSign(String outTradeNo, String subject, String body, String price, String memberIP, TreeMap<String, String> map) {
        String randomstr = UUID.randomUUID().toString().replace("-", "");
        map.put("appid", WxpayConfig.appid);
        map.put("mch_id", WxpayConfig.mch_id);
        map.put("nonce_str", randomstr);
        map.put("body", subject);
        map.put("attach", body);
        map.put("out_trade_no", outTradeNo);
        map.put("total_fee", price);
        map.put("spbill_create_ip", memberIP);
        map.put("notify_url", WxpayConfig.notifyURL);
        map.put("trade_type", "APP");
        log.info(JSONObject.toJSONString(map));
        String sign = WeixinPayUtils.createWechatSign(map, (String)WxpayConfig.key);
        map.put("sign", sign);
        return sign;
    }

    public static String createWechatSign(TreeMap<String, String> map, String key) {
        StringBuffer signBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            signBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        signBuffer.append("key=").append(key);
        return MD5Util.md5Encode((String)signBuffer.toString(), (String)"UTF-8");
    }
}

