/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.pay;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.Base64Util;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.order.api.PayService;
import com.ella.order.domain.IosPayCertificate;
import com.ella.order.dto.IosPayCertificateExample;
import com.ella.order.dto.RetCodeEnum;
import com.ella.order.dto.UpdateOrderDto;
import com.ella.order.dto.order.OrderStatusEnum;
import com.ella.order.dto.order.PayMethodEnum;
import com.ella.order.dto.pay.ApplePayNotifyOrderRequest;
import com.ella.order.mapper.IosPayCertificateMapper;
import com.ella.order.service.order.AbstractCreateOrderHandler;
import com.ella.order.service.order.CreateOrderContainer;
import com.ella.order.service.pay.PayServiceImpl;
import com.ella.order.utils.AlipayNotify;
import com.ella.order.utils.HttpClientUtil;
import com.ella.order.utils.ResponseParamUtils;
import com.ella.order.utils.ValidationUtils;
import com.ella.order.utils.WXPayUtil;
import com.ella.order.utils.WeixinPayUtils;
import com.ella.order.utils.WxpayConfig;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class PayServiceImpl
implements PayService {
    private static final Logger log = LogManager.getLogger(PayServiceImpl.class);
    @Autowired
    private IosPayCertificateMapper iosPayCertificateMapper;

    public ResponseParams<String> callBack(@RequestParam(name="type") PayMethodEnum type, @RequestBody Map<String, String> ext) {
        log.info("callBack --- req : {} {}", (Object)type, (Object)JSONObject.toJSONString(ext));
        if (type == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        switch (1.$SwitchMap$com$ella$order$dto$order$PayMethodEnum[type.ordinal()]) {
            case 1: {
                return this.analysisAlipayResult(ext, type);
            }
            case 2: {
                return this.analysisWxpayResult(ext, type);
            }
            case 3: {
                return this.analysisIapResult(ext, type);
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)"\u652f\u4ed8\u7c7b\u578b\u975e\u6cd5");
    }

    private ResponseParams<String> analysisAlipayResult(Map<String, String> ext, PayMethodEnum type) {
        if (ext == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)"\u4e0a\u9001\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String tradeStatus = new String(ext.get("trade_status").getBytes("ISO-8859-1"), "UTF-8");
            log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03  tradeStatus = " + tradeStatus);
            String orderNo = new String(ext.get("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String tradeNo = new String(ext.get("trade_no").getBytes("ISO-8859-1"), "UTF-8");
            if (AlipayNotify.verify(ext) && "TRADE_SUCCESS".equals(tradeStatus)) {
                return this.updateOrderStatusToSuccess(orderNo, tradeNo, type);
            }
            log.info("\u9a8c\u7b7e\u5931\u8d25\u6216\u652f\u4ed8\u72b6\u6001\u4e3a\u5931\u8d25\u3002\u3002\u3002\u3002");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)"\u9a8c\u7b7e\u5931\u8d25\u6216\u652f\u4ed8\u72b6\u6001\u4e3a\u5931\u8d25");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, (Object)"\u8f6c\u7801\u5f02\u5e38");
        }
    }

    private ResponseParams<String> analysisWxpayResult(Map<String, String> ext, PayMethodEnum type) {
        String content = ext.get("content");
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u62a5\u6587\u4e3a\u7a7a---");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Map result = WeixinPayUtils.xmlToMap((String)content);
        String errorReturn = "<xml> \n<return_code><![CDATA[FALL]]></return_code>\n<return_msg><![CDATA[FALL]]></return_msg>\n</xml>";
        try {
            WXPayUtil.isSignatureValid((Map)result, (String)WxpayConfig.key);
        }
        catch (Exception e) {
            log.info("analysisWxpayResult  check sign error :", (Throwable)e);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)errorReturn);
        }
        if ("SUCCESS".equals(result.get("return_code"))) {
            String resultCode = (String)result.get("result_code");
            log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03result_code = " + resultCode);
            if ("SUCCESS".equals(resultCode)) {
                String orderNo = (String)result.get("out_trade_no");
                String tradeNo = (String)result.get("transaction_id");
                String totalFee = (String)result.get("total_fee");
                ResponseParams response = this.updateOrderStatusToSuccess(orderNo, tradeNo, type);
                if (!CommonRetCode.SUCCESS.getCode().equals(response)) {
                    return response;
                }
                log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03:order_no=" + orderNo + ",    trade_no=" + tradeNo);
                String returnResult = "<xml> \n<return_code><![CDATA[SUCCESS]]></return_code>\n<return_msg><![CDATA[OK]]></return_msg>\n</xml>";
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)returnResult);
            }
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)errorReturn);
    }

    private ResponseParams<String> analysisIapResult(Map<String, String> ext, PayMethodEnum type) {
        String content = ext.get("content");
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.info("iap\u56de\u8c03\u62a5\u6587\u4e3a\u7a7a---");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (StringUtils.isEmpty((CharSequence)content)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        ApplePayNotifyOrderRequest appleNotify = (ApplePayNotifyOrderRequest)JSONObject.parseObject((String)content, ApplePayNotifyOrderRequest.class);
        String checkRet = ValidationUtils.validateEntity((Object)appleNotify, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkRet)) {
            log.info("analysisIapResult param error,{}", (Object)checkRet);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        IosPayCertificateExample exam = new IosPayCertificateExample();
        exam.createCriteria().andOrderNoEqualTo(appleNotify.getOrderNo());
        List list = this.iosPayCertificateMapper.selectByExample(exam);
        IosPayCertificate iosPay = null;
        if (list == null || list.isEmpty()) {
            IosPayCertificate cert = new IosPayCertificate();
            BeanUtils.copyProperties((Object)appleNotify, (Object)cert);
            cert.setId(Long.valueOf(IdWrokerUtils.nextId()));
            cert.setOrderStatus(OrderStatusEnum.WAIT_PAY.getCode());
            this.iosPayCertificateMapper.insertSelective(cert);
            iosPay = cert;
        } else {
            iosPay = (IosPayCertificate)list.get(0);
        }
        String checkResult = PayServiceImpl.buyAppVerify((String)appleNotify.getReceipt(), (String)appleNotify.getVerifyState());
        log.info(checkResult);
        String result = this.analysisCheckResult(checkResult, appleNotify.getOrderNo(), iosPay);
        if (StringUtils.equalsIgnoreCase((CharSequence)"paymentVerificationFailed", (CharSequence)result)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ORDER_PAY_FAIL, (Object)result);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private String analysisCheckResult(String checkResult, String orderNo, IosPayCertificate certificate) {
        JSONObject jsonObject = JSONObject.parseObject((String)checkResult);
        if (!"0".equals(jsonObject.get((Object)"status").toString())) {
            log.error("iap pay result:Verification Failed");
            return "paymentVerificationFailed";
        }
        JSONObject receipt = jsonObject.getJSONObject("receipt");
        log.info("iap pay result:productId={}", (Object)receipt.getString("product_id"));
        log.info("iap pay result:transactionId={}", (Object)receipt.getString("transaction_id"));
        log.info("iap pay result:time1={}", (Object)receipt.getString("purchase_date_ms"));
        log.info("iap pay result:time2={}", (Object)receipt.getString("original_purchase_date_ms"));
        AbstractCreateOrderHandler handler = CreateOrderContainer.getCreateOrderHandlerByPayMethod((PayMethodEnum)PayMethodEnum.IAP);
        UpdateOrderDto dto = new UpdateOrderDto();
        dto.setOrderNo(orderNo);
        dto.setOrderStatus(OrderStatusEnum.ALREADY_PAY);
        dto.setTradeNo(receipt.getString("transaction_id"));
        dto.setIosProductId(receipt.getString("product_id"));
        handler.updateOrder(dto);
        certificate.setOrderStatus(OrderStatusEnum.ALREADY_PAY.getCode());
        certificate.setPayTime(new Date(Long.valueOf(receipt.getString("original_purchase_date_ms"))));
        this.iosPayCertificateMapper.updateByPrimaryKey(certificate);
        if (receipt.getString("purchase_date_ms").equals(receipt.getString("original_purchase_date_ms"))) {
            return "paymentForTheFirstTime";
        }
        return "repeatToPay";
    }

    private static String buyAppVerify(String receipt, String verifyState) {
        String url = "https://buy.itunes.apple.com/verifyReceipt";
        if (verifyState != null && "Sandbox".equals(verifyState)) {
            url = "https://sandbox.itunes.apple.com/verifyReceipt";
        }
        String buyCode = Base64Util.encodeBASE64((String)receipt);
        String json = "{\"receipt-data\":\"" + buyCode + "\"}";
        return HttpClientUtil.doPostJson((String)url, (String)json);
    }

    private ResponseParams<String> updateOrderStatusToSuccess(String orderNo, String tradeNo, PayMethodEnum payMethod) {
        UpdateOrderDto dto = new UpdateOrderDto();
        dto.setOrderNo(orderNo);
        dto.setTradeNo(tradeNo);
        dto.setOrderStatus(OrderStatusEnum.ALREADY_PAY);
        ResponseParams result = CreateOrderContainer.getCreateOrderHandlerByPayMethod((PayMethodEnum)payMethod).updateOrder(dto);
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, (Object)"\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)"success");
    }
}

