/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.pay;

import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.order.domain.Order;
import com.ella.order.dto.RetCodeEnum;
import com.ella.order.dto.order.OrderTypeEnum;
import com.ella.order.dto.order.PayMethodEnum;
import com.ella.order.dto.pay.AliPrepayDto;
import com.ella.order.dto.pay.PrepayDto;
import com.ella.order.dto.pay.WxPrepayDto;
import com.ella.order.service.pay.InnerPayService;
import com.ella.order.utils.OrderInfoUtil;
import com.ella.order.utils.WeixinPayUtils;
import com.ella.order.utils.WxpayConfig;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class InnerPayServiceImpl
implements InnerPayService {
    public PrepayDto createThirdPrePayOrder(Order order) {
        if (order == null) {
            return null;
        }
        if (PayMethodEnum.ALIPAY.getCode().equals(order.getPayMethod())) {
            return this.buildAlipayPrePayInf(order);
        }
        if (PayMethodEnum.WX_PAY.getCode().equals(order.getPayMethod())) {
            return this.buildWxpayPrePayInf(order);
        }
        return null;
    }

    private PrepayDto buildAlipayPrePayInf(Order order) {
        AliPrepayDto result = new AliPrepayDto();
        OrderTypeEnum typeEnum = OrderTypeEnum.getEnumByCode((String)order.getOrderType());
        String orderDesc = order.getOrderType();
        if (typeEnum != null) {
            orderDesc = typeEnum.getMsg();
        }
        String sign = OrderInfoUtil.aliPay((String)order.getOrderNo(), (String)orderDesc, (String)orderDesc, (String)order.getOrderActual().toPlainString());
        result.setSign(sign);
        return result;
    }

    private PrepayDto buildWxpayPrePayInf(Order order) {
        Map wxResult;
        WxPrepayDto result = new WxPrepayDto();
        OrderTypeEnum typeEnum = OrderTypeEnum.getEnumByCode((String)order.getOrderType());
        String orderDesc = order.getOrderType();
        if (typeEnum != null) {
            orderDesc = typeEnum.getMsg();
        }
        if (!"SUCCESS".equals((wxResult = WeixinPayUtils.goToUnifieDorder((String)order.getOrderNo(), (String)orderDesc, (String)orderDesc, (String)String.valueOf(order.getOrderActual().multiply(new BigDecimal(100)).intValue()), (String)order.getReqIp())).get("return_code")) || !"SUCCESS".equals(wxResult.get("result_code"))) {
            throw new EllaEnglishException(RetCodeEnum.CREATE_WX_PRE_PAY_ORDER.getCode(), RetCodeEnum.CREATE_WX_PRE_PAY_ORDER.getMsg(), null);
        }
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("timestamp", timestamp);
        treeMap.put("appid", WxpayConfig.appid);
        treeMap.put("partnerid", WxpayConfig.mch_id);
        treeMap.put("prepayid", (String)wxResult.get("prepay_id"));
        treeMap.put("noncestr", nonceStr);
        treeMap.put("package", "Sign=WXPay");
        String sign = WeixinPayUtils.createWechatSign(treeMap, (String)WxpayConfig.key);
        result.setAppid(WxpayConfig.appid);
        result.setDevice_info((String)wxResult.get("device_info"));
        result.setPartnerid(WxpayConfig.mch_id);
        result.setNonce_str(nonceStr);
        result.setPrepay_id((String)wxResult.get("prepay_id"));
        result.setTimestamp(timestamp);
        result.setSign(sign);
        result.setTrade_type((String)wxResult.get("trade_type"));
        return result;
    }
}

