/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order.delivery;

import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.domain.Order;
import com.ella.order.service.order.delivery.DeliveryService;
import com.ella.resource.api.EllaCoinConfigService;
import com.ella.resource.constants.RetCodeEnum;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import com.ella.user.api.account.UserAccountService;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mapMemberDeliveryService")
public class MapMemberDeliveryServiceImpl
implements DeliveryService {
    private static final Logger log = LogManager.getLogger(MapMemberDeliveryServiceImpl.class);
    @Autowired
    private EllaCoinConfigService coinConfigService;
    @Autowired
    private UserAccountService userAccountService;

    public void sendGoods(Order order, DeliveryService.UserAccountServiceCallback accountService) {
        this.sendMapMember(order, accountService);
    }

    public void sendMapMember(Order order, DeliveryService.UserAccountServiceCallback accountService) {
        GetEllaCoinListByConditRequest req = new GetEllaCoinListByConditRequest();
        req.setCoinCodes(Collections.singletonList(order.getExt1()));
        ResponseParams result = this.coinConfigService.getEllaCoinConfigListByCondit(req);
        this.checkCoinConfig(result);
        accountService.callUserMemberService(order, (CoinConfigDto)((List)result.getData()).get(0));
        this.doModifyUserMember(order, (CoinConfigDto)((List)result.getData()).get(0));
    }

    private void doModifyUserMember(Order order, CoinConfigDto coinConfigDto) {
        int day = this.getDay(coinConfigDto.getIosPriceCode());
        if (!this.userAccountService.updateUserVipInfo(order.getUserId(), day).booleanValue()) {
            throw new EllaEnglishException(RetCodeEnum.UPDATE_FILL.getCode(), RetCodeEnum.UPDATE_FILL.getMsg(), RetCodeEnum.UPDATE_FILL.getMsg());
        }
        log.info("MapMemberDeliveryServiceImpl sendMapMember success end orderNo : {}", (Object)order.getOrderNo());
    }

    private int getDay(String iosPriceCode) {
        switch (iosPriceCode) {
            case "ellabook3monthcard98": {
                return 30;
            }
            case "ellabook3yearcard698": {
                return 365;
            }
        }
        throw new EllaEnglishException(RetCodeEnum.IOS_PRICE_CODE_NON_ERROR.getCode(), RetCodeEnum.IOS_PRICE_CODE_NON_ERROR.getMsg(), RetCodeEnum.IOS_PRICE_CODE_NON_ERROR.getMsg());
    }
}

