/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order.delivery;

import com.ella.frame.common.response.ResponseParams;
import com.ella.order.domain.Order;
import com.ella.order.service.order.delivery.DeliveryService;
import com.ella.resource.api.EllaCoinConfigService;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ellaCoinDeliveryService")
public class EllaCoinDeliveryServiceImpl
implements DeliveryService {
    private static final Logger log = LogManager.getLogger(EllaCoinDeliveryServiceImpl.class);
    @Autowired
    private EllaCoinConfigService coinConfigService;

    public void sendGoods(Order order, DeliveryService.UserAccountServiceCallback accountService) {
        this.sendEllaCoin(order, accountService);
    }

    public void sendEllaCoin(Order order, DeliveryService.UserAccountServiceCallback accountService) {
        GetEllaCoinListByConditRequest req = new GetEllaCoinListByConditRequest();
        ArrayList<String> coinCodes = new ArrayList<String>();
        coinCodes.add(order.getExt1());
        req.setCoinCodes(coinCodes);
        ResponseParams result = this.coinConfigService.getEllaCoinConfigListByCondit(req);
        this.checkCoinConfig(result);
        accountService.callUserAccountService(order, (CoinConfigDto)((List)result.getData()).get(0));
        log.info("EllaCoinDeliveryServiceImpl callUserAccountService -- change money success end orderNo : {}", (Object)order.getOrderNo());
    }
}

