/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.api.OrderService;
import com.ella.order.domain.Order;
import com.ella.order.domain.OrderDetail;
import com.ella.order.dto.GoodsExample;
import com.ella.order.dto.OrderExample;
import com.ella.order.dto.ResponsePageResult;
import com.ella.order.dto.StatusEnum;
import com.ella.order.dto.order.BuyHistoryDto;
import com.ella.order.dto.order.EllaCoinHistoryDto;
import com.ella.order.dto.order.GetOrderDetailRequest;
import com.ella.order.dto.order.GetOrderListByPageRequest;
import com.ella.order.dto.order.OrderFullDetailDto;
import com.ella.order.dto.order.OrderFullDto;
import com.ella.order.dto.order.OrderReductDetailDto;
import com.ella.order.dto.order.OrderStatusEnum;
import com.ella.order.dto.order.PayMethodEnum;
import com.ella.order.dto.order.UserOrderSummaryDto;
import com.ella.order.mapper.GoodsMapper;
import com.ella.order.mapper.OrderMapper;
import com.ella.order.utils.ResponsePageResultUtils;
import com.ella.order.utils.ResponseParamUtils;
import com.ella.user.api.enums.DataStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LogManager.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoodsMapper goodsMapper;

    @EnableValidate
    public ResponseParams<ResponsePageResult<List<OrderFullDto>>> getOrderListByPage(@RequestBody GetOrderListByPageRequest req) {
        log.info("getOrderListByPage req :{}", (Object)req);
        Order query = new Order();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        OrderExample orderExample = new OrderExample();
        orderExample.setOrderByClause(" create_time desc");
        OrderExample.Criteria criteria = orderExample.createCriteria();
        if (req.getCreateTimeStart() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(req.getCreateTimeStart());
        }
        if (req.getCreateTimeEnd() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(req.getCreateTimeEnd());
        }
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        List list = this.orderMapper.selectByConditAndJoinOrderDetailTable(query, orderExample);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build(null));
        }
        ArrayList<OrderFullDto> dtoList = new ArrayList<OrderFullDto>();
        for (Order order : list) {
            OrderFullDto dto = new OrderFullDto();
            BeanUtils.copyProperties((Object)order, (Object)dto);
            if (order.getOrderDetails() == null || order.getOrderDetails().isEmpty()) continue;
            ArrayList<OrderFullDetailDto> detailDtos = new ArrayList<OrderFullDetailDto>();
            for (OrderDetail orderDetail : order.getOrderDetails()) {
                OrderFullDetailDto shortDetailDto = new OrderFullDetailDto();
                BeanUtils.copyProperties((Object)orderDetail, (Object)shortDetailDto);
                detailDtos.add(shortDetailDto);
                GoodsExample goodExample = new GoodsExample();
                goodExample.createCriteria().andGoodsCodeEqualTo(shortDetailDto.getGoodsNo());
                List goods = this.goodsMapper.selectByExample(goodExample);
                if (goods == null || goods.isEmpty()) continue;
                BeanUtils.copyProperties(goods.get(0), (Object)shortDetailDto);
            }
            dto.setOrderDetails(detailDtos);
            dtoList.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((PageInfo)new PageInfo(list), dtoList));
    }

    @EnableValidate
    public ResponseParams<OrderFullDto> getOrderDetail(@RequestBody GetOrderDetailRequest req) {
        OrderFullDetailDto shortDetailDto;
        ArrayList<OrderFullDetailDto> detailDtos;
        log.info("getOrderDetail req :{}", (Object)req);
        Order query = new Order();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        OrderExample orderExample = new OrderExample();
        OrderExample.Criteria criteria = orderExample.createCriteria();
        List list = this.orderMapper.selectByConditAndJoinOrderDetailTableAndReductDetailTable(query, orderExample);
        if (list == null || list.isEmpty()) {
            log.info("getOrderDetail \u8981\u67e5\u8be2\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        Order order = (Order)list.get(0);
        OrderFullDto dto = new OrderFullDto();
        BeanUtils.copyProperties((Object)order, (Object)dto);
        if (order.getOrderDetails() != null && !order.getOrderDetails().isEmpty()) {
            detailDtos = new ArrayList<OrderFullDetailDto>();
            for (OrderDetail orderDetail : order.getOrderDetails()) {
                shortDetailDto = new OrderFullDetailDto();
                BeanUtils.copyProperties((Object)orderDetail, (Object)shortDetailDto);
                detailDtos.add(shortDetailDto);
                GoodsExample goodExample = new GoodsExample();
                goodExample.createCriteria().andGoodsCodeEqualTo(shortDetailDto.getGoodsNo());
                List goods = this.goodsMapper.selectByExample(goodExample);
                if (goods == null || goods.isEmpty()) continue;
                BeanUtils.copyProperties(goods.get(0), (Object)shortDetailDto);
            }
            dto.setOrderDetails(detailDtos);
        }
        if (order.getOrderReductDetails() != null && !order.getOrderReductDetails().isEmpty()) {
            detailDtos = new ArrayList();
            for (OrderDetail orderDetail : order.getOrderReductDetails()) {
                shortDetailDto = new OrderReductDetailDto();
                BeanUtils.copyProperties((Object)orderDetail, (Object)shortDetailDto);
                detailDtos.add(shortDetailDto);
            }
            dto.setOrderReductDetailDto(detailDtos);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    @EnableValidate
    public ResponseParams<ResponsePageResult<List<EllaCoinHistoryDto>>> getEllaCoinHistory(@RequestParam(value="uid", required=true) String uid) {
        log.info("getEllaCoinHistory uid :{}", (Object)uid);
        OrderExample orderExample = new OrderExample();
        orderExample.setOrderByClause(" finish_time desc");
        orderExample.createCriteria().andUserIdEqualTo(uid).andStatusEqualTo(StatusEnum.NORMAL.getCode()).andOrderStatusEqualTo(OrderStatusEnum.ALREADY_PAY.getCode());
        List list = this.orderMapper.selectByExample(orderExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build(null));
        }
        ArrayList<EllaCoinHistoryDto> results = new ArrayList<EllaCoinHistoryDto>();
        for (Order order : list) {
            EllaCoinHistoryDto dto = EllaCoinHistoryDto.builder().orderNo(order.getOrderNo()).orderActual(order.getOrderActual()).orderType(order.getOrderType()).finishTime(order.getFinishTime()).type(PayMethodEnum.ELLA_COIN.getCode().equals(order.getPayMethod()) ? "-" : "+").build();
            results.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)list, results));
    }

    public ResponseParams<UserOrderSummaryDto> getUserOrderSummary(@RequestParam(value="uid", required=true) String uid) {
        UserOrderSummaryDto summary = new UserOrderSummaryDto();
        summary.setUid(uid);
        List summaryMaps = this.orderMapper.selectUserOrderSummary(uid, OrderStatusEnum.ALREADY_PAY.getCode(), DataStatusEnum.NORMAL.getCode());
        if (!CollectionUtils.isEmpty((Collection)summaryMaps)) {
            summaryMaps.forEach(sm -> {
                BigDecimal amount = (BigDecimal)sm.get("amount");
                if (PayMethodEnum.ELLA_COIN.getCode().equals((String)sm.get("payMethod"))) {
                    summary.setSumCost(summary.getSumCost().add(amount));
                } else {
                    summary.setSumRecharge(summary.getSumRecharge().add(amount));
                }
            });
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)summary);
    }

    public ResponseParams<String> getUserLatestOrderGoodsName(@RequestParam(value="uid", required=true) String uid) {
        String goodsName = this.orderMapper.selectUserLatestOrderGoodsName(uid, PayMethodEnum.ELLA_COIN.getCode(), OrderStatusEnum.ALREADY_PAY.getCode(), DataStatusEnum.NORMAL.getCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)goodsName);
    }

    public List<BuyHistoryDto> buyHistory(String uid) {
        ArrayList<BuyHistoryDto> result = null;
        if (StringUtils.isBlank((CharSequence)uid)) {
            result = new ArrayList();
        }
        result = this.orderMapper.buyHistory(uid);
        return result;
    }
}

