/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.domain.Order;
import com.ella.order.dto.OrderExample;
import com.ella.order.dto.RetCodeEnum;
import com.ella.order.dto.UpdateOrderDto;
import com.ella.order.dto.order.OrderStatusEnum;
import com.ella.order.dto.order.OrderTypeEnum;
import com.ella.order.dto.order.PayMethodEnum;
import com.ella.order.dto.order.creatorder.BaseCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.IapCreateOrderResultDto;
import com.ella.order.service.order.AbstractCreateOrderHandler;
import com.ella.order.service.order.delivery.DeliveriesFactory;
import com.ella.order.service.order.delivery.DeliveryService;
import com.ella.order.utils.ResponseParamUtils;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.account.AccountTypeEnum;
import com.ella.user.dto.account.ModifyUserEllaCoinRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IapCreateOrderHandler
extends AbstractCreateOrderHandler
implements DeliveryService.UserAccountServiceCallback {
    private static final Logger log = LogManager.getLogger(IapCreateOrderHandler.class);
    @Autowired
    private UserAccountService userAccountService;

    void sendGoods(Order order) {
        if (Objects.isNull(order) || StringUtils.isBlank((CharSequence)order.getOrderType())) {
            throw new EllaEnglishException(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg(), null);
        }
        DeliveryService deliveryService = DeliveriesFactory.getDeliveryService((OrderTypeEnum)OrderTypeEnum.getEnumByCode((String)order.getOrderType()));
        if (Objects.isNull(deliveryService)) {
            throw new EllaEnglishException(CommonRetCode.GOODS_TYPE_NOT_SUPPORT.getCode(), CommonRetCode.GOODS_TYPE_NOT_SUPPORT.getMsg(), null);
        }
        log.info(" iap DeliveryService is {}", (Object)deliveryService);
        deliveryService.sendGoods(order, (DeliveryService.UserAccountServiceCallback)this);
    }

    BaseCreateOrderResultDto afterCreateOrder(Order order) {
        IapCreateOrderResultDto dto = new IapCreateOrderResultDto();
        BeanUtils.copyProperties((Object)order, (Object)dto);
        return dto;
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Boolean> updateOrder(UpdateOrderDto req) {
        try {
            this.getDistributedLocker().lock("ORDER_LOCKER_KEY:UPDATE_LOCKER" + req.getOrderNo(), 2);
            Order query = new Order();
            query.setOrderNo(req.getOrderNo());
            query.setPayMethod(PayMethodEnum.IAP.getCode());
            List orders = this.getOrderMapper().selectByConditAndJoinOrderDetailTable(query, new OrderExample());
            if (orders == null || orders.isEmpty() || ((Order)orders.get(0)).getOrderDetails() == null || ((Order)orders.get(0)).getOrderDetails().isEmpty()) {
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ORDER_NOT_EXIST);
                return responseParams;
            }
            Order enOrder = (Order)orders.get(0);
            if (!req.getIosProductId().equals(enOrder.getExt2())) {
                log.error("\u65e0\u6548\u51ed\u8bc1\u3002\u3002\u3002req:{}", (Object)req);
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.IOS_CERT_INVALID);
                return responseParams;
            }
            Order order = new Order();
            order.setTradeNo(req.getTradeNo());
            order.setOrderStatus(req.getOrderStatus().getCode());
            Date now = Calendar.getInstance().getTime();
            order.setUpdateTime(now);
            if (OrderStatusEnum.ALREADY_PAY == req.getOrderStatus()) {
                order.setFinishTime(now);
            }
            OrderExample orderExample = new OrderExample();
            orderExample.createCriteria().andOrderNoEqualTo(req.getOrderNo()).andTradeNoNotEqualTo(req.getTradeNo()).andOrderStatusNotEqualTo(OrderStatusEnum.ALREADY_PAY.getCode());
            int count = this.getOrderMapper().updateByExampleSelective(order, orderExample);
            if (count == 0) {
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UPDATE_ORDER_STATUS_ERROR);
                return responseParams;
            }
            if (OrderStatusEnum.ALREADY_PAY == req.getOrderStatus()) {
                this.sendGoods(enOrder);
            }
        }
        catch (Exception e) {
            log.error("execute --- error:", (Throwable)e);
            if (e instanceof EllaEnglishException) {
                throw e;
            }
            throw new EllaEnglishException(RetCodeEnum.CREATE_ORDER_ERROR.getCode(), RetCodeEnum.CREATE_ORDER_ERROR.getMsg(), null);
        }
        finally {
            this.getDistributedLocker().unlock("ORDER_LOCKER_KEY:UPDATE_LOCKER" + req.getOrderNo());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public void callUserAccountService(Order order, CoinConfigDto coinConfigDto) {
        log.info("callUserAccountService -- change money start orderNo : {}", (Object)order.getOrderNo());
        ModifyUserEllaCoinRequest req = new ModifyUserEllaCoinRequest();
        req.setOrderNo(order.getOrderNo());
        req.setChangeMoney(coinConfigDto.getPrice());
        req.setChangeType(MoneyChangeTypeEnum.ADD);
        req.setTimex(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        req.setApplicableObject(AccountTypeEnum.IOS_ACCOUNT);
        req.setUid(order.getUserId());
        ResponseParams response = this.userAccountService.modifyUserEllaCoin(req);
        log.info("callUserAccountService --  change money fail :{}", (Object)response);
        if (response == null || !CommonRetCode.SUCCESS.getCode().equals(response.getCode()) || response.getData() == null || !((Boolean)response.getData()).booleanValue()) {
            throw new EllaEnglishException(response.getCode(), response.getMessage(), null);
        }
        log.info("callUserAccountService -- change money success end orderNo : {}", (Object)order.getOrderNo());
    }

    public void callUserMemberService(Order order, CoinConfigDto coinConfigDto) {
    }
}

