/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.domain.Goods;
import com.ella.order.domain.Order;
import com.ella.order.domain.OrderDetail;
import com.ella.order.dto.GoodsExample;
import com.ella.order.dto.order.creatorder.BaseCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.EllapayCreateOrderResultDto;
import com.ella.order.mapper.GoodsMapper;
import com.ella.order.mapper.OrderDetailMapper;
import com.ella.order.service.order.AbstractCreateOrderHandler;
import com.ella.resource.api.UserSendGoodsService;
import com.ella.resource.dto.sendgoods.ResTypeEnum;
import com.ella.resource.dto.sendgoods.SendGoodsToUserRequest;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EllapayCreateOrderHandler
extends AbstractCreateOrderHandler {
    private static final Logger log = LogManager.getLogger(EllapayCreateOrderHandler.class);
    @Autowired
    private UserSendGoodsService userSendGoodsService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;

    void sendGoods(Order order) {
        log.info("ellapay sendGoods :{}", (Object)order.toString());
        SendGoodsToUserRequest req = new SendGoodsToUserRequest();
        BeanUtils.copyProperties((Object)order, (Object)req);
        HashMap<String, ResTypeEnum> map = new HashMap<String, ResTypeEnum>(order.getOrderDetails().size());
        for (OrderDetail detail : order.getOrderDetails()) {
            ResTypeEnum resType;
            GoodsExample exam = new GoodsExample();
            exam.createCriteria().andGoodsCodeEqualTo(detail.getGoodsNo());
            List result = this.goodsMapper.selectByExample(exam);
            if (result == null || result.isEmpty() || (resType = ResTypeEnum.valueOf((String)((Goods)result.get(0)).getGoodsType())) == null) continue;
            map.put(((Goods)result.get(0)).getItemCode(), resType);
        }
        req.setItems(map);
        req.setUserId(order.getUserId());
        ResponseParams response = this.userSendGoodsService.sendGoodsToUser(req);
        log.info("sendGoodsToUser result:{}", (Object)response);
        if (!CommonRetCode.SUCCESS.getCode().equals(response.getCode())) {
            throw new EllaEnglishException(response.getCode(), response.getMessage(), null);
        }
    }

    BaseCreateOrderResultDto afterCreateOrder(Order order) {
        EllapayCreateOrderResultDto dto = new EllapayCreateOrderResultDto();
        BeanUtils.copyProperties((Object)order, (Object)dto);
        return dto;
    }
}

