/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.order.domain.Order;
import com.ella.order.dto.order.OrderTypeEnum;
import com.ella.order.dto.order.creatorder.AlipayCreateOrderResultDto;
import com.ella.order.dto.order.creatorder.BaseCreateOrderResultDto;
import com.ella.order.dto.pay.AliPrepayDto;
import com.ella.order.service.order.AbstractCreateOrderHandler;
import com.ella.order.service.order.delivery.DeliveriesFactory;
import com.ella.order.service.order.delivery.DeliveryService;
import com.ella.order.service.pay.InnerPayService;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.account.AccountTypeEnum;
import com.ella.user.dto.account.ModifyUserEllaCoinRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayCreateOrderHandler
extends AbstractCreateOrderHandler
implements DeliveryService.UserAccountServiceCallback {
    private static final Logger log = LogManager.getLogger(AlipayCreateOrderHandler.class);
    @Autowired
    private InnerPayService payService;
    @Autowired
    private UserAccountService userAccountService;

    void sendGoods(Order order) {
        if (Objects.isNull(order) || StringUtils.isBlank((CharSequence)order.getOrderType())) {
            throw new EllaEnglishException(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg(), null);
        }
        DeliveryService deliveryService = DeliveriesFactory.getDeliveryService((OrderTypeEnum)OrderTypeEnum.getEnumByCode((String)order.getOrderType()));
        if (Objects.isNull(deliveryService)) {
            throw new EllaEnglishException(CommonRetCode.GOODS_TYPE_NOT_SUPPORT.getCode(), CommonRetCode.GOODS_TYPE_NOT_SUPPORT.getMsg(), null);
        }
        log.info("alipay DeliveryService is {}", (Object)deliveryService);
        deliveryService.sendGoods(order, (DeliveryService.UserAccountServiceCallback)this);
    }

    BaseCreateOrderResultDto afterCreateOrder(Order order) {
        log.info("afterCreateOrder --createThirdPrePayOrder start ");
        AliPrepayDto prepayDto = (AliPrepayDto)this.payService.createThirdPrePayOrder(order);
        log.info("afterCreateOrder --createThirdPrePayOrder end ");
        AlipayCreateOrderResultDto dto = new AlipayCreateOrderResultDto();
        BeanUtils.copyProperties((Object)order, (Object)dto);
        BeanUtils.copyProperties((Object)prepayDto, (Object)dto);
        return dto;
    }

    public void callUserAccountService(Order order, CoinConfigDto coinConfigDto) {
        ModifyUserEllaCoinRequest req = new ModifyUserEllaCoinRequest();
        req.setOrderNo(order.getOrderNo());
        req.setChangeMoney(new BigDecimal(coinConfigDto.getCoin()));
        req.setChangeType(MoneyChangeTypeEnum.ADD);
        req.setTimex(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        req.setApplicableObject(AccountTypeEnum.NORMAL_ACCOUNT);
        req.setUid(order.getUserId());
        ResponseParams response = this.userAccountService.modifyUserEllaCoin(req);
        log.info("callUserAccountService response :{}", (Object)response);
        if (response == null || !CommonRetCode.SUCCESS.getCode().equals(response.getCode()) || response.getData() == null || !((Boolean)response.getData()).booleanValue()) {
            throw new EllaEnglishException(response.getCode(), response.getMessage(), null);
        }
        log.info("callUserAccountService success end orderNo : {}", (Object)order.getOrderNo());
    }

    public void callUserMemberService(Order order, CoinConfigDto coinConfigDto) {
    }
}

