/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service.order;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.frame.lock.DistributedLocker;
import com.ella.order.api.GoodsService;
import com.ella.order.domain.Order;
import com.ella.order.domain.OrderDetail;
import com.ella.order.dto.ClientTypeEnum;
import com.ella.order.dto.GoodsExample;
import com.ella.order.dto.OrderExample;
import com.ella.order.dto.RetCodeEnum;
import com.ella.order.dto.StatusEnum;
import com.ella.order.dto.UpdateOrderDto;
import com.ella.order.dto.goods.GetGoodsPricesRequest;
import com.ella.order.dto.goods.GoodsStatusEnum;
import com.ella.order.dto.goods.SummaryGoodsPriceDto;
import com.ella.order.dto.order.CreateOrderRequest;
import com.ella.order.dto.order.OrderDetailDto;
import com.ella.order.dto.order.OrderStatusEnum;
import com.ella.order.dto.order.OrderTypeEnum;
import com.ella.order.dto.order.PayMethodEnum;
import com.ella.order.dto.order.creatorder.BaseCreateOrderResultDto;
import com.ella.order.mapper.GoodsMapper;
import com.ella.order.mapper.OrderDetailMapper;
import com.ella.order.mapper.OrderMapper;
import com.ella.order.utils.MapUtils;
import com.ella.order.utils.ResponseParamUtils;
import com.ella.resource.api.EllaCoinConfigService;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCreateOrderHandler {
    private static final Logger log = LogManager.getLogger(AbstractCreateOrderHandler.class);
    @Resource(name="GoodsServiceInner")
    private GoodsService goodsService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private EllaCoinConfigService coinConfigService;
    @Autowired
    private DistributedLocker distributedLocker;
    @Autowired
    private DistributedCache distributedCache;
    @Value(value="${order.key.timeout}")
    protected int orderKeyTimeOut;

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Map<String, String>> execute(CreateOrderRequest req) {
        RetCodeEnum returnCode = this.checkRisk(req);
        if (returnCode != null) {
            return ResponseParamUtils.build((RetCodeEnum)returnCode);
        }
        returnCode = this.preCheck(req);
        if (returnCode != null) {
            log.info("execute -- preCheck error :{}{}", (Object)returnCode.getCode(), (Object)returnCode.getMsg());
            return ResponseParamUtils.build((RetCodeEnum)returnCode);
        }
        try {
            this.distributedLocker.lock("ORDER_LOCKER_KEY:CRETE_LOCK" + req.getUserId() + req.getPayMethod(), 2);
            Order order = this.createOrder(req);
            if (OrderStatusEnum.ALREADY_PAY.getCode().equals(order.getOrderStatus())) {
                this.sendGoods(order);
            }
            BaseCreateOrderResultDto result = this.afterCreateOrder(order);
            ResponseParams responseParams = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)MapUtils.java2Map((Object)result));
            return responseParams;
        }
        catch (Exception e) {
            log.error("execute --- error:", (Throwable)e);
            if (e instanceof EllaEnglishException) {
                throw e;
            }
            throw new EllaEnglishException(RetCodeEnum.CREATE_ORDER_ERROR.getCode(), RetCodeEnum.CREATE_ORDER_ERROR.getMsg(), null);
        }
        finally {
            this.distributedLocker.unlock("ORDER_LOCKER_KEY:CRETE_LOCK" + req.getUserId() + req.getPayMethod());
        }
    }

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Boolean> updateOrder(UpdateOrderDto req) {
        log.info("updateOrder --- req :{}", (Object)JSONObject.toJSONString((Object)req));
        try {
            int count;
            this.getDistributedLocker().lock("ORDER_LOCKER_KEY:UPDATE_LOCKER" + req.getOrderNo(), 2);
            Order order = new Order();
            order.setTradeNo(req.getTradeNo());
            order.setOrderStatus(req.getOrderStatus().getCode());
            Date now = Calendar.getInstance().getTime();
            order.setUpdateTime(now);
            if (OrderStatusEnum.ALREADY_PAY == req.getOrderStatus()) {
                order.setFinishTime(now);
            }
            OrderExample orderExample = new OrderExample();
            OrderExample.Criteria criteria = orderExample.createCriteria().andOrderNoEqualTo(req.getOrderNo()).andTradeNoNotEqualTo(req.getTradeNo()).andOrderStatusNotEqualTo(OrderStatusEnum.ALREADY_PAY.getCode());
            if (req.getPayAmount() != null) {
                criteria.andOrderActualEqualTo(req.getPayAmount());
            }
            if ((count = this.orderMapper.updateByExampleSelective(order, orderExample)) == 0) {
                log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u53ca\u7b2c\u4e09\u65b9\u4ea4\u6613\u6d41\u6c34\u53f7\u5931\u8d25\uff0c\u8ba2\u5355\u5df2\u5904\u7406\u6216\u8ba2\u5355\u91d1\u989d\u4e0d\u5bf9,orderNo:{},orderMoney:{}", (Object)req.getOrderNo(), (Object)req.getPayAmount().toPlainString());
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UPDATE_ORDER_STATUS_ERROR);
                return responseParams;
            }
            Order query = new Order();
            query.setOrderNo(req.getOrderNo());
            List orders = this.getOrderMapper().selectByConditAndJoinOrderDetailTable(query, new OrderExample());
            Order enOrder = (Order)orders.get(0);
            if (OrderStatusEnum.ALREADY_PAY == req.getOrderStatus()) {
                this.sendGoods(enOrder);
            }
        }
        catch (Exception e) {
            log.error("execute --- error:", (Throwable)e);
            if (e instanceof EllaEnglishException) {
                throw e;
            }
            throw new EllaEnglishException(RetCodeEnum.CREATE_ORDER_ERROR.getCode(), RetCodeEnum.CREATE_ORDER_ERROR.getMsg(), null);
        }
        finally {
            this.getDistributedLocker().unlock("ORDER_LOCKER_KEY:UPDATE_LOCKER" + req.getOrderNo());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    abstract void sendGoods(Order var1);

    abstract BaseCreateOrderResultDto afterCreateOrder(Order var1);

    protected Order createOrder(CreateOrderRequest req) {
        Order order = this.buildOrder(req);
        List orderDetails = this.buildOrderDetail(req, order);
        this.orderMapper.insert(order);
        this.orderDetailMapper.batchInsert(orderDetails);
        return order;
    }

    protected RetCodeEnum checkRisk(CreateOrderRequest req) {
        return null;
    }

    private RetCodeEnum preCheck(CreateOrderRequest req) {
        int count;
        if (ClientTypeEnum.getEnumByCode((String)req.getClientType().toUpperCase()) == null) {
            return RetCodeEnum.CLIENT_TYPE_IS_NOT_SUPPORT;
        }
        String flag = this.distributedCache.get("ORDER_CREATE_KEY:CREATE_CHECK" + req.getUserId() + req.getPayMethod());
        if (StringUtils.isNotEmpty((CharSequence)flag)) {
            return RetCodeEnum.CREATE_ORDER_REPEAT_ERROR;
        }
        this.distributedCache.set("ORDER_CREATE_KEY:CREATE_CHECK" + req.getUserId() + req.getPayMethod(), (Object)"true", this.orderKeyTimeOut);
        List list = req.getOrderDetails();
        if (list.isEmpty()) {
            return RetCodeEnum.CREATE_ORDER_PARAM_ERROR;
        }
        ArrayList<String> goodsCodes = new ArrayList<String>();
        for (OrderDetailDto dto : list) {
            goodsCodes.add(dto.getGoodsNo());
        }
        GoodsExample example = new GoodsExample();
        example.createCriteria().andGoodsCodeIn(goodsCodes).andGoodsStateEqualTo(GoodsStatusEnum.SALING.getCode()).andStatusEqualTo(StatusEnum.NORMAL.getCode());
        List result = this.goodsMapper.selectByExample(example);
        if (result == null || result.isEmpty() || goodsCodes.size() != result.size()) {
            log.info("preCheck --- \u5546\u54c1\u4e0d\u5b58\u5728 \u6216 \u72b6\u6001\u65e0\u6548 ");
            return RetCodeEnum.CREATE_ORDER_PARAM_ERROR;
        }
        if ("ELLA_COIN".equals(req.getPayMethod()) && (count = this.orderDetailMapper.isAlreadyBuy(goodsCodes, req.getUserId())) > 0) {
            return RetCodeEnum.GOODS_REPEAT_BUY;
        }
        return null;
    }

    protected Order buildOrder(CreateOrderRequest req) {
        Date now = Calendar.getInstance().getTime();
        Order order = new Order();
        BeanUtils.copyProperties((Object)req, (Object)order);
        long id = IdWrokerUtils.nextId();
        order.setId(Long.valueOf(id));
        order.setCreateBy(req.getUserId());
        order.setUpdateBy(req.getUserId());
        order.setOrderNo("ENO" + id);
        order.setCreateTime(now);
        order.setUpdateTime(now);
        order.setReqIp(req.getIp());
        order.setTradeNo("");
        if (PayMethodEnum.ELLA_COIN.getCode().equals(order.getPayMethod())) {
            order.setOrderStatus(OrderStatusEnum.ALREADY_PAY.getCode());
            order.setFinishTime(now);
        } else {
            order.setOrderStatus(OrderStatusEnum.WAIT_PAY.getCode());
        }
        order.setStatus(StatusEnum.NORMAL.getCode());
        return order;
    }

    protected List<OrderDetail> buildOrderDetail(CreateOrderRequest req, Order order) {
        ArrayList<String> goodsCodes = new ArrayList<String>();
        HashMap<String, OrderDetailDto> detailDtosMap = new HashMap<String, OrderDetailDto>(req.getOrderDetails().size());
        for (OrderDetailDto dto : req.getOrderDetails()) {
            goodsCodes.add(dto.getGoodsNo());
            detailDtosMap.put(dto.getGoodsNo(), dto);
        }
        GetGoodsPricesRequest priceReq = new GetGoodsPricesRequest();
        priceReq.setGoodsCodes(goodsCodes);
        List prices = (List)this.goodsService.getGoodsPricesByCondit(priceReq).getData();
        if (OrderTypeEnum.ELLA_COIN.getCode().equals(order.getOrderType()) || OrderTypeEnum.MAP_MEMBER.getCode().equals(order.getOrderType())) {
            GetEllaCoinListByConditRequest coinReq = new GetEllaCoinListByConditRequest();
            ArrayList<String> list = new ArrayList<String>();
            list.add(((SummaryGoodsPriceDto)prices.get(0)).getItemCode());
            coinReq.setCoinCodes(list);
            ResponseParams coinList = this.coinConfigService.getEllaCoinConfigListByCondit(coinReq);
            if (coinList.getData() == null || ((List)coinList.getData()).isEmpty()) {
                throw new EllaEnglishException(RetCodeEnum.CREATE_ORDER_THIRDPAY_NOT_SUPPORT_GOOD.getCode(), RetCodeEnum.CREATE_ORDER_THIRDPAY_NOT_SUPPORT_GOOD.getMsg(), null);
            }
            order.setExt1(((CoinConfigDto)((List)coinList.getData()).get(0)).getCoinCode());
            order.setExt2(((CoinConfigDto)((List)coinList.getData()).get(0)).getIosPriceCode());
        }
        BigDecimal goodsPrices = new BigDecimal("0");
        BigDecimal goodsActualPrices = new BigDecimal("0");
        int goodsTotalNum = 0;
        ArrayList<OrderDetail> list = new ArrayList<OrderDetail>();
        for (SummaryGoodsPriceDto price : prices) {
            OrderDetailDto detailDto = (OrderDetailDto)detailDtosMap.get(price.getGoodsCode());
            goodsTotalNum += detailDto.getGoodsNum().intValue();
            BigDecimal itemGoodsNum = new BigDecimal(detailDto.getGoodsNum());
            goodsPrices = goodsPrices.add(price.getGoodsPrice().multiply(itemGoodsNum));
            goodsActualPrices = goodsActualPrices.add(price.getGoodsActualPrice().multiply(itemGoodsNum));
            OrderDetail detail = new OrderDetail();
            detail.setOrderNo(order.getOrderNo());
            detail.setId(Long.valueOf(IdWrokerUtils.nextId()));
            detail.setGoodsName(price.getGoodsName());
            BeanUtils.copyProperties((Object)detailDto, (Object)detail);
            detail.setStatus(StatusEnum.NORMAL.getCode());
            detail.setCreateBy(order.getCreateBy());
            detail.setUpdateBy(order.getUpdateBy());
            detail.setCreateTime(order.getCreateTime());
            detail.setUpdateTime(order.getUpdateTime());
            list.add(detail);
        }
        order.setOrderMoney(goodsPrices);
        order.setOrderActual(goodsActualPrices);
        order.setGoodNum(Integer.valueOf(goodsTotalNum));
        order.setOrderDetails(list);
        return list;
    }

    protected OrderMapper getOrderMapper() {
        return this.orderMapper;
    }

    protected GoodsMapper getGoodsMapper() {
        return this.goodsMapper;
    }

    protected OrderDetailMapper getOrderDetailMapper() {
        return this.orderDetailMapper;
    }

    protected int getOrderKeyTimeOut() {
        return this.orderKeyTimeOut;
    }

    protected GoodsService getGoodsService() {
        return this.goodsService;
    }

    protected EllaCoinConfigService getCoinConfigService() {
        return this.coinConfigService;
    }

    protected void setCoinConfigService(EllaCoinConfigService coinConfigService) {
        this.coinConfigService = coinConfigService;
    }

    protected DistributedLocker getDistributedLocker() {
        return this.distributedLocker;
    }

    protected void setDistributedLocker(DistributedLocker distributedLocker) {
        this.distributedLocker = distributedLocker;
    }

    protected DistributedCache getDistributedCache() {
        return this.distributedCache;
    }

    protected void setDistributedCache(DistributedCache distributedCache) {
        this.distributedCache = distributedCache;
    }
}

