/*
 * Decompiled with CFR 0.152.
 */
package com.ella.order.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.OrderUtil;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.order.api.GoodsService;
import com.ella.order.domain.Goods;
import com.ella.order.dto.GoodsExample;
import com.ella.order.dto.ResponsePageResult;
import com.ella.order.dto.RetCodeEnum;
import com.ella.order.dto.StatusEnum;
import com.ella.order.dto.goods.BookDto;
import com.ella.order.dto.goods.EllaCoinDto;
import com.ella.order.dto.goods.GetBookGoodsListByPageRequest;
import com.ella.order.dto.goods.GetGoodsDetailByItemCodeAndTypeRequest;
import com.ella.order.dto.goods.GetGoodsDetailRequest;
import com.ella.order.dto.goods.GetGoodsListByPageRequest;
import com.ella.order.dto.goods.GetGoodsListRequest;
import com.ella.order.dto.goods.GetGoodsPricesRequest;
import com.ella.order.dto.goods.GetMissionOfMapTotalByItemCode;
import com.ella.order.dto.goods.GetSupportPayTypeByGoodsCodeRequest;
import com.ella.order.dto.goods.GoodsDto;
import com.ella.order.dto.goods.GoodsFullDto;
import com.ella.order.dto.goods.GoodsStatusEnum;
import com.ella.order.dto.goods.GoodsTypeEnum;
import com.ella.order.dto.goods.ModifyGoodsRequest;
import com.ella.order.dto.goods.ModifyGoodsStatusRequest;
import com.ella.order.dto.goods.RemoveGoodsRequest;
import com.ella.order.dto.goods.SaveGoodsRequest;
import com.ella.order.dto.goods.SummaryGoodsPriceDto;
import com.ella.order.mapper.GoodsMapper;
import com.ella.order.service.GoodsServiceImpl;
import com.ella.order.utils.ResponsePageResultUtils;
import com.ella.order.utils.ResponseParamUtils;
import com.ella.order.utils.ValidationUtils;
import com.ella.resource.api.EllaCoinConfigService;
import com.ella.resource.api.MissionService;
import com.ella.resource.api.PicBookService;
import com.ella.resource.api.ResOccupantService;
import com.ella.resource.dto.PictureBookDto;
import com.ella.resource.dto.SaveResOccupantRequest;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import com.ella.resource.dto.missiondto.MissionDto;
import com.ella.resource.dto.request.DeleteResOccupantRequest;
import com.ella.resource.dto.request.ModifyResOccupantRequest;
import com.ella.resource.dto.request.picturebook.GetPicBooksByCodeRequest;
import com.ella.resource.dto.sendgoods.ResTypeEnum;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.account.AccountDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Service(value="GoodsServiceInner")
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LogManager.getLogger(GoodsServiceImpl.class);
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MissionService missonService;
    @Autowired
    private EllaCoinConfigService coinConfigService;
    @Autowired
    private ResOccupantService occupantService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private PicBookService bookService;
    @Autowired
    private DistributedCache redisCache;

    public ResponseParams<ResponsePageResult<List<GoodsDto>>> getGoodsListByPage(@RequestBody GetGoodsListByPageRequest req) {
        log.info("getGoodsListByPage req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getGoodsListByPage param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        GoodsExample exam = new GoodsExample();
        exam.setOrderByClause("update_time desc");
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        List list = this.goodsMapper.selectByConditAndExample(query, exam);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build(null));
        }
        ArrayList<GoodsDto> result = new ArrayList<GoodsDto>();
        for (Goods good : list) {
            GoodsDto dto = new GoodsDto();
            BeanUtils.copyProperties((Object)good, (Object)dto);
            result.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((PageInfo)new PageInfo(list), result));
    }

    @EnableValidate
    public ResponseParams<ResponsePageResult<List<GoodsFullDto>>> getBookGoodsListByPage(@RequestBody GetBookGoodsListByPageRequest req) {
        log.info("getBookGoodsListByPage -- req : {}", (Object)req);
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        GoodsExample exam = new GoodsExample();
        GoodsExample.Criteria crit = exam.createCriteria();
        crit.andStatusEqualTo(StatusEnum.NORMAL.getCode());
        crit.andGoodsTypeEqualTo(GoodsTypeEnum.BOOK.getCode());
        exam.setOrderByClause(" create_time desc");
        PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
        List list = this.goodsMapper.selectByConditAndExample(query, exam);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build(null));
        }
        ArrayList<GoodsFullDto> result = new ArrayList<GoodsFullDto>();
        HashMap<String, GoodsFullDto> map = new HashMap<String, GoodsFullDto>(list.size());
        for (Goods good : list) {
            GoodsFullDto dto = new GoodsFullDto();
            BeanUtils.copyProperties((Object)good, (Object)dto);
            result.add(dto);
            map.put(good.getItemCode(), dto);
        }
        GetPicBooksByCodeRequest picReq = new GetPicBooksByCodeRequest();
        picReq.setPicBookCodes(new ArrayList(map.keySet()));
        ResponseParams books = this.bookService.getPicBooksByCode(picReq);
        if (books == null || books.getData() == null) {
            map = null;
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)list, result));
        }
        for (PictureBookDto rBookDto : (List)books.getData()) {
            GoodsFullDto goodsFullDto = (GoodsFullDto)map.get(rBookDto.getPicBookCode());
            BookDto bookDto = new BookDto();
            BeanUtils.copyProperties((Object)rBookDto, (Object)bookDto);
            goodsFullDto.setBook(bookDto);
        }
        map = null;
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((PageInfo)new PageInfo(list), result));
    }

    public ResponseParams<GoodsDto> getGoodsDetail(@RequestBody GetGoodsDetailRequest req) {
        log.info("getGoodsDetail req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getGoodsDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByCondit(query);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        GoodsDto goods = new GoodsDto();
        BeanUtils.copyProperties(list.get(0), (Object)goods);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)goods);
    }

    public ResponseParams<List<GoodsDto>> getGoodsList(@RequestBody GetGoodsListRequest req) {
        log.info("getGoodsListByPage req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getGoodsListByPage param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setGoodsState(GoodsStatusEnum.SALING.getCode());
        query.setStatus(StatusEnum.NORMAL.getCode());
        PageHelper.startPage((int)1, (int)200);
        List list = this.goodsMapper.selectByCondit(query);
        if (list == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        ArrayList<GoodsDto> result = new ArrayList<GoodsDto>();
        for (Goods good : list) {
            GoodsDto dto = new GoodsDto();
            BeanUtils.copyProperties((Object)good, (Object)dto);
            result.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Boolean> saveGoods(@RequestBody SaveGoodsRequest req) {
        log.info("saveGoods req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("saveGoods param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (!this.checkIsExist(req)) {
            log.info("saveGoods  error,{}", (Object)RetCodeEnum.GOODS_ALREADY_EXISTS.getMsg());
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.GOODS_ALREADY_EXISTS);
        }
        Goods goods = this.buildGoodsInf(req);
        this.goodsMapper.insert(goods);
        this.saveResOccuRec(goods);
        String redisKey = "BOE:GOODS:BOOK:EN:" + req.getItemCode();
        this.redisCache.del(redisKey);
        this.redisCache.incr("free_goods_version");
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public ResponseParams<Boolean> modifyGoods(@RequestBody ModifyGoodsRequest req) {
        log.info("modifyGoods req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("modifyGoods param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        GoodsExample goodsExample = new GoodsExample();
        goodsExample.createCriteria().andGoodsCodeEqualTo(req.getGoodsCode());
        List list = this.goodsMapper.selectByExample(goodsExample);
        if (list == null || list.isEmpty()) {
            log.info("modifyGoods --- \u5546\u54c1\u4e0d\u5b58\u5728,goodsCode :{}", (Object)req.getGoodsCode());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods goods = (Goods)list.get(0);
        BeanUtils.copyProperties((Object)req, (Object)goods);
        goods.setUpdateBy(req.getUserId());
        Date now = Calendar.getInstance().getTime();
        goods.setUpdateTime(now);
        this.goodsMapper.updateByPrimaryKey(goods);
        if (StringUtils.isNotEmpty((CharSequence)req.getItemCode())) {
            this.modifyResOccuRec(req);
        }
        String redisKey = "BOE:GOODS:BOOK:EN:" + req.getItemCode();
        this.redisCache.del(redisKey);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public ResponseParams<Boolean> modifyGoodsState(@RequestBody ModifyGoodsStatusRequest req) {
        log.info("modifyGoodsState req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("modifyGoodsState param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        GoodsStatusEnum stateEnum = GoodsStatusEnum.getEnumByCode((String)req.getGoodsState());
        if (Objects.isNull(stateEnum)) {
            log.info("modifyGoodsState param error, \u4e0d\u652f\u6301\u7684\u5546\u54c1\u72b6\u6001 {}", (Object)req.getGoodsState());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (!GoodsStatusEnum.SALING.getCode().equals(req.getGoodsState()) && !GoodsStatusEnum.OVER_SALE.getCode().equals(req.getGoodsState())) {
            log.info("modifyGoodsState param error, \u4e0d\u652f\u6301\u7684\u5546\u54c1\u72b6\u6001 {}", (Object)req.getGoodsState());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)goods);
        goods.setGoodsCode(null);
        goods.setUpdateBy(req.getUserId());
        Date now = Calendar.getInstance().getTime();
        goods.setUpdateTime(now);
        GoodsExample goodsExample = new GoodsExample();
        goodsExample.createCriteria().andGoodsCodeEqualTo(req.getGoodsCode()).andGoodsStateNotEqualTo(req.getGoodsState());
        this.goodsMapper.updateByExampleSelective(goods, goodsExample);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    public ResponseParams<Boolean> removeGoods(@RequestBody RemoveGoodsRequest req) {
        log.info("modifyGoodsState req :{}", (Object)req);
        String checkResult = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("modifyGoodsState param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Goods goods = new Goods();
        goods.setGoodsCode(null);
        goods.setStatus(StatusEnum.DELETE.getCode());
        goods.setUpdateBy(req.getUserId());
        Date now = Calendar.getInstance().getTime();
        goods.setUpdateTime(now);
        GoodsExample goodsExample = new GoodsExample();
        goodsExample.createCriteria().andGoodsCodeEqualTo(req.getGoodsCode());
        this.goodsMapper.updateByExampleSelective(goods, goodsExample);
        this.deleteResOccuRec(req.getGoodsCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private boolean checkIsExist(SaveGoodsRequest req) {
        if (!(GoodsTypeEnum.MAP.getCode().equals(req.getGoodsType()) || GoodsTypeEnum.MESSION.getCode().equals(req.getGoodsType()) || GoodsTypeEnum.BOOK.getCode().equals(req.getGoodsType()))) {
            return true;
        }
        Goods query = new Goods();
        query.setItemCode(req.getItemCode());
        query.setStatus(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByCondit(query);
        return list == null || list.isEmpty();
    }

    private Goods buildGoodsInf(SaveGoodsRequest req) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)goods);
        goods.setId(Long.valueOf(IdWrokerUtils.nextId()));
        goods.setGoodsCode(OrderUtil.createNo((String)"G", (Integer)4));
        goods.setGoodsState(GoodsStatusEnum.WAIT_SALE.getCode());
        goods.setStatus(StatusEnum.NORMAL.getCode());
        if (req.getGiveLessonPrice() != null && req.getTeachingMaterialPrice() != null) {
            goods.setGoodsPrice(req.getGiveLessonPrice().add(req.getTeachingMaterialPrice()));
        }
        goods.setCreateBy(req.getUserId());
        goods.setUpdateBy(req.getUserId());
        Date now = Calendar.getInstance().getTime();
        goods.setCreateTime(now);
        goods.setUpdateTime(now);
        return goods;
    }

    @EnableValidate
    public ResponseParams<GoodsFullDto> getGoodsDetailByItemCodeAndType(@RequestBody GetGoodsDetailByItemCodeAndTypeRequest req) {
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setGoodsState(StatusEnum.NORMAL.getCode());
        GoodsExample example = new GoodsExample();
        List list = this.goodsMapper.selectByExample(example);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        Goods goods = (Goods)list.get(0);
        if (GoodsStatusEnum.WAIT_SALE.getCode().equals(goods.getGoodsState()) || GoodsStatusEnum.PRE_SALE.getCode().equals(goods.getGoodsState())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        GoodsFullDto dto = new GoodsFullDto();
        BeanUtils.copyProperties((Object)goods, (Object)dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    @EnableValidate
    public ResponseParams<String> getSupportPayTypeByGoodsCode(@RequestBody GetSupportPayTypeByGoodsCodeRequest req) {
        log.info("getSupportPayTypeByGoodsCode req :{}", (Object)req);
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByCondit(query);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        Goods goods = (Goods)list.get(0);
        if (GoodsStatusEnum.WAIT_SALE.getCode().equals(goods.getGoodsState()) || GoodsStatusEnum.PRE_SALE.getCode().equals(goods.getGoodsState())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)goods.getSupportPayType());
    }

    @EnableValidate
    public ResponseParams<SummaryGoodsPriceDto> getSummrayGoodsByItemCodeAndType(@RequestBody GetGoodsDetailByItemCodeAndTypeRequest req) {
        log.info("getSummrayGoodsByItemCodeAndType --- req:{}", (Object)req);
        Goods query = new Goods();
        BeanUtils.copyProperties((Object)req, (Object)query);
        query.setStatus(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByCondit(query);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        Goods goods = (Goods)list.get(0);
        if (GoodsStatusEnum.WAIT_SALE.getCode().equals(goods.getGoodsState()) || GoodsStatusEnum.PRE_SALE.getCode().equals(goods.getGoodsState())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        SummaryGoodsPriceDto dto = this.caculateGoodsPrice(goods);
        if (req.getUid() == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
        }
        AccountDto accountDto = this.userAccountService.queryUserEllaCoin(req.getUid());
        BeanUtils.copyProperties((Object)accountDto, (Object)dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    private BigDecimal caculateMessionOfMapTotalPriceAndCount(String itemCode, SummaryGoodsPriceDto priceDto) {
        ResponseParams result = this.missonService.getMissionListByMapCode(itemCode);
        if (result == null || !CommonRetCode.SUCCESS.getCode().equals(result.getCode()) || result.getData() == null || ((List)result.getData()).isEmpty()) {
            priceDto.setNeedBuymissionOfMap(Integer.valueOf(0));
            priceDto.setMessionOfMapTotal(new BigDecimal(0));
            log.info("caculateMessionOfMapTotalPrice -- getMissionList result :{}", (Object)result);
            return new BigDecimal(0);
        }
        ArrayList<String> missionList = new ArrayList<String>();
        for (MissionDto dto : (List)result.getData()) {
            missionList.add(dto.getMissionCode());
        }
        GoodsExample example = new GoodsExample();
        example.createCriteria().andItemCodeIn(missionList).andGoodsTypeEqualTo(GoodsTypeEnum.MESSION.getCode()).andGoodsStateEqualTo(GoodsStatusEnum.SALING.getCode()).andStatusEqualTo(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByExample(example);
        if (list == null || list.isEmpty()) {
            priceDto.setNeedBuymissionOfMap(Integer.valueOf(0));
            return new BigDecimal(0);
        }
        BigDecimal bigDecimal = new BigDecimal("0");
        for (Goods good : list) {
            bigDecimal = bigDecimal.add(good.getGoodsPrice());
        }
        priceDto.setNeedBuymissionOfMap(Integer.valueOf(list.size()));
        return bigDecimal;
    }

    @EnableValidate
    public ResponseParams<String> getMissionOfMapTotal(@RequestBody GetMissionOfMapTotalByItemCode req) {
        log.info("getMissionOfMapTotal --- req : {} ", (Object)req);
        BigDecimal result = this.caculateMessionOfMapTotalPriceAndCount(req.getItemCode(), new SummaryGoodsPriceDto());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result.toPlainString());
    }

    @EnableValidate
    public ResponseParams<List<SummaryGoodsPriceDto>> getGoodsPricesByCondit(@RequestBody GetGoodsPricesRequest req) {
        GoodsExample query = new GoodsExample();
        query.createCriteria().andGoodsCodeIn(req.getGoodsCodes()).andGoodsStateEqualTo(GoodsStatusEnum.SALING.getCode()).andStatusEqualTo(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByExample(query);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        ArrayList<SummaryGoodsPriceDto> results = new ArrayList<SummaryGoodsPriceDto>();
        for (Goods goods : list) {
            SummaryGoodsPriceDto dto = new SummaryGoodsPriceDto();
            BeanUtils.copyProperties((Object)goods, (Object)dto);
            dto.setGoodsActualPrice(goods.getGoodsPrice());
            if (this.checkPromotPrice(goods).booleanValue()) {
                dto.setGoodsPrice(goods.getGoodsPromotPrice());
                dto.setGoodsActualPrice(goods.getGoodsPromotPrice());
            }
            results.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, results);
    }

    private Boolean checkPromotPrice(Goods goods) {
        if (Objects.isNull(goods.getGoodsPromotPrice())) {
            return false;
        }
        if (Objects.isNull(goods.getGoodsPromotTimeStart()) || Objects.isNull(goods.getGoodsPromotTimeEnd())) {
            return false;
        }
        if (!DateUtil.isEffectiveDate((Date)new Date(), (Date)goods.getGoodsPromotTimeStart(), (Date)goods.getGoodsPromotTimeEnd())) {
            return false;
        }
        return true;
    }

    public ResponseParams<List<EllaCoinDto>> getGoodsOfEllaCoinList(String goodsType) {
        GoodsExample exam = new GoodsExample();
        exam.createCriteria().andGoodsTypeEqualTo(goodsType).andGoodsStateEqualTo(GoodsStatusEnum.SALING.getCode()).andStatusEqualTo(StatusEnum.NORMAL.getCode());
        List list = this.goodsMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        HashMap<String, Goods> goodsMap = new HashMap<String, Goods>(list.size());
        for (Goods good : list) {
            goodsMap.put(good.getItemCode(), good);
        }
        GetEllaCoinListByConditRequest req = new GetEllaCoinListByConditRequest();
        req.setCoinCodes(new ArrayList(goodsMap.keySet()));
        ResponseParams coinList = this.coinConfigService.getEllaCoinConfigListByCondit(req);
        if (coinList.getData() == null || ((List)coinList.getData()).isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        ArrayList<EllaCoinDto> coinDtos = new ArrayList<EllaCoinDto>();
        for (CoinConfigDto configDto : (List)coinList.getData()) {
            Goods goods = (Goods)goodsMap.get(configDto.getCoinCode());
            SummaryGoodsPriceDto priceDto = this.caculateGoodsPrice(goods);
            EllaCoinDto dto = new EllaCoinDto();
            BeanUtils.copyProperties((Object)configDto, (Object)dto);
            dto.setGoodsCode(((Goods)goodsMap.get(configDto.getCoinCode())).getGoodsCode());
            dto.setGoodsPrice(priceDto.getGoodsPrice());
            dto.setGoodsActualPrice(priceDto.getGoodsActualPrice());
            coinDtos.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, coinDtos);
    }

    public ResponseParams<List<EllaCoinDto>> getGoodsOfVipCardConfigList(String goodsType) {
        if (StringUtils.isBlank((CharSequence)goodsType) || !"VIP_MEMBER".equals(goodsType)) {
            log.info("getGoodsOfVipCardConfigList param error,{}", (Object)goodsType);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        HashMap dataMap = new HashMap(1);
        String redisKey = "BOE:GOODS:BOOK:EN:" + goodsType;
        String cacheData = this.redisCache.get(redisKey);
        if (StringUtils.isNotBlank((CharSequence)cacheData)) {
            JSONObject dataCache = JSONObject.parseObject((String)cacheData);
            String vipCard = dataCache.get((Object)"vipCard").toString();
            List ellaCoinDtos = JSONObject.parseArray((String)vipCard, EllaCoinDto.class);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ellaCoinDtos);
        }
        List goodsList = this.goodsMapper.selectVipAndLexileGoods();
        if (goodsList == null || goodsList.size() == 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        Map<String, List<Goods>> goodsMap = goodsList.stream().collect(Collectors.groupingBy(Goods::getItemCode));
        String itemCodeStr = goodsList.stream().map(Goods::getItemCode).collect(Collectors.joining(";"));
        ResponseParams coinList = this.coinConfigService.getVipCardConfigByItemCode(itemCodeStr);
        if (coinList.getData() == null || ((List)coinList.getData()).size() == 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        List coinConfigDtoList = (List)coinList.getData();
        ArrayList dataList = new ArrayList();
        coinConfigDtoList.stream().forEach(configDto -> {
            List goods = (List)goodsMap.get(configDto.getCoinCode());
            EllaCoinDto ellaCoinDto = new EllaCoinDto();
            BeanUtils.copyProperties((Object)configDto, (Object)ellaCoinDto);
            ellaCoinDto.setGoodsCode(((Goods)goods.get(0)).getGoodsCode());
            ellaCoinDto.setGoodsPrice(((Goods)goods.get(0)).getGoodsPrice());
            dataList.add(ellaCoinDto);
        });
        dataMap.put("vipCard", dataList);
        this.redisCache.set(redisKey, (Object)JSONObject.toJSONString(dataMap));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, dataList);
    }

    private void saveResOccuRec(Goods goods) {
        SaveResOccupantRequest req = new SaveResOccupantRequest();
        req.setOccuType("GOODS");
        GoodsTypeEnum type = GoodsTypeEnum.getEnumByCode((String)goods.getGoodsType());
        switch (1.$SwitchMap$com$ella$order$dto$goods$GoodsTypeEnum[type.ordinal()]) {
            case 1: {
                req.setResType(ResTypeEnum.MAP);
                break;
            }
            case 2: {
                req.setResType(ResTypeEnum.MISSION);
                break;
            }
            case 3: {
                req.setResType(ResTypeEnum.PICTUREBOOK);
                break;
            }
            case 4: {
                req.setResType(ResTypeEnum.ELLA_COIN);
                break;
            }
            default: {
                return;
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        map.put(goods.getItemCode(), goods.getId());
        req.setResIds(map);
        this.occupantService.saveResOccupant(req);
    }

    private void modifyResOccuRec(ModifyGoodsRequest req) {
        GoodsExample exam = new GoodsExample();
        exam.createCriteria().andGoodsCodeEqualTo(req.getGoodsCode());
        List list = this.goodsMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return;
        }
        ModifyResOccupantRequest resReq = new ModifyResOccupantRequest();
        resReq.setOccupantType("GOODS");
        resReq.setOccupantId(((Goods)list.get(0)).getId());
        resReq.setResCode(req.getItemCode());
        this.occupantService.modifyResOccupant(resReq);
    }

    private void deleteResOccuRec(String goodCode) {
        GoodsExample exam = new GoodsExample();
        exam.createCriteria().andGoodsCodeEqualTo(goodCode);
        List list = this.goodsMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return;
        }
        DeleteResOccupantRequest resReq = new DeleteResOccupantRequest();
        resReq.setOccupantType("GOODS");
        resReq.setOccupantId(((Goods)list.get(0)).getId());
        this.occupantService.deleteResOccupant(resReq);
    }

    private SummaryGoodsPriceDto caculateGoodsPrice(Goods goods) {
        SummaryGoodsPriceDto dto = new SummaryGoodsPriceDto();
        BeanUtils.copyProperties((Object)goods, (Object)dto);
        if (GoodsTypeEnum.MAP.getCode().equals(goods.getGoodsType())) {
            BigDecimal totalPrice = this.caculateMessionOfMapTotalPriceAndCount(goods.getItemCode(), dto);
            dto.setMessionOfMapTotal(totalPrice);
        }
        dto.setGoodsActualPrice(goods.getGoodsPrice());
        return dto;
    }
}

