/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.common.api.dictionary.YoudaoService;
import com.ella.common.configure.AliOss;
import com.ella.common.configure.YouDaoConfig;
import com.ella.common.domain.Dictionary;
import com.ella.common.domain.DictionaryExample;
import com.ella.common.domain.DictionarySentence;
import com.ella.common.domain.DictionarySentenceExample;
import com.ella.common.domain.YoudaoApiCallFlow;
import com.ella.common.dto.StatusEnum;
import com.ella.common.dto.dictionary.DetailDto;
import com.ella.common.dto.dictionary.DictionaryDto;
import com.ella.common.dto.dictionary.GetEnToCnTranslateRequest;
import com.ella.common.dto.dictionary.TranslateResultDto;
import com.ella.common.mapper.DictionaryMapper;
import com.ella.common.mapper.DictionarySentenceMapper;
import com.ella.common.mapper.YoudaoApiCallFlowMapper;
import com.ella.common.utils.ResponseBuildUtil;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class YoudaoServiceImpl
implements YoudaoService {
    private static final Logger log = LogManager.getLogger(YoudaoServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private YouDaoConfig config;
    @Autowired
    private YoudaoApiCallFlowMapper youdaoMapper;
    @Autowired
    private DictionaryMapper dictMapper;
    @Autowired
    private DictionarySentenceMapper dictionarySentenceMapper;
    @Autowired
    private AliOss aliOss;

    @EnableValidate
    public ResponseParams<DictionaryDto> getEnToCnTranslate(@RequestBody GetEnToCnTranslateRequest req) {
        log.info("getEnToCnTranslate --- req:{}", (Object)req);
        DictionaryDto dictionaryDto = this.getFromInDict(req.getWordText());
        if (dictionaryDto != null) {
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dictionaryDto);
        }
        MultiValueMap map = this.buildFormData(req);
        log.info("getEnToCnTranslate - form Data :{}", JSONObject.toJSON((Object)map));
        try {
            String resultDtoStr = this.postFormData(this.config.getUrl(), map);
            log.info("getEnToCnTranslate response:{}", (Object)resultDtoStr);
            if (resultDtoStr == null) {
                return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
            }
            TranslateResultDto resultDto = (TranslateResultDto)JSONObject.parseObject((String)resultDtoStr, TranslateResultDto.class);
            this.recordFlow(resultDto, resultDtoStr);
            if (Objects.isNull(resultDto.getBasic())) {
                return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.doSentence(resultDto));
            }
            this.downLoadAudio(resultDto);
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.saveDict(resultDto));
        }
        catch (Exception e) {
            log.error("getEnToCnTranslate ---error:", (Throwable)e);
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
        }
    }

    private DictionaryDto doSentence(TranslateResultDto resultDto) throws Exception {
        CloseableHttpResponse data;
        DictionarySentence dictionarySentence = new DictionarySentence();
        dictionarySentence.setCreateTime(new Date());
        dictionarySentence.setSentence(resultDto.getQuery());
        dictionarySentence.setSentenceDesc((String)resultDto.getTranslation().get(0));
        if (StringUtils.isNotEmpty((CharSequence)resultDto.getTSpeakUrl())) {
            data = this.getAudioData(resultDto.getTSpeakUrl());
            dictionarySentence.setSpeechUrl(this.uploadToOss(data));
        }
        if (StringUtils.isNotEmpty((CharSequence)resultDto.getSpeakUrl())) {
            data = this.getAudioData(resultDto.getSpeakUrl());
            dictionarySentence.setEnSpeechUrl(this.uploadToOss(data));
        }
        this.dictionarySentenceMapper.insertSelective(dictionarySentence);
        return this.getDictionaryDtoFromSentences(dictionarySentence);
    }

    private DictionaryDto saveDict(TranslateResultDto resultDto) {
        Dictionary dict = new Dictionary();
        BeanUtils.copyProperties((Object)resultDto, (Object)dict);
        if (resultDto.getBasic() != null) {
            BeanUtils.copyProperties((Object)resultDto.getBasic(), (Object)dict);
        }
        dict.setWordDesc(JSONObject.toJSONString((Object)resultDto.getTranslation()));
        if (null != resultDto.getBasic() && resultDto.getBasic().getExplains() != null) {
            dict.setExplains(JSONObject.toJSONString((Object)resultDto.getBasic().getExplains()));
        }
        dict.setInitial(resultDto.getQuery().substring(0, 1).toUpperCase());
        Date now = Calendar.getInstance().getTime();
        dict.setCreateTime(now);
        dict.setUpdateTime(now);
        dict.setStatus(StatusEnum.NORMAL.getCode());
        dict.setWord(resultDto.getQuery());
        this.dictMapper.insertSelective(dict);
        DictionaryDto dto = new DictionaryDto();
        BeanUtils.copyProperties((Object)dict, (Object)dto);
        return dto;
    }

    private DictionaryDto getFromInDict(String word) {
        DictionaryExample exam = new DictionaryExample();
        exam.createCriteria().andWordEqualTo(word).andStatusEqualTo("NORMAL");
        List list = this.dictMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return this.getFromInDictSentence(word);
        }
        DictionaryDto dto = new DictionaryDto();
        BeanUtils.copyProperties(list.get(0), (Object)dto);
        return dto;
    }

    private DictionaryDto getFromInDictSentence(String word) {
        List dictionarySentences = this.selectBySentences(word);
        if (CollectionUtils.isEmpty((Collection)dictionarySentences)) {
            return null;
        }
        return this.getDictionaryDtoFromSentences((DictionarySentence)dictionarySentences.get(0));
    }

    private DictionaryDto getDictionaryDtoFromSentences(DictionarySentence dictionarySentence) {
        DictionaryDto dto = new DictionaryDto();
        dto.setWord(dictionarySentence.getSentence());
        dto.setWordDesc(dictionarySentence.getSentenceDesc());
        dto.setUsSpeech(dictionarySentence.getEnSpeechUrl());
        dto.setUkSpeech(dictionarySentence.getSpeechUrl());
        return dto;
    }

    private List<DictionarySentence> selectBySentences(String sentences) {
        DictionarySentenceExample example = new DictionarySentenceExample();
        example.createCriteria().andStatusEqualTo("NORMAL").andSentenceEqualTo(sentences);
        return this.dictionarySentenceMapper.selectByExample(example);
    }

    private void recordFlow(TranslateResultDto resultDto, String resultDtoStr) {
        YoudaoApiCallFlow flow = new YoudaoApiCallFlow();
        BeanUtils.copyProperties((Object)resultDto, (Object)flow);
        if (resultDto.getBasic() != null) {
            BeanUtils.copyProperties((Object)resultDto.getBasic(), (Object)flow);
        }
        flow.setId(Long.valueOf(IdWrokerUtils.nextId()));
        flow.setWeb(JSONObject.toJSONString((Object)resultDto.getWeb()));
        flow.setFromLanguage("EN");
        flow.setToLanguage("zh-CHS");
        flow.setExplains(resultDto.getBasic() == null ? null : JSONObject.toJSONString((Object)resultDto.getBasic().getExplains()));
        flow.setCreateTime(Calendar.getInstance().getTime());
        flow.setTranslation(JSONObject.toJSONString((Object)resultDto.getTranslation()));
        flow.setResponseData(resultDtoStr);
        this.youdaoMapper.insertSelective(flow);
    }

    private MultiValueMap<String, String> buildFormData(GetEnToCnTranslateRequest req) {
        String salt = String.valueOf(System.currentTimeMillis());
        String from = "EN";
        String to = "zh-CHS";
        String sign = YoudaoServiceImpl.md5((String)(this.config.getAppId() + req.getWordText() + salt + this.config.getAppKey()));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"q", (Object)req.getWordText());
        params.add((Object)"from", (Object)from);
        params.add((Object)"to", (Object)to);
        params.add((Object)"sign", (Object)sign);
        params.add((Object)"salt", (Object)salt);
        params.add((Object)"appKey", (Object)this.config.getAppId());
        params.add((Object)"voice", (Object)"4");
        return params;
    }

    public <T> T postFormData(String url, MultiValueMap<String, String> data, Class<T> returnClassType) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Accpet-Encoding", "gzip");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity(data, (MultiValueMap)headers);
        return (T)this.restTemplate.postForObject(url, (Object)formEntity, returnClassType, new Object[0]);
    }

    public String postFormData(String url, MultiValueMap<String, String> data) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Accpet-Encoding", "gzip");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity(data, (MultiValueMap)headers);
        return (String)this.restTemplate.postForObject(url, (Object)formEntity, String.class, new Object[0]);
    }

    public static String md5(String string) {
        if (string == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = string.getBytes("utf-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private void downLoadAudio(TranslateResultDto resultDto) throws Exception {
        CloseableHttpResponse data;
        if (resultDto == null || resultDto.getBasic() == null) {
            return;
        }
        DetailDto dto = resultDto.getBasic();
        if (StringUtils.isNotEmpty((CharSequence)dto.getUkSpeech())) {
            data = this.getAudioData(dto.getUkSpeech());
            dto.setUkSpeech(this.uploadToOss(data));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getUsSpeech())) {
            data = this.getAudioData(dto.getUsSpeech());
            dto.setUsSpeech(this.uploadToOss(data));
        }
    }

    private CloseableHttpResponse getAudioData(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet request = new HttpGet(url);
        request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) ...");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
        Header contentType = response.getEntity().getContentType();
        if (contentType.getValue().contains("json")) {
            log.error("\u8c03\u7528\u62a5\u9519 ,body :{}", (Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8"));
            httpclient.close();
            throw new Exception("\u8c03\u7528\u5f02\u5e38 tts\u5f02\u5e38");
        }
        return response;
    }

    private String uploadToOss(CloseableHttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        String fileNm = IdWrokerUtils.nextId() + ".mp3";
        String ossPath = this.aliOss.uploadObject2OSS(entity.getContent(), fileNm, entity.getContentLength(), entity.getContentType().getValue(), "youdaovoice/");
        entity.getContent().close();
        response.close();
        return ossPath;
    }

    public static String encode(String input) {
        if (input == null) {
            return "";
        }
        try {
            return URLEncoder.encode(input, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return input;
        }
    }
}

