/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.common.api.BaseBookService;
import com.ella.common.domain.BaseBook;
import com.ella.common.domain.BaseBookExample;
import com.ella.common.domain.BookQuestion;
import com.ella.common.domain.Constant;
import com.ella.common.domain.ConstantExample;
import com.ella.common.dto.BaseBookDto;
import com.ella.common.dto.BaseBookListRes;
import com.ella.common.dto.picbook.BaseBookDTO;
import com.ella.common.dto.picbook.BookAuthorRelation;
import com.ella.common.dto.picbook.BookPage;
import com.ella.common.dto.picbook.BookPreviewResource;
import com.ella.common.mapper.BaseBookMapper;
import com.ella.common.mapper.BookQuestionExtendsMapper;
import com.ella.common.mapper.ConstantMapper;
import com.ella.common.utils.Putil;
import com.ella.common.utils.ResponseBuildUtil;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.mq.BaseMsg;
import com.ella.frame.common.mq.MsgSender;
import com.ella.frame.common.mq.message.EnBookPushMsg;
import com.ella.frame.common.response.ResponseParams;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseBookServiceImpl
implements BaseBookService {
    private static final Logger log = LogManager.getLogger(BaseBookServiceImpl.class);
    @Autowired
    private BaseBookMapper baseBookMapper;
    @Autowired
    private ConstantMapper constantMapper;
    @Autowired
    private MsgSender msgSender;
    @Value(value="${service.cache:picBookStore}")
    private String serviceCache;
    @Autowired
    private BookQuestionExtendsMapper bookQuestionExtendsMapper;
    @Autowired
    private DistributedCache redisCache;

    public String addBaseBook(BaseBookDTO baseBookDTO) {
        JSONObject pagesJsonObj;
        com.ella.common.dto.picbook.BaseBook book = baseBookDTO.getBook();
        BaseBook baseBook = new BaseBook();
        BeanUtils.copyProperties((Object)book, (Object)baseBook);
        baseBook.setSeriesName(book.getBookSeriesName());
        baseBook.setBookScore(Float.valueOf(book.getBookScore().floatValue()));
        baseBook.setShelvesFlag(book.getCopyrightStatus());
        List bookAuthorRelationList = baseBookDTO.getBookAuthorRelationList();
        if (CollectionUtils.isNotEmpty((Collection)baseBookDTO.getBookResourceList())) {
            baseBookDTO.getBookResourceList().forEach(item -> {
                if ("BOOK_COVER".equals(item.getResourceType())) {
                    baseBook.setCoverUrl(item.getOssUrl());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)baseBookDTO.getBookModeResourceList())) {
            baseBookDTO.getBookModeResourceList().forEach(item -> {
                if ("normal".equals(item.getResource())) {
                    baseBook.setNormalUrl(item.getOssUrl());
                }
                if ("iPhone2208".equals(item.getResource())) {
                    baseBook.setIphoneUrl(item.getOssUrl());
                }
            });
        }
        baseBook.setBookPressName(book.getPublishName());
        if (CollectionUtils.isNotEmpty((Collection)baseBookDTO.getBookPreviewResourceList())) {
            this.deleteOld(baseBook.getBookCode(), baseBookDTO.getBookPreviewResourceList().stream().map(BookPreviewResource::getResourceType).collect(Collectors.toList()));
            baseBookDTO.getBookPreviewResourceList().forEach(item -> this.constantMapper.insertSelective(Constant.builder().itemCode(baseBook.getBookCode()).itemName(item.getOssUrl()).itemType(item.getResourceType()).build()));
        }
        if (CollectionUtils.isNotEmpty((Collection)bookAuthorRelationList)) {
            this.deleteOld(baseBook.getBookCode(), bookAuthorRelationList.stream().map(BookAuthorRelation::getAuthorType).collect(Collectors.toList()));
            bookAuthorRelationList.forEach(item -> this.constantMapper.insertSelective(Constant.builder().itemCode(baseBook.getBookCode()).itemName(item.getAuthorName()).itemType(item.getAuthorType()).build()));
        }
        if (Objects.nonNull(baseBookDTO.getGoods())) {
            this.deleteOld(baseBook.getBookCode(), Collections.singletonList("PICBOOKSRCPRICE"));
            this.constantMapper.insertSelective(Constant.builder().itemCode(baseBook.getBookCode()).itemName(String.valueOf(baseBookDTO.getGoods().getGoodsMarketprice().setScale(2))).itemType("PICBOOKSRCPRICE").build());
        }
        if (baseBook.getId() == null) {
            this.baseBookMapper.insertSelective(baseBook);
        } else {
            BaseBook baseBook1 = this.baseBookMapper.selectByBookCode(baseBook.getBookCode());
            if (baseBook1 == null) {
                this.baseBookMapper.insertSelective(baseBook);
            } else {
                Long l;
                Long l2;
                Long enVersion;
                if (!(Objects.equals(baseBook1.getIphoneUrl(), baseBook.getIphoneUrl()) && Objects.equals(baseBook1.getCoverUrl(), baseBook.getCoverUrl()) && Objects.equals(baseBook1.getNormalUrl(), baseBook.getNormalUrl()))) {
                    l2 = enVersion = baseBook1.getEnVersion();
                    l = enVersion = Long.valueOf(enVersion + 1L);
                    baseBook.setEnVersion(enVersion);
                }
                this.baseBookMapper.updateByBookCodeSelective(baseBook);
                l2 = enVersion = baseBook1.getEnVersion();
                l = enVersion = Long.valueOf(enVersion + 1L);
                baseBook.setEnVersion(enVersion);
                this.baseBookMapper.updateByPrimaryKeySelective(baseBook);
                this.evictBookCache();
            }
        }
        String pagesJsonStr = book.getPages();
        if (pagesJsonStr != null && (pagesJsonObj = JSON.parseObject((String)pagesJsonStr)) != null) {
            String pageArrStr = pagesJsonObj.getJSONArray("pages").toJSONString();
            List pages = JSON.parseArray((String)pageArrStr, BookPage.class);
            pages.forEach(page -> {
                List groups = page.getQuestionGroups();
                if (groups == null || groups.size() == 0) {
                    BookQuestion record = BookQuestion.builder().bookCode(book.getBookCode()).pageId(String.valueOf(page.getPageId())).groupId("").questionId("").build();
                    BookQuestion oldItem = this.bookQuestionExtendsMapper.selectByItem(record);
                    record.setPageFirstAbility(page.getFirstAbilityType());
                    record.setPageSecondAbility(page.getSecondAbilityType());
                    this.replaceIntoBookQuestion(oldItem, record);
                } else {
                    groups.forEach(group -> {
                        List questions = group.getQuestions();
                        questions.forEach(question -> {
                            BookQuestion record = BookQuestion.builder().bookCode(book.getBookCode()).pageId(String.valueOf(page.getPageId())).groupId(String.valueOf(group.getGroupId())).questionId(String.valueOf(question.getQuestionId())).build();
                            BookQuestion oldItem = this.bookQuestionExtendsMapper.selectByItem(record);
                            record.setPageFirstAbility(page.getFirstAbilityType());
                            record.setPageSecondAbility(page.getSecondAbilityType());
                            record.setFirstAbilityType(question.getFirstAbilityType());
                            record.setSecondAbilityType(question.getSecondAbilityType());
                            this.replaceIntoBookQuestion(oldItem, record);
                        });
                    });
                }
            });
        }
        return baseBookDTO.getBook().getBookCode();
    }

    private void evictBookCache() {
        String key = "service_resource_" + this.serviceCache + ":BaseBookMapper";
        this.redisCache.incr(key);
    }

    private void replaceIntoBookQuestion(BookQuestion oldItem, BookQuestion record) {
        if (oldItem == null) {
            record.setCreateTime(new Date());
            this.bookQuestionExtendsMapper.insertSelective(record);
        } else {
            record.setUpdateTime(new Date());
            this.bookQuestionExtendsMapper.updateByPrimaryKeySelective(record);
        }
    }

    private void deleteOld(String code, List<String> itemTypes) {
        if (StringUtils.isBlank((String)code) || CollectionUtils.isEmpty(itemTypes)) {
            return;
        }
        ConstantExample example = new ConstantExample();
        example.createCriteria().andItemCodeEqualTo(code).andItemTypeIn(itemTypes);
        this.constantMapper.deleteByExample(example);
    }

    @RequestMapping(value={"v1/baseBookList"}, method={RequestMethod.POST})
    public ResponseParams baseBookList(@RequestBody BaseBookListRes res) {
        log.info("\u83b7\u53d6\u52a8\u753b\u4e66\u5217\u8868:--{}", (Object)JSONObject.toJSONString((Object)res));
        BaseBookExample baseBookExample = new BaseBookExample();
        BaseBookExample.Criteria criteria = baseBookExample.createCriteria();
        baseBookExample.setOrderByClause("update_time desc");
        if (StringUtils.isNotEmpty((String)res.getName())) {
            criteria.andSeriesNameLike(res.getName()).andStatusEqualTo("NORMAL");
            baseBookExample.or().andBookNameLike(res.getName()).andStatusEqualTo("NORMAL");
        }
        PageHelper.startPage((int)res.getPageNo(), (int)res.getPageSize());
        List baseBooks = this.baseBookMapper.selectByExample(baseBookExample);
        return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Putil.build((List)baseBooks));
    }

    @RequestMapping(value={"v1/getBookInfo"}, method={RequestMethod.GET})
    public ResponseParams getBookInfo(@RequestParam(value="id") String id) {
        log.info("\u8bf7\u6c42\u52a8\u753b\u4e66\u8be6\u60c5:  {}", (Object)Long.parseLong(id));
        BaseBook baseBook = this.baseBookMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        BaseBookDto baseBookDto = new BaseBookDto();
        BeanUtils.copyProperties((Object)baseBook, (Object)baseBookDto);
        List constants = this.constantMapper.selectConcatNameGroupTypeByCode(baseBook.getBookCode());
        constants.forEach(item -> {
            if ("AUTHOR_REVIEW".equals(item.getItemType())) {
                baseBookDto.setReviewerMan(item.getItemName());
            }
            if ("AUTHOR_AUDIO".equals(item.getItemType())) {
                baseBookDto.setRadioMan(item.getItemName());
            }
            if ("AUTHOR_DESIGN".equals(item.getItemType())) {
                baseBookDto.setInteractionEffect(item.getItemName());
            }
            if ("AUTHOR_ART".equals(item.getItemType())) {
                baseBookDto.setPicHandle(item.getItemName());
            }
            if ("AUTHOR_SCRIPT".equals(item.getItemType())) {
                baseBookDto.setStoryboard(item.getItemName());
            }
            if ("PICBOOKSRCPRICE".equals(item.getItemType())) {
                baseBookDto.setGoodsPrice(item.getItemName());
            }
        });
        return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)baseBookDto);
    }

    public Boolean enBookPush(String bookCode) {
        if (StringUtils.isBlank((String)bookCode)) {
            return false;
        }
        try {
            this.msgSender.send((BaseMsg)EnBookPushMsg.builder().body(bookCode).build());
            log.info("enBookPush {} finished", (Object)bookCode);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

