/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.configure.rocketmq.msghandler;

import com.alibaba.fastjson.JSONObject;
import com.ella.common.configure.rocketmq.msghandler.EnBookPushHendler;
import com.ella.common.dto.picbook.EllaBookBaseReq;
import com.ella.common.dto.picbook.EllaBookBaseRes;
import com.ella.common.service.BaseBookServiceImpl;
import com.ella.common.utils.HttpUtils;
import com.ella.frame.common.mq.MsgHandler;
import com.ella.frame.common.mq.message.EnBookPushMsg;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EnBookPushHendler
implements MsgHandler<EnBookPushMsg> {
    private static final Logger log = LogManager.getLogger(EnBookPushHendler.class);
    private static String BRACE = "{";
    @Value(value="${ella.BookUrl}")
    private String ellaBookUrl;
    @Autowired
    private BaseBookServiceImpl service;

    public boolean process(EnBookPushMsg msg) {
        log.info("\u770b\u4e662.0\u63a8\u9001\u53d8\u66f4bookCode--------------> {}", (Object)msg.toString());
        List bookCodes = this.getBookCodes(msg.getBody());
        if (CollectionUtils.isEmpty((Collection)bookCodes)) {
            return false;
        }
        for (String bookCode : bookCodes) {
            this.doEnBookPush(bookCode);
        }
        return true;
    }

    private List<String> getBookCodes(String msg) {
        try {
            TmpBooks tmpBooks = (TmpBooks)JSONObject.parseObject((String)msg, TmpBooks.class);
            return tmpBooks.getBookCodeList();
        }
        catch (Exception e) {
            if (msg.contains(BRACE)) {
                return null;
            }
            return Collections.singletonList(msg);
        }
    }

    private void doEnBookPush(String bookCode) {
        log.info("enBookPush {} begin", (Object)bookCode);
        HashMap<String, String> map = new HashMap<String, String>(2);
        EllaBookBaseReq ellaBookBaseReq = new EllaBookBaseReq();
        ellaBookBaseReq.setBookCode(bookCode);
        ellaBookBaseReq.setType("BookAuthorRelations,BookResources,BookModeResources,BookPreviewResources");
        map.put("method", "ella.book.getBaseBook");
        map.put("content", JSONObject.toJSONString((Object)ellaBookBaseReq));
        String result = HttpUtils.doPost((String)this.ellaBookUrl, map);
        log.info("\u770b\u4e662.0\u8fd4\u56de\u56fe\u4e66\u4fe1\u606f\uff1a{}", (Object)result);
        EllaBookBaseRes baseBookDTO = (EllaBookBaseRes)JSONObject.parseObject((String)result, EllaBookBaseRes.class);
        this.service.addBaseBook(baseBookDTO.getData());
        log.info("enBookPush {} finish", (Object)bookCode);
    }
}

