/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.configure.rocketmq;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.ella.frame.common.mq.BaseMsg;
import com.ella.frame.common.mq.MqProperties;
import com.ella.frame.common.mq.MsgSender;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocketMqConfig
implements MsgSender {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConfig.class);
    @Autowired
    private MessageListener listener;
    @Autowired
    private MqProperties mqProperties;
    private Producer producer;

    @PostConstruct
    public void initProducerAndConsumer() {
        this.configTaskConsumer();
        this.configProducer();
    }

    private void configProducer() {
        Properties properties = this.commonProperties();
        properties.put("SendMsgTimeoutMillis", "2000");
        this.producer = ONSFactory.createProducer((Properties)properties);
        this.producer.start();
        log.info("Aliyun message producer for topic {} started.", (Object)this.mqProperties.getTopic());
    }

    private void configTaskConsumer() {
        Properties properties = this.commonProperties();
        properties.put("ConsumerId", this.mqProperties.getCid());
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.subscribe(this.mqProperties.getTopic(), this.mqProperties.getTags(), this.listener);
        consumer.start();
        log.info("Aliyun message consumer {} for topic {} started.", (Object)this.mqProperties.getCid(), (Object)this.mqProperties.getTopic());
    }

    private Properties commonProperties() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.mqProperties.getAccessKey());
        properties.put("SecretKey", this.mqProperties.getSecretKey());
        properties.put("ONSAddr", this.mqProperties.getOnsAddr());
        return properties;
    }

    public void send(BaseMsg msg) {
        try {
            String msgContent = JSON.toJSONString((Object)msg);
            Message message = new Message(this.mqProperties.getTopic(), msg.getTag(), msg.getId(), msgContent.getBytes());
            this.producer.send(message);
            log.info("Message sended -{}.", (Object)msgContent);
        }
        catch (Exception e) {
            log.error("Message send error -{}.", (Throwable)e);
        }
    }
}

