/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.configure.rocketmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.common.configure.rocketmq.DefaultMsgHandlerDispatcher;
import com.ella.frame.common.mq.BaseMsg;
import com.ella.frame.common.mq.MqUtil;
import com.ella.frame.common.mq.MsgHandler;
import com.ella.frame.common.mq.MsgHandlerDispatcher;
import com.ella.frame.lock.DistributedLocker;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DefaultMsgHandlerDispatcher
implements ApplicationContextAware,
MsgHandlerDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultMsgHandlerDispatcher.class);
    private Map<String, HandlerNMsgType> handlers = new ConcurrentHashMap();
    @Autowired
    private DistributedLocker distributedLocker;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.assembleHandlers(applicationContext);
    }

    private void assembleHandlers(ApplicationContext applicationContext) {
        Map handlerBeans = applicationContext.getBeansOfType(MsgHandler.class);
        handlerBeans.forEach((k, v) -> {
            Class msgType = this.resolveHandlerMsgType(v);
            this.handlers.put(MqUtil.handlerKeyByMsgType((Class)msgType), new HandlerNMsgType(v, msgType));
            log.info("Message {} handler {} assembled.", (Object)msgType.getSimpleName(), (Object)v.getClass().getSimpleName());
        });
    }

    private Class<?> resolveHandlerMsgType(MsgHandler handler) {
        ResolvableType[] ifs;
        Class msgType = null;
        for (ResolvableType rt : ifs = ResolvableType.forClass(handler.getClass()).getInterfaces()) {
            if (!rt.resolve().equals(MsgHandler.class)) continue;
            msgType = rt.getGeneric(new int[]{0}).resolve();
            break;
        }
        return msgType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean dispatch(String msgContent) {
        if (StringUtils.isBlank((CharSequence)msgContent)) {
            return false;
        }
        BaseMsg msg = null;
        JSONObject msgJsonObj = JSON.parseObject((String)msgContent);
        String handlerKey = msgJsonObj.getString("handlerKey");
        if (StringUtils.isBlank((CharSequence)handlerKey)) {
            return false;
        }
        HandlerNMsgType handlerNMsgType = (HandlerNMsgType)this.handlers.get(handlerKey);
        if (Objects.isNull(handlerNMsgType)) {
            log.info("Handler for [{}] does not existed!", (Object)handlerKey);
            return false;
        }
        msg = (BaseMsg)JSON.parseObject((String)msgContent, (Class)handlerNMsgType.getMsgType());
        Objects.requireNonNull(msg, "\u6d88\u606f\u8f6c\u6362\u5931\u8d25\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String cclKey = this.cclKey(msgContent, msg);
        try {
            this.distributedLocker.lock(cclKey, 1);
            boolean bl = handlerNMsgType.getHandler().process(msg);
            return bl;
        }
        finally {
            this.distributedLocker.unlock(cclKey);
        }
    }

    private String cclKey(String msgContent, BaseMsg msg) {
        if (StringUtils.isBlank((CharSequence)msg.getUid())) {
            return String.format("HANDLE:%s", DigestUtils.md5Hex((String)msgContent));
        }
        return String.format("HANDLE:%s:%s", msg.getHandlerKey(), msg.getUid());
    }
}

